#!/usr/bin/env python3
import subprocess
from gi.repository import GLib

def start_backend_refresh():
    """
    Runs a DNF refresh in the background.
    Can be called from the main app via GLib.idle_add.
    """
    def run_refresh():
        try:
            # Example: refresh the DNF metadata
            subprocess.run(["pkexec", "dnf", "makecache"], check=True)
        except subprocess.CalledProcessError as e:
            print(f"Refresh failed: {e}")
        except Exception as e:
            print(f"Unexpected error during refresh: {e}")

    GLib.idle_add(run_refresh)

