
Summary: Graphical frontend for DNF.
Name: dnf-package-manager
Version: 1.13
Release: %mkrel 4
License: GPLv2+
Group: System/Configuration/Packaging
URL: http://www.pclinuxos.com/
Source0: %{name}-%{version}.tar.xz
Requires: python3
Requires: polkit
Requires: dnf
Requires: dnfzypp-sources-list
Requires: google-noto-emoji-color-fonts

%description
DNF-Package Manager is a graphical package management program for dnf.
It provides the same features as the dnf command line
utility with a GUI front-end based on Python 3.

%prep
%setup -q 

#%build

%install
rm -fr %buildroot
mkdir -p %buildroot/%{_bindir}
mkdir -p %{buildroot}/usr/share/polkit-1/actions
mkdir -p %buildroot/%{_datadir}/pixmaps
mkdir -p %buildroot/%{_datadir}/applications

#bin file
install -m 0755 dnf5_launcher %buildroot/%{_bindir}/dnf5_launcher

#desktop file
install -m 0644 dnf-package-manager.desktop %buildroot/%{_datadir}/applications/dnf-package-manager.desktop

#install icon for program
install -m 0644 dnf-package-manager.png %buildroot/%{_datadir}/pixmaps/dnf-package-manager.png

#polkit policy to run program as admin
install -m 0644 org.pclinuxos.dnf5_launcher.policy %{buildroot}/usr/share/polkit-1/actions/org.pclinuxos.dnf5_launcher.policy

#directory
mkdir -p %buildroot/%{_datadir}/%{name}
cp -r %{name}/*.py %buildroot/%{_datadir}/%{name}
mv -f %{name}/repos %buildroot/%{_datadir}/%{name}

%clean
rm -rf %buildroot

%files
%defattr(-, root, root)
%{_bindir}/*
%{_datadir}/applications/%{name}.desktop
%{_datadir}/%{name}
%{_datadir}/pixmaps/%{name}.png
%{_datadir}/polkit-1/actions/org.pclinuxos.dnf5_launcher.policy

%post
update-menus

%postun
update-menus


%changelog
* Mon Jan 9 2026 adrianomorselli - 1.13-4ufficiozero2026
- adjust repo

* Thu Jan 8 2026 adrianomorselli - 1.13-3ufficiozero2026
- rebuilded for lorena

* Sun Sep 14 2025 tex - 1.13-2pclos2025
- add --allowerasing to remove conflicts when
- installing a package

* Thu Sep 04 2025 Upgreyed - 1.13-1pclos2025
- added scroll effect to transaction
- fixed for failed or suceeded transaction

* Mon Sep 01 2025 Upgreyed - 1.12-1pclos2025
- added separation tagging for srpm and rpm

* Mon Sep 01 2025 Upgreyed - 1.11-1pclos2025
- fix and add more dialog emoji icons 
- add preferences terminal command options
- add preferences terminal help dialog

* Sun Aug 31 2025 Upgreyed - 1.10-1pclos2025
- fixed confirmation dialog to scrolling option

* Thu Aug 28 2025 Upgreyed - 1.9-1pclos2025
- removed unneeded dialog removal option

* Wed Aug 27 2025 Upgreyed - 1.8-1pclos2025
- fix log window scrolling effect
- removed local repo as requested by Tex

* Sun Aug 24 2025 Upgreyed - 1.7-1pclos2025
- added icon fix for panel 
- fixed double execution for main gui
 
* Sun Aug 24 2025 Upgreyed - 1.6-1pclos2025
- more ajustments to trigger a refresh after install, reinstall 

* Sun Aug 24 2025 Upgreyed - 1.5-1pclos2025
- fix to trigger a refresh after install, reinstall 

* Sat Aug 23 2025 Upgreyed - 1.4-1pclos2025
- fix faulty tickbox switching repo names 

* Sat Aug 23 2025 Upgreyed - 1.3-1pclos2025
- fix faulty auto upgrade when switching repos 

* Thu Aug 21 2025 Upgreyed - 1.2-1pclos2025
- fix faulty error message 

* Thu Aug 21 2025 Upgreyed - 1.1-1pclos2025
- fix non destructive error message  
- fix typo in repositories list 
- ajustment in dialog sizes

* Thu Aug 21 2025 Upgreyed - 1.0-1pclos2025
- fix repositories section with complete urls 

* Thu Aug 21 2025 Upgreyed - 0.9-1pclos2025
- removed yad gui to main script
- fix repositories added
- added python gui to replace yad

* Wed Aug 20 2025 Upgreyed - 0.7-2pclos2025
- added distro-sync patch
- Added yad gui to main script

* Wed Aug 20 2025 Upgreyed - 0.7-1pclos2025
- update gui to main script

* Tue Aug 19 2025 Upgreyed - 0.6-1pclos2025
- update gui

* Mon Aug 18 2025 tex - 0.5-1pclos2025
- updated functions

* Sun Aug 17 2025 tex - 0.1-1pclos2025
- create package
