import wasm from "./diplomat-wasm.mjs"
import * as diplomatRuntime from "./diplomat-runtime.mjs"
import { ICU4XError_js_to_rust, ICU4XError_rust_to_js } from "./ICU4XError.mjs"

export const ICU4XAnyCalendarKind_js_to_rust = {
  "Iso": 0,
  "Gregorian": 1,
  "Buddhist": 2,
  "Japanese": 3,
  "JapaneseExtended": 4,
  "Ethiopian": 5,
  "EthiopianAmeteAlem": 6,
  "Indian": 7,
  "Coptic": 8,
  "Dangi": 9,
  "Chinese": 10,
  "Hebrew": 11,
  "IslamicCivil": 12,
  "IslamicObservational": 13,
  "IslamicTabular": 14,
  "IslamicUmmAlQura": 15,
  "Persian": 16,
  "Roc": 17,
};

export const ICU4XAnyCalendarKind_rust_to_js = {
  [0]: "Iso",
  [1]: "Gregorian",
  [2]: "Buddhist",
  [3]: "Japanese",
  [4]: "JapaneseExtended",
  [5]: "Ethiopian",
  [6]: "EthiopianAmeteAlem",
  [7]: "Indian",
  [8]: "Coptic",
  [9]: "Dangi",
  [10]: "Chinese",
  [11]: "Hebrew",
  [12]: "IslamicCivil",
  [13]: "IslamicObservational",
  [14]: "IslamicTabular",
  [15]: "IslamicUmmAlQura",
  [16]: "Persian",
  [17]: "Roc",
};

export const ICU4XAnyCalendarKind = {
  "Iso": "Iso",
  "Gregorian": "Gregorian",
  "Buddhist": "Buddhist",
  "Japanese": "Japanese",
  "JapaneseExtended": "JapaneseExtended",
  "Ethiopian": "Ethiopian",
  "EthiopianAmeteAlem": "EthiopianAmeteAlem",
  "Indian": "Indian",
  "Coptic": "Coptic",
  "Dangi": "Dangi",
  "Chinese": "Chinese",
  "Hebrew": "Hebrew",
  "IslamicCivil": "IslamicCivil",
  "IslamicObservational": "IslamicObservational",
  "IslamicTabular": "IslamicTabular",
  "IslamicUmmAlQura": "IslamicUmmAlQura",
  "Persian": "Persian",
  "Roc": "Roc",
};
