## API Report File for "@lumino/datagrid"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { IDisposable } from '@lumino/disposable';
import { IMessageHandler } from '@lumino/messaging';
import { ISignal } from '@lumino/signaling';
import { Message } from '@lumino/messaging';
import { ReadonlyJSONObject } from '@lumino/coreutils';
import { Signal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';

// @public
export abstract class AsyncCellRenderer extends CellRenderer {
    abstract isReady(config: CellRenderer.CellConfig): boolean;
    abstract load(config: CellRenderer.CellConfig): Promise<void>;
    abstract paintPlaceholder(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
}

// @public
export class BasicKeyHandler implements DataGrid.IKeyHandler {
    dispose(): void;
    get isDisposed(): boolean;
    protected onArrowDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowLeft(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowRight(grid: DataGrid, event: KeyboardEvent): void;
    protected onArrowUp(grid: DataGrid, event: KeyboardEvent): void;
    protected onDelete(grid: DataGrid, event: KeyboardEvent): void;
    protected onEscape(grid: DataGrid, event: KeyboardEvent): void;
    protected onKeyC(grid: DataGrid, event: KeyboardEvent): void;
    onKeyDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onPageDown(grid: DataGrid, event: KeyboardEvent): void;
    protected onPageUp(grid: DataGrid, event: KeyboardEvent): void;
}

// @public
export class BasicMouseHandler implements DataGrid.IMouseHandler {
    cursorForHandle(handle: ResizeHandle): string;
    dispose(): void;
    get isDisposed(): boolean;
    onContextMenu(grid: DataGrid, event: MouseEvent): void;
    onMouseDoubleClick(grid: DataGrid, event: MouseEvent): void;
    onMouseDown(grid: DataGrid, event: MouseEvent): void;
    onMouseHover(grid: DataGrid, event: MouseEvent): void;
    onMouseLeave(grid: DataGrid, event: MouseEvent): void;
    onMouseMove(grid: DataGrid, event: MouseEvent): void;
    onMouseUp(grid: DataGrid, event: MouseEvent): void;
    onWheel(grid: DataGrid, event: WheelEvent): void;
    get pressData(): PressData.PressData | null;
    // (undocumented)
    protected _pressData: PressData.PressData | null;
    release(): void;
}

// @public
export class BasicSelectionModel extends SelectionModel {
    clear(): void;
    currentSelection(): SelectionModel.Selection | null;
    get cursorColumn(): number;
    get cursorRow(): number;
    get isEmpty(): boolean;
    moveCursorWithinSelections(direction: SelectionModel.CursorMoveDirection): void;
    protected onDataModelChanged(sender: DataModel, args: DataModel.ChangedArgs): void;
    select(args: SelectionModel.SelectArgs): void;
    selections(): IterableIterator<SelectionModel.Selection>;
}

// @public
export class BooleanCellEditor extends CellEditor {
    dispose(): void;
    protected getInput(): boolean | null;
    handleEvent(event: Event): void;
    protected startEditing(): void;
}

// @public (undocumented)
export type CellDataType = 'string' | 'number' | 'integer' | 'boolean' | 'date' | 'string:option' | 'number:option' | 'integer:option' | 'date:option' | 'string:dynamic-option' | 'number:dynamic-option' | 'integer:dynamic-option' | 'date:dynamic-option';

// @public
export abstract class CellEditor implements ICellEditor, IDisposable {
    constructor();
    cancel(): void;
    protected cell: CellEditor.CellConfig;
    protected commit(cursorMovement?: SelectionModel.CursorMoveDirection): boolean;
    protected createValidatorBasedOnType(): ICellInputValidator | undefined;
    dispose(): void;
    edit(cell: CellEditor.CellConfig, options?: ICellEditOptions): void;
    protected editorContainer: HTMLDivElement;
    // Warning: (ae-forgotten-export) The symbol "Private" needs to be exported by the entry point index.d.ts
    protected getCellInfo(cell: CellEditor.CellConfig): Private.ICellInfo;
    protected abstract getInput(): any;
    protected inputChanged: Signal<this, void>;
    get isDisposed(): boolean;
    protected onCancel?: () => void;
    protected onCommit?: (response: ICellEditResponse) => void;
    protected setValidity(valid: boolean, message?: string): void;
    protected abstract startEditing(): void;
    protected updatePosition(): void;
    protected validate(): void;
    protected validator: ICellInputValidator | undefined;
    protected get validInput(): boolean;
    protected validityNotification: CellEditor.Notification | null;
    protected viewportOccluder: HTMLDivElement;
}

// @public
export namespace CellEditor {
    export type CellConfig = {
        readonly grid: DataGrid;
        readonly row: number;
        readonly column: number;
    };
    export class Notification extends Widget {
        constructor(options: Notification.IOptions);
        handleEvent(event: Event): void;
        get message(): string;
        set message(value: string);
        get messageNode(): HTMLSpanElement;
        protected onAfterDetach(msg: Message): void;
        protected onBeforeAttach(msg: Message): void;
        protected onUpdateRequest(msg: Message): void;
        get placement(): Notification.Placement;
        set placement(value: Notification.Placement);
    }
    export namespace Notification {
        export function createNode(): HTMLElement;
        export interface IOptions {
            message?: string;
            placement?: Placement;
            target: HTMLElement;
            timeout?: number;
        }
        export type Placement = 'top' | 'bottom' | 'left' | 'right';
    }
}

// @public
export class CellEditorController implements ICellEditorController {
    cancel(): void;
    edit(cell: CellEditor.CellConfig, options?: ICellEditOptions): boolean;
    setEditor(identifier: EditorOverrideIdentifier, editor: ICellEditor | Resolver): void;
}

// @public
export interface CellGroup {
    // (undocumented)
    c1: number;
    // (undocumented)
    c2: number;
    // (undocumented)
    r1: number;
    // (undocumented)
    r2: number;
}

// @public
export namespace CellGroup {
    export function areCellGroupsIntersecting(group1: CellGroup, group2: CellGroup): boolean;
    export function areCellGroupsIntersectingAtAxis(group1: CellGroup, group2: CellGroup, axis: 'row' | 'column'): boolean;
    export function getCellGroupsAtColumn(dataModel: DataModel, rgn: DataModel.CellRegion, column: number): CellGroup[];
    export function getCellGroupsAtRegion(dataModel: DataModel, rgn: DataModel.CellRegion): CellGroup[];
    export function getCellGroupsAtRow(dataModel: DataModel, rgn: DataModel.CellRegion, row: number): CellGroup[];
    export function getGroup(dataModel: DataModel, rgn: DataModel.CellRegion, row: number, column: number): CellGroup | null;
    export function getGroupIndex(dataModel: DataModel, rgn: DataModel.CellRegion, row: number, column: number): number;
    export function joinCellGroups(groups: CellGroup[]): CellGroup;
    export function joinCellGroupsIntersectingAtAxis(dataModel: DataModel, regions: DataModel.CellRegion[], axis: 'row' | 'column', group: CellGroup): CellGroup;
    export function joinCellGroupWithMergedCellGroups(dataModel: DataModel, group: CellGroup, region: DataModel.CellRegion): CellGroup;
}

// @public
export abstract class CellRenderer {
    abstract paint(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
}

// @public
export namespace CellRenderer {
    export type CellConfig = {
        readonly x: number;
        readonly y: number;
        readonly height: number;
        readonly width: number;
        readonly region: DataModel.CellRegion;
        readonly row: number;
        readonly column: number;
        readonly value: any;
        readonly metadata: DataModel.Metadata;
    };
    export type ConfigFunc<T> = (config: CellConfig) => T;
    export type ConfigOption<T> = T | ConfigFunc<T>;
    export function resolveOption<T>(option: ConfigOption<T>, config: CellConfig): T;
}

// @public
export type ConfigFunc<T> = (config: CellEditor.CellConfig) => T;

// @public
export type ConfigOption<T> = T | ConfigFunc<T>;

// @public
export class DataGrid extends Widget {
    constructor(options?: DataGrid.IOptions);
    get bodyHeight(): number;
    get bodyWidth(): number;
    protected get canvasGC(): CanvasRenderingContext2D;
    get cellRenderers(): RendererMap;
    set cellRenderers(value: RendererMap);
    columnAt(region: DataModel.ColumnRegion, offset: number): number;
    columnCount(region: DataModel.ColumnRegion): number;
    protected get columnHeaderSections(): SectionList;
    columnOffset(region: DataModel.ColumnRegion, index: number): number;
    protected get columnSections(): SectionList;
    columnSize(region: DataModel.ColumnRegion, index: number): number;
    get copyConfig(): DataGrid.CopyConfig;
    set copyConfig(value: DataGrid.CopyConfig);
    copyToClipboard(): void;
    get currentViewport(): DataGrid.IBodyRegion | undefined;
    get dataModel(): DataModel | null;
    set dataModel(value: DataModel | null);
    get defaultSizes(): DataGrid.DefaultSizes;
    set defaultSizes(value: DataGrid.DefaultSizes);
    dispose(): void;
    protected drawCornerHeaderRegion(rx: number, ry: number, rw: number, rh: number): void;
    get editable(): boolean;
    get editingEnabled(): boolean;
    set editingEnabled(enabled: boolean);
    get editorController(): ICellEditorController | null;
    set editorController(controller: ICellEditorController | null);
    fitColumnNames(area?: DataGrid.ColumnFitType, padding?: number, numCols?: number): void;
    handleEvent(event: Event): void;
    get headerHeight(): number;
    get headerVisibility(): DataGrid.HeaderVisibility;
    set headerVisibility(value: DataGrid.HeaderVisibility);
    get headerWidth(): number;
    hitTest(clientX: number, clientY: number): DataGrid.HitTestResult;
    get keyHandler(): DataGrid.IKeyHandler | null;
    set keyHandler(value: DataGrid.IKeyHandler | null);
    mapToLocal(clientX: number, clientY: number): {
        lx: number;
        ly: number;
    };
    mapToVirtual(clientX: number, clientY: number): {
        vx: number;
        vy: number;
    };
    get maxScrollX(): number;
    get maxScrollY(): number;
    messageHook(handler: IMessageHandler, msg: Message): boolean;
    get minimumSizes(): DataGrid.DefaultSizes;
    set minimumSizes(value: DataGrid.DefaultSizes);
    get mouseHandler(): DataGrid.IMouseHandler | null;
    set mouseHandler(value: DataGrid.IMouseHandler | null);
    moveCursor(direction: SelectionModel.CursorMoveDirection): void;
    protected onActivateRequest(msg: Message): void;
    protected onAfterDetach(msg: Message): void;
    protected onBeforeAttach(msg: Message): void;
    protected onBeforeShow(msg: Message): void;
    protected onResize(msg: Widget.ResizeMessage): void;
    get pageHeight(): number;
    get pageWidth(): number;
    protected paintContent(rx: number, ry: number, rw: number, rh: number): void;
    processMessage(msg: Message): void;
    protected repaintContent(): void;
    protected repaintOverlay(): void;
    protected repaintRegion(region: DataModel.CellRegion, r1: number, c1: number, r2: number, c2: number): void;
    resetColumns(region: DataModel.ColumnRegion | 'all'): void;
    resetRows(region: DataModel.RowRegion | 'all'): void;
    resizeColumn(region: DataModel.ColumnRegion, index: number, size: number | null): void;
    resizeRow(region: DataModel.RowRegion, index: number, size: number): void;
    rowAt(region: DataModel.RowRegion, offset: number): number;
    rowCount(region: DataModel.RowRegion): number;
    protected get rowHeaderSections(): SectionList;
    rowOffset(region: DataModel.RowRegion, index: number): number;
    protected get rowSections(): SectionList;
    rowSize(region: DataModel.RowRegion, index: number): number;
    scrollBy(dx: number, dy: number): void;
    scrollByPage(dir: 'up' | 'down' | 'left' | 'right'): void;
    scrollByStep(dir: 'up' | 'down' | 'left' | 'right'): void;
    scrollTo(x: number, y: number): void;
    scrollToCell(row: number, column: number): void;
    scrollToColumn(column: number): void;
    scrollToCursor(): void;
    scrollToRow(row: number): void;
    get scrollX(): number;
    get scrollY(): number;
    get selectionModel(): SelectionModel | null;
    set selectionModel(value: SelectionModel | null);
    get stretchLastColumn(): boolean;
    set stretchLastColumn(value: boolean);
    get stretchLastRow(): boolean;
    set stretchLastRow(value: boolean);
    get style(): DataGrid.Style;
    set style(value: DataGrid.Style);
    get totalHeight(): number;
    get totalWidth(): number;
    get viewport(): Widget;
    get viewportHeight(): number;
    get viewportWidth(): number;
}

// @public
export namespace DataGrid {
    export type ColumnFitType = 'all' | 'row-header' | 'body';
    export type CopyConfig = {
        readonly separator: string;
        readonly headers: 'none' | 'row' | 'column' | 'all';
        readonly format: CopyFormatFunc;
        readonly warningThreshold: number;
    };
    export type CopyFormatArgs = {
        region: DataModel.CellRegion;
        row: number;
        column: number;
        value: any;
        metadata: DataModel.Metadata;
    };
    export type CopyFormatFunc = (args: CopyFormatArgs) => string;
    export function copyFormatGeneric(args: CopyFormatArgs): string;
    export type DefaultSizes = {
        readonly rowHeight: number;
        readonly columnWidth: number;
        readonly rowHeaderWidth: number;
        readonly columnHeaderHeight: number;
    };
    export type HeaderVisibility = 'all' | 'row' | 'column' | 'none';
    export type HitTestResult = {
        readonly region: DataModel.CellRegion | 'void';
        readonly row: number;
        readonly column: number;
        readonly x: number;
        readonly y: number;
        readonly width: number;
        readonly height: number;
    };
    export interface IBodyRegion {
        firstColumn: number;
        firstRow: number;
        lastColumn: number;
        lastRow: number;
    }
    export interface IKeyHandler extends IDisposable {
        onKeyDown(grid: DataGrid, event: KeyboardEvent): void;
    }
    export interface IMouseHandler extends IDisposable {
        onContextMenu(grid: DataGrid, event: MouseEvent): void;
        onMouseDoubleClick(grid: DataGrid, event: MouseEvent): void;
        onMouseDown(grid: DataGrid, event: MouseEvent): void;
        onMouseHover(grid: DataGrid, event: MouseEvent): void;
        onMouseLeave(grid: DataGrid, event: MouseEvent): void;
        onMouseMove(grid: DataGrid, event: MouseEvent): void;
        onMouseUp(grid: DataGrid, event: MouseEvent): void;
        onWheel(grid: DataGrid, event: WheelEvent): void;
        release(): void;
    }
    export interface IOptions {
        cellRenderers?: RendererMap;
        copyConfig?: CopyConfig;
        defaultRenderer?: CellRenderer;
        defaultSizes?: DefaultSizes;
        headerVisibility?: HeaderVisibility;
        minimumSizes?: MinimumSizes;
        stretchLastColumn?: boolean;
        stretchLastRow?: boolean;
        style?: Style;
    }
    export type MinimumSizes = {
        readonly rowHeight: number;
        readonly columnWidth: number;
        readonly rowHeaderWidth: number;
        readonly columnHeaderHeight: number;
    };
    const defaultStyle: Style;
    const defaultSizes: DefaultSizes;
    const minimumSizes: MinimumSizes;
    const defaultCopyConfig: CopyConfig;
    export type Style = {
        readonly voidColor?: string;
        readonly backgroundColor?: string;
        readonly rowBackgroundColor?: (index: number) => string;
        readonly columnBackgroundColor?: (index: number) => string;
        readonly gridLineColor?: string;
        readonly verticalGridLineColor?: string;
        readonly horizontalGridLineColor?: string;
        readonly headerBackgroundColor?: string;
        readonly headerGridLineColor?: string;
        readonly headerVerticalGridLineColor?: string;
        readonly headerHorizontalGridLineColor?: string;
        readonly selectionFillColor?: string;
        readonly selectionBorderColor?: string;
        readonly cursorFillColor?: string;
        readonly cursorBorderColor?: string;
        readonly headerSelectionFillColor?: string;
        readonly headerSelectionBorderColor?: string;
        readonly scrollShadow?: {
            readonly size: number;
            readonly color1: string;
            readonly color2: string;
            readonly color3: string;
        };
    };
}

// @public
export abstract class DataModel {
    get changed(): ISignal<this, DataModel.ChangedArgs>;
    abstract columnCount(region: DataModel.ColumnRegion): number;
    abstract data(region: DataModel.CellRegion, row: number, column: number): any;
    protected emitChanged(args: DataModel.ChangedArgs): void;
    group(region: DataModel.CellRegion, groupIndex: number): CellGroup | null;
    groupCount(region: DataModel.CellRegion): number;
    metadata(region: DataModel.CellRegion, row: number, column: number): DataModel.Metadata;
    abstract rowCount(region: DataModel.RowRegion): number;
}

// @public
export namespace DataModel {
    export type CellRegion = 'body' | 'row-header' | 'column-header' | 'corner-header';
    export type CellsChangedArgs = {
        readonly type: 'cells-changed';
        readonly region: CellRegion;
        readonly row: number;
        readonly column: number;
        readonly rowSpan: number;
        readonly columnSpan: number;
    };
    export type ChangedArgs = RowsChangedArgs | ColumnsChangedArgs | RowsMovedArgs | ColumnsMovedArgs | CellsChangedArgs | ModelResetArgs;
    export type ColumnRegion = 'body' | 'row-header';
    const emptyMetadata: Metadata;
    export type ColumnsChangedArgs = {
        readonly type: 'columns-inserted' | 'columns-removed';
        readonly region: ColumnRegion;
        readonly index: number;
        readonly span: number;
    };
    export type ColumnsMovedArgs = {
        readonly type: 'columns-moved';
        readonly region: ColumnRegion;
        readonly index: number;
        readonly span: number;
        readonly destination: number;
    };
    export type Metadata = {
        [key: string]: any;
    };
    export type ModelResetArgs = {
        readonly type: 'model-reset';
    };
    export type RowRegion = 'body' | 'column-header';
    export type RowsChangedArgs = {
        readonly type: 'rows-inserted' | 'rows-removed';
        readonly region: RowRegion;
        readonly index: number;
        readonly span: number;
    };
    export type RowsMovedArgs = {
        readonly type: 'rows-moved';
        readonly region: RowRegion;
        readonly index: number;
        readonly span: number;
        readonly destination: number;
    };
}

// @public
export class DateCellEditor extends CellEditor {
    dispose(): void;
    protected getInput(): string | null;
    handleEvent(event: Event): void;
    protected startEditing(): void;
}

// @public
export class DynamicOptionCellEditor extends CellEditor {
    dispose(): void;
    protected getInput(): string | null;
    handleEvent(event: Event): void;
    protected startEditing(): void;
}

// @public
export type EditorOverrideIdentifier = CellDataType | DataModel.Metadata | 'default';

// @public
export class GraphicsContext implements IDisposable {
    constructor(context: CanvasRenderingContext2D);
    // (undocumented)
    arc(x: number, y: number, radius: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    // (undocumented)
    arcTo(x1: number, y1: number, x2: number, y2: number, radius: number): void;
    // (undocumented)
    beginPath(): void;
    // (undocumented)
    bezierCurveTo(cp1x: number, cp1y: number, cp2x: number, cp2y: number, x: number, y: number): void;
    // (undocumented)
    clearRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    clip(fillRule?: CanvasFillRule): void;
    // (undocumented)
    closePath(): void;
    // (undocumented)
    createImageData(imageData: ImageData): ImageData;
    // (undocumented)
    createImageData(sw: number, sh: number): ImageData;
    // (undocumented)
    createLinearGradient(x0: number, y0: number, x1: number, y1: number): CanvasGradient;
    // (undocumented)
    createPattern(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement, repetition: string): CanvasPattern | null;
    // (undocumented)
    createRadialGradient(x0: number, y0: number, r0: number, x1: number, y1: number, r1: number): CanvasGradient;
    // (undocumented)
    dispose(): void;
    // (undocumented)
    drawFocusIfNeeded(element: Element): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, dstX: number, dstY: number, dstW: number, dstH: number): void;
    // (undocumented)
    drawImage(image: HTMLImageElement | HTMLCanvasElement | HTMLVideoElement | ImageBitmap, srcX: number, srcY: number, srcW: number, srcH: number, dstX: number, dstY: number, dstW: number, dstH: number): void;
    // (undocumented)
    ellipse(x: number, y: number, radiusX: number, radiusY: number, rotation: number, startAngle: number, endAngle: number, anticlockwise?: boolean): void;
    // (undocumented)
    fill(fillRule?: CanvasFillRule): void;
    // (undocumented)
    fillRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    get fillStyle(): string | CanvasGradient | CanvasPattern;
    set fillStyle(value: string | CanvasGradient | CanvasPattern);
    // (undocumented)
    fillText(text: string, x: number, y: number, maxWidth?: number): void;
    // (undocumented)
    get font(): string;
    set font(value: string);
    // (undocumented)
    getImageData(sx: number, sy: number, sw: number, sh: number): ImageData;
    // (undocumented)
    getLineDash(): number[];
    // (undocumented)
    get globalAlpha(): number;
    set globalAlpha(value: number);
    // (undocumented)
    get globalCompositeOperation(): GlobalCompositeOperation;
    set globalCompositeOperation(value: GlobalCompositeOperation);
    // (undocumented)
    get imageSmoothingEnabled(): boolean;
    set imageSmoothingEnabled(value: boolean);
    // (undocumented)
    get isDisposed(): boolean;
    // (undocumented)
    isPointInPath(x: number, y: number, fillRule?: CanvasFillRule): boolean;
    // (undocumented)
    get lineCap(): CanvasLineCap;
    set lineCap(value: CanvasLineCap);
    // (undocumented)
    get lineDashOffset(): number;
    set lineDashOffset(value: number);
    // (undocumented)
    get lineJoin(): CanvasLineJoin;
    set lineJoin(value: CanvasLineJoin);
    // (undocumented)
    lineTo(x: number, y: number): void;
    // (undocumented)
    get lineWidth(): number;
    set lineWidth(value: number);
    // (undocumented)
    measureText(text: string): TextMetrics;
    // (undocumented)
    get miterLimit(): number;
    set miterLimit(value: number);
    // (undocumented)
    moveTo(x: number, y: number): void;
    // (undocumented)
    putImageData(imagedata: ImageData, dx: number, dy: number): void;
    // (undocumented)
    putImageData(imagedata: ImageData, dx: number, dy: number, dirtyX: number, dirtyY: number, dirtyWidth: number, dirtyHeight: number): void;
    // (undocumented)
    quadraticCurveTo(cpx: number, cpy: number, x: number, y: number): void;
    // (undocumented)
    rect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    restore(): void;
    // (undocumented)
    rotate(angle: number): void;
    // (undocumented)
    save(): void;
    // (undocumented)
    scale(x: number, y: number): void;
    // (undocumented)
    setLineDash(segments: number[]): void;
    // (undocumented)
    setTransform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;
    // (undocumented)
    get shadowBlur(): number;
    set shadowBlur(value: number);
    // (undocumented)
    get shadowColor(): string;
    set shadowColor(value: string);
    // (undocumented)
    get shadowOffsetX(): number;
    set shadowOffsetX(value: number);
    // (undocumented)
    get shadowOffsetY(): number;
    set shadowOffsetY(value: number);
    // (undocumented)
    stroke(): void;
    // (undocumented)
    strokeRect(x: number, y: number, w: number, h: number): void;
    // (undocumented)
    get strokeStyle(): string | CanvasGradient | CanvasPattern;
    set strokeStyle(value: string | CanvasGradient | CanvasPattern);
    // (undocumented)
    strokeText(text: string, x: number, y: number, maxWidth?: number): void;
    // (undocumented)
    get textAlign(): CanvasTextAlign;
    set textAlign(value: CanvasTextAlign);
    // (undocumented)
    get textBaseline(): CanvasTextBaseline;
    set textBaseline(value: CanvasTextBaseline);
    // (undocumented)
    transform(m11: number, m12: number, m21: number, m22: number, dx: number, dy: number): void;
    // (undocumented)
    translate(x: number, y: number): void;
}

// @public
export class HyperlinkRenderer extends TextRenderer {
    constructor(options?: HyperlinkRenderer.IOptions);
    drawText(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    getText(config: CellRenderer.CellConfig): string;
    readonly url: CellRenderer.ConfigOption<string> | undefined;
    readonly urlName: CellRenderer.ConfigOption<string> | undefined;
}

// @public (undocumented)
export namespace HyperlinkRenderer {
    export type ElideDirection = 'left' | 'right' | 'none';
    export type HorizontalAlignment = 'left' | 'center' | 'right';
    export interface IOptions extends TextRenderer.IOptions {
        url?: CellRenderer.ConfigOption<string> | undefined;
        urlName?: CellRenderer.ConfigOption<string> | undefined;
    }
    export type VerticalAlignment = 'top' | 'center' | 'bottom';
}

// @public
export interface ICellEditOptions {
    editor?: ICellEditor;
    onCancel?: () => void;
    onCommit?: (response: ICellEditResponse) => void;
    validator?: ICellInputValidator;
}

// @public
export interface ICellEditor {
    cancel(): void;
    edit(cell: CellEditor.CellConfig, options?: ICellEditOptions): void;
}

// @public
export interface ICellEditorController {
    cancel(): void;
    edit(cell: CellEditor.CellConfig, options?: ICellEditOptions): boolean;
    setEditor(identifier: EditorOverrideIdentifier, editor: ICellEditor | Resolver): void;
}

// @public
export interface ICellEditResponse {
    cell: CellEditor.CellConfig;
    cursorMovement: SelectionModel.CursorMoveDirection;
    value: any;
}

// @public
export interface ICellInputValidator {
    validate(cell: CellEditor.CellConfig, value: any): ICellInputValidatorResponse;
}

// @public
export interface ICellInputValidatorResponse {
    message?: string;
    valid: boolean;
}

// @public
export class ImageRenderer extends AsyncCellRenderer {
    constructor(options?: ImageRenderer.IOptions);
    readonly backgroundColor: CellRenderer.ConfigOption<string>;
    drawBackground(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    drawImage(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    drawPlaceholder(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly height: CellRenderer.ConfigOption<string>;
    isReady(config: CellRenderer.CellConfig): boolean;
    load(config: CellRenderer.CellConfig): Promise<void>;
    paint(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    paintPlaceholder(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly placeholder: CellRenderer.ConfigOption<string>;
    readonly textColor: CellRenderer.ConfigOption<string>;
    readonly width: CellRenderer.ConfigOption<string>;
}

// @public
export namespace ImageRenderer {
    export interface IOptions {
        backgroundColor?: CellRenderer.ConfigOption<string>;
        height?: CellRenderer.ConfigOption<string>;
        placeholder?: CellRenderer.ConfigOption<string>;
        textColor?: CellRenderer.ConfigOption<string>;
        width?: CellRenderer.ConfigOption<string>;
    }
}

// @public
export abstract class InputCellEditor extends CellEditor {
    // (undocumented)
    protected bindEvents(): void;
    // (undocumented)
    protected createWidget(): void;
    // (undocumented)
    protected deserialize(value: unknown): any;
    dispose(): void;
    handleEvent(event: Event): void;
    // (undocumented)
    protected input: HTMLInputElement;
    // (undocumented)
    protected abstract inputType: string;
    protected startEditing(): void;
}

// @public
export class IntegerCellEditor extends InputCellEditor {
    protected getInput(): number | null;
    // (undocumented)
    protected inputType: string;
    protected startEditing(): void;
}

// @public
export class IntegerInputValidator implements ICellInputValidator {
    max: number;
    min: number;
    validate(cell: CellEditor.CellConfig, value: number): ICellInputValidatorResponse;
}

// @public
export class JSONModel extends DataModel {
    constructor(options: JSONModel.IOptions);
    columnCount(region: DataModel.ColumnRegion): number;
    data(region: DataModel.CellRegion, row: number, column: number): any;
    metadata(region: DataModel.CellRegion, row: number, column: number): DataModel.Metadata;
    rowCount(region: DataModel.RowRegion): number;
}

// @public
export namespace JSONModel {
    export type DataSource = ReadonlyArray<ReadonlyJSONObject>;
    export type Field = {
        readonly name: string;
        readonly type?: string;
        readonly format?: string;
        readonly title?: string;
    };
    export interface IOptions {
        data: DataSource;
        schema: Schema;
    }
    export type Schema = {
        readonly fields: Field[];
        readonly missingValues?: string[];
        readonly primaryKey?: string | string[];
    };
}

// @public
export abstract class MutableDataModel extends DataModel {
    abstract setData(region: DataModel.CellRegion, row: number, column: number, value: unknown): boolean;
}

// @public
export class NumberCellEditor extends InputCellEditor {
    protected getInput(): number | null;
    // (undocumented)
    protected inputType: string;
    protected startEditing(): void;
}

// @public
export class NumberInputValidator implements ICellInputValidator {
    max: number;
    min: number;
    validate(cell: CellEditor.CellConfig, value: number): ICellInputValidatorResponse;
}

// @public
export class OptionCellEditor extends CellEditor {
    dispose(): void;
    protected getInput(): string | string[] | null;
    protected startEditing(): void;
    protected updatePosition(): void;
}

// @public
export class PassInputValidator implements ICellInputValidator {
    validate(cell: CellEditor.CellConfig, value: unknown): ICellInputValidatorResponse;
}

// @public
export namespace PressData {
    export type ColumnResizeData = {
        readonly type: 'column-resize';
        readonly region: DataModel.ColumnRegion;
        readonly index: number;
        readonly size: number;
        readonly clientX: number;
        readonly override: IDisposable;
    };
    export type PressData = RowResizeData | ColumnResizeData | SelectData;
    export type RowResizeData = {
        readonly type: 'row-resize';
        readonly region: DataModel.RowRegion;
        readonly index: number;
        readonly size: number;
        readonly clientY: number;
        readonly override: IDisposable;
    };
    export type SelectData = {
        readonly type: 'select';
        readonly region: DataModel.CellRegion;
        readonly row: number;
        readonly column: number;
        readonly override: IDisposable;
        localX: number;
        localY: number;
        timeout: number;
    };
}

// @public
export class RendererMap {
    constructor(values?: RendererMap.Values, fallback?: CellRenderer);
    get changed(): ISignal<this, void>;
    get(config: CellRenderer.CellConfig): CellRenderer;
    update(values?: RendererMap.Values, fallback?: CellRenderer): void;
}

// @public
export namespace RendererMap {
    export type Resolver = CellRenderer.ConfigFunc<CellRenderer | undefined>;
    export type Values = {
        [R in DataModel.CellRegion]?: Resolver | CellRenderer | undefined;
    };
}

// @public
export type ResizeHandle = 'top' | 'left' | 'right' | 'bottom' | 'none' | 'hyperlink';

// @public
export function resolveOption<T>(option: ConfigOption<T>, config: CellEditor.CellConfig): T;

// @public
export type Resolver = ConfigFunc<ICellEditor | undefined>;

// @public
export class SectionList {
    constructor(options: SectionList.IOptions);
    clampSize(size: number): number;
    clear(): void;
    get count(): number;
    get defaultSize(): number;
    set defaultSize(value: number);
    extentOf(index: number): number;
    indexOf(offset: number): number;
    insert(index: number, count: number): void;
    get length(): number;
    get minimumSize(): number;
    set minimumSize(value: number);
    move(index: number, count: number, destination: number): void;
    offsetOf(index: number): number;
    remove(index: number, count: number): void;
    reset(): void;
    resize(index: number, size: number): void;
    sizeOf(index: number): number;
}

// @public
export namespace SectionList {
    export interface IOptions {
        defaultSize: number;
        minimumSize?: number;
    }
}

// @public
export abstract class SelectionModel {
    constructor(options: SelectionModel.IOptions);
    get changed(): ISignal<this, void>;
    abstract clear(): void;
    abstract currentSelection(): SelectionModel.Selection | null;
    abstract readonly cursorColumn: number;
    abstract readonly cursorRow: number;
    readonly dataModel: DataModel;
    protected emitChanged(): void;
    isCellSelected(row: number, column: number): boolean;
    isColumnSelected(index: number): boolean;
    abstract readonly isEmpty: boolean;
    isRowSelected(index: number): boolean;
    abstract moveCursorWithinSelections(direction: SelectionModel.CursorMoveDirection): void;
    protected onDataModelChanged(sender: DataModel, args: DataModel.ChangedArgs): void;
    abstract select(args: SelectionModel.SelectArgs): void;
    get selectionMode(): SelectionModel.SelectionMode;
    set selectionMode(value: SelectionModel.SelectionMode);
    abstract selections(): IterableIterator<SelectionModel.Selection>;
}

// @public
export namespace SelectionModel {
    export type ClearMode = 'all' | 'current' | 'none';
    export type CursorMoveDirection = 'up' | 'down' | 'left' | 'right' | 'none';
    export interface IOptions {
        dataModel: DataModel;
        selectionMode?: SelectionMode;
    }
    export type SelectArgs = {
        r1: number;
        c1: number;
        r2: number;
        c2: number;
        cursorRow: number;
        cursorColumn: number;
        clear: ClearMode;
    };
    export type Selection = {
        readonly r1: number;
        readonly c1: number;
        readonly r2: number;
        readonly c2: number;
    };
    export type SelectionMode = 'row' | 'column' | 'cell';
}

// @public
export class TextCellEditor extends InputCellEditor {
    protected getInput(): string | null;
    // (undocumented)
    protected inputType: string;
}

// @public
export class TextInputValidator implements ICellInputValidator {
    maxLength: number;
    minLength: number;
    pattern: RegExp | null;
    validate(cell: CellEditor.CellConfig, value: string): ICellInputValidatorResponse;
}

// @public
export class TextRenderer extends CellRenderer {
    constructor(options?: TextRenderer.IOptions);
    readonly backgroundColor: CellRenderer.ConfigOption<string>;
    drawBackground(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    drawText(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly elideDirection: CellRenderer.ConfigOption<TextRenderer.ElideDirection>;
    readonly font: CellRenderer.ConfigOption<string>;
    readonly format: TextRenderer.FormatFunc;
    getText(config: CellRenderer.CellConfig): string;
    readonly horizontalAlignment: CellRenderer.ConfigOption<TextRenderer.HorizontalAlignment>;
    readonly horizontalPadding: number;
    paint(gc: GraphicsContext, config: CellRenderer.CellConfig): void;
    readonly textColor: CellRenderer.ConfigOption<string>;
    readonly verticalAlignment: CellRenderer.ConfigOption<TextRenderer.VerticalAlignment>;
    readonly wrapText: CellRenderer.ConfigOption<boolean>;
}

// @public
export namespace TextRenderer {
    export type ElideDirection = 'left' | 'right' | 'none';
    export function formatDate(options?: formatDate.IOptions): FormatFunc;
    export namespace formatDate {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatExponential(options?: formatExponential.IOptions): FormatFunc;
    export namespace formatExponential {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export function formatFixed(options?: formatFixed.IOptions): FormatFunc;
    export namespace formatFixed {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export type FormatFunc = CellRenderer.ConfigFunc<string>;
    export function formatGeneric(options?: formatGeneric.IOptions): FormatFunc;
    export namespace formatGeneric {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatIntlDateTime(options?: formatIntlDateTime.IOptions): FormatFunc;
    export namespace formatIntlDateTime {
        export interface IOptions {
            locales?: string | string[];
            missing?: string;
            options?: Intl.DateTimeFormatOptions;
        }
    }
    export function formatIntlNumber(options?: formatIntlNumber.IOptions): FormatFunc;
    export namespace formatIntlNumber {
        export interface IOptions {
            locales?: string | string[];
            missing?: string;
            options?: Intl.NumberFormatOptions;
        }
    }
    export function formatISODateTime(options?: formatISODateTime.IOptions): FormatFunc;
    export namespace formatISODateTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatPrecision(options?: formatPrecision.IOptions): FormatFunc;
    export namespace formatPrecision {
        export interface IOptions {
            digits?: number;
            missing?: string;
        }
    }
    export function formatTime(options?: formatTime.IOptions): FormatFunc;
    export namespace formatTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export function formatUTCDateTime(options?: formatUTCDateTime.IOptions): FormatFunc;
    export namespace formatUTCDateTime {
        export interface IOptions {
            missing?: string;
        }
    }
    export type HorizontalAlignment = 'left' | 'center' | 'right';
    export interface IOptions {
        backgroundColor?: CellRenderer.ConfigOption<string>;
        elideDirection?: CellRenderer.ConfigOption<ElideDirection>;
        font?: CellRenderer.ConfigOption<string>;
        format?: FormatFunc;
        horizontalAlignment?: CellRenderer.ConfigOption<HorizontalAlignment>;
        horizontalPadding?: number;
        textColor?: CellRenderer.ConfigOption<string>;
        verticalAlignment?: CellRenderer.ConfigOption<VerticalAlignment>;
        wrapText?: CellRenderer.ConfigOption<boolean>;
    }
    export function measureFontHeight(font: string): number;
    export type VerticalAlignment = 'top' | 'center' | 'bottom';
}

```
