#!/usr/bin/env python3

# Unix SMB/CIFS implementation.
# Copyright (C) Jelmer Vernooij <jelmer@samba.org> 2008
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

from samba.netbios import Node

n = Node()
(reply_from, names, addresses) = n.query_name("GANIEDA", "192.168.4.0",
                                              timeout=4)

print("Received reply from %s:" % (reply_from, ))
print("Names: %r" % (names, ))
print("Addresses: %r" % (addresses, ))
