/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.fabric.proto.xmlrpc;

import com.mysql.cj.api.fabric.xmlrpc.XmlRpcMethodCaller;
import com.mysql.cj.fabric.exceptions.FabricCommunicationException;
import com.mysql.cj.fabric.proto.xmlrpc.DigestAuthentication;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class AuthenticatedXmlRpcMethodCaller
implements XmlRpcMethodCaller {
    private XmlRpcMethodCaller underlyingCaller;
    private String url;
    private String username;
    private String password;

    public AuthenticatedXmlRpcMethodCaller(XmlRpcMethodCaller underlyingCaller, String url, String username, String password) {
        this.underlyingCaller = underlyingCaller;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    public void setHeader(String name, String value) {
        this.underlyingCaller.setHeader(name, value);
    }

    @Override
    public void clearHeader(String name) {
        this.underlyingCaller.clearHeader(name);
    }

    @Override
    public List<?> call(String methodName, Object[] args) throws FabricCommunicationException {
        String authenticateHeader;
        try {
            authenticateHeader = DigestAuthentication.getChallengeHeader(this.url);
        }
        catch (IOException ex) {
            throw new FabricCommunicationException("Unable to obtain challenge header for authentication", ex);
        }
        Map<String, String> digestChallenge = DigestAuthentication.parseDigestChallenge(authenticateHeader);
        String authorizationHeader = DigestAuthentication.generateAuthorizationHeader(digestChallenge, this.username, this.password);
        this.underlyingCaller.setHeader("Authorization", authorizationHeader);
        return this.underlyingCaller.call(methodName, args);
    }
}

