The `not` cfg-predicate was malformed.

Erroneous code example:

```compile_fail,E0536
pub fn main() {
    if cfg!(not()) { }
}
```

The `not` predicate expects one cfg-pattern. Example:

```
pub fn main() {
    if cfg!(not(target_os = "linux")) { } // ok!
}
```

For more information about the `cfg` macro, read the section on
[Conditional Compilation][conditional-compilation] in the Reference.

[conditional-compilation]: https://doc.rust-lang.org/reference/conditional-compilation.html
