The current crate is indistinguishable from one of its dependencies, in terms
of metadata.

Example of erroneous code:

`a.rs`
```ignore (cannot-link-with-other-tests)
#![crate_name = "a"]
#![crate_type = "lib"]

pub fn foo() {}
```

`b.rs`
```ignore (cannot-link-with-other-tests)
#![crate_name = "a"]
#![crate_type = "lib"]

// error: the current crate is indistinguishable from one of its dependencies:
//        it has the same crate-name `a` and was compiled with the same
//        `-C metadata` arguments. This will result in symbol conflicts between
//        the two.
extern crate a;

pub fn foo() {}

fn bar() {
    a::foo(); // is this calling the local crate or the dependency?
}
```

The above example compiles two crates with exactly the same name and
`crate_type` (plus any other metadata). This causes an error because it becomes
impossible for the compiler to distinguish between symbols (`pub` item names).

This error can be fixed by:
 * Using [Cargo](../cargo/index.html), the Rust package manager, automatically
   fixing this issue.
 * Recompiling the crate with different metadata (different name/
   `crate_type`).
