// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/docker/swarmkit/api/watch.proto

package api

import (
	context "context"
	fmt "fmt"
	github_com_docker_swarmkit_api_deepcopy "github.com/docker/swarmkit/api/deepcopy"
	raftselector "github.com/docker/swarmkit/manager/raftselector"
	_ "github.com/docker/swarmkit/protobuf/plugin"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	metadata "google.golang.org/grpc/metadata"
	peer "google.golang.org/grpc/peer"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
	rafttime "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// WatchActionKind distinguishes between creations, updates, and removals. It
// is structured as a bitmap so multiple kinds of events can be requested with
// a mask.
type WatchActionKind int32

const (
	WatchActionKindUnknown WatchActionKind = 0
	WatchActionKindCreate  WatchActionKind = 1
	WatchActionKindUpdate  WatchActionKind = 2
	WatchActionKindRemove  WatchActionKind = 4
)

var WatchActionKind_name = map[int32]string{
	0: "WATCH_ACTION_UNKNOWN",
	1: "WATCH_ACTION_CREATE",
	2: "WATCH_ACTION_UPDATE",
	4: "WATCH_ACTION_REMOVE",
}

var WatchActionKind_value = map[string]int32{
	"WATCH_ACTION_UNKNOWN": 0,
	"WATCH_ACTION_CREATE":  1,
	"WATCH_ACTION_UPDATE":  2,
	"WATCH_ACTION_REMOVE":  4,
}

func (x WatchActionKind) String() string {
	return proto.EnumName(WatchActionKind_name, int32(x))
}

func (WatchActionKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{0}
}

type Object struct {
	// Types that are valid to be assigned to Object:
	//	*Object_Node
	//	*Object_Service
	//	*Object_Network
	//	*Object_Task
	//	*Object_Cluster
	//	*Object_Secret
	//	*Object_Resource
	//	*Object_Extension
	//	*Object_Config
	Object isObject_Object `protobuf_oneof:"Object"`
}

func (m *Object) Reset()      { *m = Object{} }
func (*Object) ProtoMessage() {}
func (*Object) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{0}
}
func (m *Object) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Object) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Object.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Object) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Object.Merge(m, src)
}
func (m *Object) XXX_Size() int {
	return m.Size()
}
func (m *Object) XXX_DiscardUnknown() {
	xxx_messageInfo_Object.DiscardUnknown(m)
}

var xxx_messageInfo_Object proto.InternalMessageInfo

type isObject_Object interface {
	isObject_Object()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Object_Node struct {
	Node *Node `protobuf:"bytes,1,opt,name=node,proto3,oneof"`
}
type Object_Service struct {
	Service *Service `protobuf:"bytes,2,opt,name=service,proto3,oneof"`
}
type Object_Network struct {
	Network *Network `protobuf:"bytes,3,opt,name=network,proto3,oneof"`
}
type Object_Task struct {
	Task *Task `protobuf:"bytes,4,opt,name=task,proto3,oneof"`
}
type Object_Cluster struct {
	Cluster *Cluster `protobuf:"bytes,5,opt,name=cluster,proto3,oneof"`
}
type Object_Secret struct {
	Secret *Secret `protobuf:"bytes,6,opt,name=secret,proto3,oneof"`
}
type Object_Resource struct {
	Resource *Resource `protobuf:"bytes,7,opt,name=resource,proto3,oneof"`
}
type Object_Extension struct {
	Extension *Extension `protobuf:"bytes,8,opt,name=extension,proto3,oneof"`
}
type Object_Config struct {
	Config *Config `protobuf:"bytes,9,opt,name=config,proto3,oneof"`
}

func (*Object_Node) isObject_Object()      {}
func (*Object_Service) isObject_Object()   {}
func (*Object_Network) isObject_Object()   {}
func (*Object_Task) isObject_Object()      {}
func (*Object_Cluster) isObject_Object()   {}
func (*Object_Secret) isObject_Object()    {}
func (*Object_Resource) isObject_Object()  {}
func (*Object_Extension) isObject_Object() {}
func (*Object_Config) isObject_Object()    {}

func (m *Object) GetObject() isObject_Object {
	if m != nil {
		return m.Object
	}
	return nil
}

func (m *Object) GetNode() *Node {
	if x, ok := m.GetObject().(*Object_Node); ok {
		return x.Node
	}
	return nil
}

func (m *Object) GetService() *Service {
	if x, ok := m.GetObject().(*Object_Service); ok {
		return x.Service
	}
	return nil
}

func (m *Object) GetNetwork() *Network {
	if x, ok := m.GetObject().(*Object_Network); ok {
		return x.Network
	}
	return nil
}

func (m *Object) GetTask() *Task {
	if x, ok := m.GetObject().(*Object_Task); ok {
		return x.Task
	}
	return nil
}

func (m *Object) GetCluster() *Cluster {
	if x, ok := m.GetObject().(*Object_Cluster); ok {
		return x.Cluster
	}
	return nil
}

func (m *Object) GetSecret() *Secret {
	if x, ok := m.GetObject().(*Object_Secret); ok {
		return x.Secret
	}
	return nil
}

func (m *Object) GetResource() *Resource {
	if x, ok := m.GetObject().(*Object_Resource); ok {
		return x.Resource
	}
	return nil
}

func (m *Object) GetExtension() *Extension {
	if x, ok := m.GetObject().(*Object_Extension); ok {
		return x.Extension
	}
	return nil
}

func (m *Object) GetConfig() *Config {
	if x, ok := m.GetObject().(*Object_Config); ok {
		return x.Config
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Object) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Object_OneofMarshaler, _Object_OneofUnmarshaler, _Object_OneofSizer, []interface{}{
		(*Object_Node)(nil),
		(*Object_Service)(nil),
		(*Object_Network)(nil),
		(*Object_Task)(nil),
		(*Object_Cluster)(nil),
		(*Object_Secret)(nil),
		(*Object_Resource)(nil),
		(*Object_Extension)(nil),
		(*Object_Config)(nil),
	}
}

func _Object_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Object)
	// Object
	switch x := m.Object.(type) {
	case *Object_Node:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Node); err != nil {
			return err
		}
	case *Object_Service:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Service); err != nil {
			return err
		}
	case *Object_Network:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Network); err != nil {
			return err
		}
	case *Object_Task:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Task); err != nil {
			return err
		}
	case *Object_Cluster:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cluster); err != nil {
			return err
		}
	case *Object_Secret:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Secret); err != nil {
			return err
		}
	case *Object_Resource:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Resource); err != nil {
			return err
		}
	case *Object_Extension:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Extension); err != nil {
			return err
		}
	case *Object_Config:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Object.Object has unexpected type %T", x)
	}
	return nil
}

func _Object_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Object)
	switch tag {
	case 1: // Object.node
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Node)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Node{msg}
		return true, err
	case 2: // Object.service
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Service)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Service{msg}
		return true, err
	case 3: // Object.network
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Network)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Network{msg}
		return true, err
	case 4: // Object.task
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Task)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Task{msg}
		return true, err
	case 5: // Object.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Cluster{msg}
		return true, err
	case 6: // Object.secret
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Secret)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Secret{msg}
		return true, err
	case 7: // Object.resource
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Resource)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Resource{msg}
		return true, err
	case 8: // Object.extension
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Extension)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Extension{msg}
		return true, err
	case 9: // Object.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Config)
		err := b.DecodeMessage(msg)
		m.Object = &Object_Config{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Object_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Object)
	// Object
	switch x := m.Object.(type) {
	case *Object_Node:
		s := proto.Size(x.Node)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Service:
		s := proto.Size(x.Service)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Network:
		s := proto.Size(x.Network)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Task:
		s := proto.Size(x.Task)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Cluster:
		s := proto.Size(x.Cluster)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Secret:
		s := proto.Size(x.Secret)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Resource:
		s := proto.Size(x.Resource)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Extension:
		s := proto.Size(x.Extension)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Object_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// FIXME(aaronl): These messages should ideally be embedded in SelectBy, but
// protoc generates bad code for that.
type SelectBySlot struct {
	ServiceID string `protobuf:"bytes,1,opt,name=service_id,json=serviceId,proto3" json:"service_id,omitempty"`
	Slot      uint64 `protobuf:"varint,2,opt,name=slot,proto3" json:"slot,omitempty"`
}

func (m *SelectBySlot) Reset()      { *m = SelectBySlot{} }
func (*SelectBySlot) ProtoMessage() {}
func (*SelectBySlot) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{1}
}
func (m *SelectBySlot) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SelectBySlot) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SelectBySlot.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SelectBySlot) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SelectBySlot.Merge(m, src)
}
func (m *SelectBySlot) XXX_Size() int {
	return m.Size()
}
func (m *SelectBySlot) XXX_DiscardUnknown() {
	xxx_messageInfo_SelectBySlot.DiscardUnknown(m)
}

var xxx_messageInfo_SelectBySlot proto.InternalMessageInfo

type SelectByCustom struct {
	Kind  string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	Index string `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *SelectByCustom) Reset()      { *m = SelectByCustom{} }
func (*SelectByCustom) ProtoMessage() {}
func (*SelectByCustom) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{2}
}
func (m *SelectByCustom) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SelectByCustom) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SelectByCustom.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SelectByCustom) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SelectByCustom.Merge(m, src)
}
func (m *SelectByCustom) XXX_Size() int {
	return m.Size()
}
func (m *SelectByCustom) XXX_DiscardUnknown() {
	xxx_messageInfo_SelectByCustom.DiscardUnknown(m)
}

var xxx_messageInfo_SelectByCustom proto.InternalMessageInfo

type SelectBy struct {
	// TODO(aaronl): Are all of these things we want to expose in
	// the API? Exposing them may commit us to maintaining those
	// internal indices going forward.
	//
	// Types that are valid to be assigned to By:
	//	*SelectBy_ID
	//	*SelectBy_IDPrefix
	//	*SelectBy_Name
	//	*SelectBy_NamePrefix
	//	*SelectBy_Custom
	//	*SelectBy_CustomPrefix
	//	*SelectBy_ServiceID
	//	*SelectBy_NodeID
	//	*SelectBy_Slot
	//	*SelectBy_DesiredState
	//	*SelectBy_Role
	//	*SelectBy_Membership
	//	*SelectBy_ReferencedNetworkID
	//	*SelectBy_ReferencedSecretID
	//	*SelectBy_ReferencedConfigID
	//	*SelectBy_Kind
	By isSelectBy_By `protobuf_oneof:"By"`
}

func (m *SelectBy) Reset()      { *m = SelectBy{} }
func (*SelectBy) ProtoMessage() {}
func (*SelectBy) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{3}
}
func (m *SelectBy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *SelectBy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_SelectBy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *SelectBy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SelectBy.Merge(m, src)
}
func (m *SelectBy) XXX_Size() int {
	return m.Size()
}
func (m *SelectBy) XXX_DiscardUnknown() {
	xxx_messageInfo_SelectBy.DiscardUnknown(m)
}

var xxx_messageInfo_SelectBy proto.InternalMessageInfo

type isSelectBy_By interface {
	isSelectBy_By()
	MarshalTo([]byte) (int, error)
	Size() int
}

type SelectBy_ID struct {
	ID string `protobuf:"bytes,1,opt,name=id,proto3,oneof"`
}
type SelectBy_IDPrefix struct {
	IDPrefix string `protobuf:"bytes,2,opt,name=id_prefix,json=idPrefix,proto3,oneof"`
}
type SelectBy_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,proto3,oneof"`
}
type SelectBy_NamePrefix struct {
	NamePrefix string `protobuf:"bytes,4,opt,name=name_prefix,json=namePrefix,proto3,oneof"`
}
type SelectBy_Custom struct {
	Custom *SelectByCustom `protobuf:"bytes,5,opt,name=custom,proto3,oneof"`
}
type SelectBy_CustomPrefix struct {
	CustomPrefix *SelectByCustom `protobuf:"bytes,6,opt,name=custom_prefix,json=customPrefix,proto3,oneof"`
}
type SelectBy_ServiceID struct {
	ServiceID string `protobuf:"bytes,7,opt,name=service_id,json=serviceId,proto3,oneof"`
}
type SelectBy_NodeID struct {
	NodeID string `protobuf:"bytes,8,opt,name=node_id,json=nodeId,proto3,oneof"`
}
type SelectBy_Slot struct {
	Slot *SelectBySlot `protobuf:"bytes,9,opt,name=slot,proto3,oneof"`
}
type SelectBy_DesiredState struct {
	DesiredState TaskState `protobuf:"varint,10,opt,name=desired_state,json=desiredState,proto3,enum=docker.swarmkit.v1.TaskState,oneof"`
}
type SelectBy_Role struct {
	Role NodeRole `protobuf:"varint,11,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole,oneof"`
}
type SelectBy_Membership struct {
	Membership NodeSpec_Membership `protobuf:"varint,12,opt,name=membership,proto3,enum=docker.swarmkit.v1.NodeSpec_Membership,oneof"`
}
type SelectBy_ReferencedNetworkID struct {
	ReferencedNetworkID string `protobuf:"bytes,13,opt,name=referenced_network_id,json=referencedNetworkId,proto3,oneof"`
}
type SelectBy_ReferencedSecretID struct {
	ReferencedSecretID string `protobuf:"bytes,14,opt,name=referenced_secret_id,json=referencedSecretId,proto3,oneof"`
}
type SelectBy_ReferencedConfigID struct {
	ReferencedConfigID string `protobuf:"bytes,16,opt,name=referenced_config_id,json=referencedConfigId,proto3,oneof"`
}
type SelectBy_Kind struct {
	Kind string `protobuf:"bytes,15,opt,name=kind,proto3,oneof"`
}

func (*SelectBy_ID) isSelectBy_By()                  {}
func (*SelectBy_IDPrefix) isSelectBy_By()            {}
func (*SelectBy_Name) isSelectBy_By()                {}
func (*SelectBy_NamePrefix) isSelectBy_By()          {}
func (*SelectBy_Custom) isSelectBy_By()              {}
func (*SelectBy_CustomPrefix) isSelectBy_By()        {}
func (*SelectBy_ServiceID) isSelectBy_By()           {}
func (*SelectBy_NodeID) isSelectBy_By()              {}
func (*SelectBy_Slot) isSelectBy_By()                {}
func (*SelectBy_DesiredState) isSelectBy_By()        {}
func (*SelectBy_Role) isSelectBy_By()                {}
func (*SelectBy_Membership) isSelectBy_By()          {}
func (*SelectBy_ReferencedNetworkID) isSelectBy_By() {}
func (*SelectBy_ReferencedSecretID) isSelectBy_By()  {}
func (*SelectBy_ReferencedConfigID) isSelectBy_By()  {}
func (*SelectBy_Kind) isSelectBy_By()                {}

func (m *SelectBy) GetBy() isSelectBy_By {
	if m != nil {
		return m.By
	}
	return nil
}

func (m *SelectBy) GetID() string {
	if x, ok := m.GetBy().(*SelectBy_ID); ok {
		return x.ID
	}
	return ""
}

func (m *SelectBy) GetIDPrefix() string {
	if x, ok := m.GetBy().(*SelectBy_IDPrefix); ok {
		return x.IDPrefix
	}
	return ""
}

func (m *SelectBy) GetName() string {
	if x, ok := m.GetBy().(*SelectBy_Name); ok {
		return x.Name
	}
	return ""
}

func (m *SelectBy) GetNamePrefix() string {
	if x, ok := m.GetBy().(*SelectBy_NamePrefix); ok {
		return x.NamePrefix
	}
	return ""
}

func (m *SelectBy) GetCustom() *SelectByCustom {
	if x, ok := m.GetBy().(*SelectBy_Custom); ok {
		return x.Custom
	}
	return nil
}

func (m *SelectBy) GetCustomPrefix() *SelectByCustom {
	if x, ok := m.GetBy().(*SelectBy_CustomPrefix); ok {
		return x.CustomPrefix
	}
	return nil
}

func (m *SelectBy) GetServiceID() string {
	if x, ok := m.GetBy().(*SelectBy_ServiceID); ok {
		return x.ServiceID
	}
	return ""
}

func (m *SelectBy) GetNodeID() string {
	if x, ok := m.GetBy().(*SelectBy_NodeID); ok {
		return x.NodeID
	}
	return ""
}

func (m *SelectBy) GetSlot() *SelectBySlot {
	if x, ok := m.GetBy().(*SelectBy_Slot); ok {
		return x.Slot
	}
	return nil
}

func (m *SelectBy) GetDesiredState() TaskState {
	if x, ok := m.GetBy().(*SelectBy_DesiredState); ok {
		return x.DesiredState
	}
	return TaskStateNew
}

func (m *SelectBy) GetRole() NodeRole {
	if x, ok := m.GetBy().(*SelectBy_Role); ok {
		return x.Role
	}
	return NodeRoleWorker
}

func (m *SelectBy) GetMembership() NodeSpec_Membership {
	if x, ok := m.GetBy().(*SelectBy_Membership); ok {
		return x.Membership
	}
	return NodeMembershipPending
}

func (m *SelectBy) GetReferencedNetworkID() string {
	if x, ok := m.GetBy().(*SelectBy_ReferencedNetworkID); ok {
		return x.ReferencedNetworkID
	}
	return ""
}

func (m *SelectBy) GetReferencedSecretID() string {
	if x, ok := m.GetBy().(*SelectBy_ReferencedSecretID); ok {
		return x.ReferencedSecretID
	}
	return ""
}

func (m *SelectBy) GetReferencedConfigID() string {
	if x, ok := m.GetBy().(*SelectBy_ReferencedConfigID); ok {
		return x.ReferencedConfigID
	}
	return ""
}

func (m *SelectBy) GetKind() string {
	if x, ok := m.GetBy().(*SelectBy_Kind); ok {
		return x.Kind
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SelectBy) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SelectBy_OneofMarshaler, _SelectBy_OneofUnmarshaler, _SelectBy_OneofSizer, []interface{}{
		(*SelectBy_ID)(nil),
		(*SelectBy_IDPrefix)(nil),
		(*SelectBy_Name)(nil),
		(*SelectBy_NamePrefix)(nil),
		(*SelectBy_Custom)(nil),
		(*SelectBy_CustomPrefix)(nil),
		(*SelectBy_ServiceID)(nil),
		(*SelectBy_NodeID)(nil),
		(*SelectBy_Slot)(nil),
		(*SelectBy_DesiredState)(nil),
		(*SelectBy_Role)(nil),
		(*SelectBy_Membership)(nil),
		(*SelectBy_ReferencedNetworkID)(nil),
		(*SelectBy_ReferencedSecretID)(nil),
		(*SelectBy_ReferencedConfigID)(nil),
		(*SelectBy_Kind)(nil),
	}
}

func _SelectBy_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SelectBy)
	// By
	switch x := m.By.(type) {
	case *SelectBy_ID:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ID)
	case *SelectBy_IDPrefix:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.IDPrefix)
	case *SelectBy_Name:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Name)
	case *SelectBy_NamePrefix:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.NamePrefix)
	case *SelectBy_Custom:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Custom); err != nil {
			return err
		}
	case *SelectBy_CustomPrefix:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CustomPrefix); err != nil {
			return err
		}
	case *SelectBy_ServiceID:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ServiceID)
	case *SelectBy_NodeID:
		_ = b.EncodeVarint(8<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.NodeID)
	case *SelectBy_Slot:
		_ = b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Slot); err != nil {
			return err
		}
	case *SelectBy_DesiredState:
		_ = b.EncodeVarint(10<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.DesiredState))
	case *SelectBy_Role:
		_ = b.EncodeVarint(11<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Role))
	case *SelectBy_Membership:
		_ = b.EncodeVarint(12<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Membership))
	case *SelectBy_ReferencedNetworkID:
		_ = b.EncodeVarint(13<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ReferencedNetworkID)
	case *SelectBy_ReferencedSecretID:
		_ = b.EncodeVarint(14<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ReferencedSecretID)
	case *SelectBy_ReferencedConfigID:
		_ = b.EncodeVarint(16<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.ReferencedConfigID)
	case *SelectBy_Kind:
		_ = b.EncodeVarint(15<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Kind)
	case nil:
	default:
		return fmt.Errorf("SelectBy.By has unexpected type %T", x)
	}
	return nil
}

func _SelectBy_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SelectBy)
	switch tag {
	case 1: // By.id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_ID{x}
		return true, err
	case 2: // By.id_prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_IDPrefix{x}
		return true, err
	case 3: // By.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_Name{x}
		return true, err
	case 4: // By.name_prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_NamePrefix{x}
		return true, err
	case 5: // By.custom
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SelectByCustom)
		err := b.DecodeMessage(msg)
		m.By = &SelectBy_Custom{msg}
		return true, err
	case 6: // By.custom_prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SelectByCustom)
		err := b.DecodeMessage(msg)
		m.By = &SelectBy_CustomPrefix{msg}
		return true, err
	case 7: // By.service_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_ServiceID{x}
		return true, err
	case 8: // By.node_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_NodeID{x}
		return true, err
	case 9: // By.slot
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(SelectBySlot)
		err := b.DecodeMessage(msg)
		m.By = &SelectBy_Slot{msg}
		return true, err
	case 10: // By.desired_state
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.By = &SelectBy_DesiredState{TaskState(x)}
		return true, err
	case 11: // By.role
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.By = &SelectBy_Role{NodeRole(x)}
		return true, err
	case 12: // By.membership
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.By = &SelectBy_Membership{NodeSpec_Membership(x)}
		return true, err
	case 13: // By.referenced_network_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_ReferencedNetworkID{x}
		return true, err
	case 14: // By.referenced_secret_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_ReferencedSecretID{x}
		return true, err
	case 16: // By.referenced_config_id
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_ReferencedConfigID{x}
		return true, err
	case 15: // By.kind
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.By = &SelectBy_Kind{x}
		return true, err
	default:
		return false, nil
	}
}

func _SelectBy_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SelectBy)
	// By
	switch x := m.By.(type) {
	case *SelectBy_ID:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ID)))
		n += len(x.ID)
	case *SelectBy_IDPrefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.IDPrefix)))
		n += len(x.IDPrefix)
	case *SelectBy_Name:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case *SelectBy_NamePrefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.NamePrefix)))
		n += len(x.NamePrefix)
	case *SelectBy_Custom:
		s := proto.Size(x.Custom)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SelectBy_CustomPrefix:
		s := proto.Size(x.CustomPrefix)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SelectBy_ServiceID:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ServiceID)))
		n += len(x.ServiceID)
	case *SelectBy_NodeID:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.NodeID)))
		n += len(x.NodeID)
	case *SelectBy_Slot:
		s := proto.Size(x.Slot)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SelectBy_DesiredState:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.DesiredState))
	case *SelectBy_Role:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Role))
	case *SelectBy_Membership:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Membership))
	case *SelectBy_ReferencedNetworkID:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ReferencedNetworkID)))
		n += len(x.ReferencedNetworkID)
	case *SelectBy_ReferencedSecretID:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ReferencedSecretID)))
		n += len(x.ReferencedSecretID)
	case *SelectBy_ReferencedConfigID:
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(len(x.ReferencedConfigID)))
		n += len(x.ReferencedConfigID)
	case *SelectBy_Kind:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Kind)))
		n += len(x.Kind)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

type WatchRequest struct {
	// Multiple entries are combined using OR logic - i.e. if an event
	// matches all of the selectors specified in any single watch entry,
	// the event will be sent to the client.
	Entries []*WatchRequest_WatchEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// ResumeFrom provides an version to resume the watch from, if non-nil.
	// The watch will return changes since this version, and continue to
	// return new changes afterwards. Watch will return an error if the
	// server has compacted its log and no longer has complete history to
	// this point.
	ResumeFrom *Version `protobuf:"bytes,2,opt,name=resume_from,json=resumeFrom,proto3" json:"resume_from,omitempty"`
	// IncludeOldObject causes WatchMessages to include a copy of the
	// previous version of the object on updates. Note that only live
	// changes will include the old object (not historical changes
	// retrieved using ResumeFrom).
	IncludeOldObject bool `protobuf:"varint,3,opt,name=include_old_object,json=includeOldObject,proto3" json:"include_old_object,omitempty"`
}

func (m *WatchRequest) Reset()      { *m = WatchRequest{} }
func (*WatchRequest) ProtoMessage() {}
func (*WatchRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{4}
}
func (m *WatchRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchRequest.Merge(m, src)
}
func (m *WatchRequest) XXX_Size() int {
	return m.Size()
}
func (m *WatchRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchRequest.DiscardUnknown(m)
}

var xxx_messageInfo_WatchRequest proto.InternalMessageInfo

type WatchRequest_WatchEntry struct {
	// Kind can contain a builtin type such as "node", "secret", etc. or
	// the kind specified by a custom-defined object.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// Action (create/update/delete)
	// This is a bitmask, so multiple actions may be OR'd together
	Action WatchActionKind `protobuf:"varint,2,opt,name=action,proto3,enum=docker.swarmkit.v1.WatchActionKind" json:"action,omitempty"`
	// Filters are combined using AND logic - an event must match
	// all of them to pass the filter.
	Filters []*SelectBy `protobuf:"bytes,3,rep,name=filters,proto3" json:"filters,omitempty"`
}

func (m *WatchRequest_WatchEntry) Reset()      { *m = WatchRequest_WatchEntry{} }
func (*WatchRequest_WatchEntry) ProtoMessage() {}
func (*WatchRequest_WatchEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{4, 0}
}
func (m *WatchRequest_WatchEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchRequest_WatchEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchRequest_WatchEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchRequest_WatchEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchRequest_WatchEntry.Merge(m, src)
}
func (m *WatchRequest_WatchEntry) XXX_Size() int {
	return m.Size()
}
func (m *WatchRequest_WatchEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchRequest_WatchEntry.DiscardUnknown(m)
}

var xxx_messageInfo_WatchRequest_WatchEntry proto.InternalMessageInfo

// WatchMessage is the type of the stream that's returned to the client by
// Watch. Note that the first item of this stream will always be a WatchMessage
// with a nil Object, to signal that the stream has started.
type WatchMessage struct {
	Events []*WatchMessage_Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
	// Index versions this change to the data store. It can be used to
	// resume the watch from this point.
	Version *Version `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (m *WatchMessage) Reset()      { *m = WatchMessage{} }
func (*WatchMessage) ProtoMessage() {}
func (*WatchMessage) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{5}
}
func (m *WatchMessage) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchMessage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchMessage.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchMessage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchMessage.Merge(m, src)
}
func (m *WatchMessage) XXX_Size() int {
	return m.Size()
}
func (m *WatchMessage) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchMessage.DiscardUnknown(m)
}

var xxx_messageInfo_WatchMessage proto.InternalMessageInfo

type WatchMessage_Event struct {
	// Action (create/update/delete)
	// Note that WatchMessage does not expose "commit" events that
	// mark transaction boundaries.
	Action WatchActionKind `protobuf:"varint,1,opt,name=action,proto3,enum=docker.swarmkit.v1.WatchActionKind" json:"action,omitempty"`
	// Matched object
	Object *Object `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// For updates, OldObject will optionally be included in the
	// watch message, containing the previous version of the
	// object, if IncludeOldObject was set in WatchRequest.
	OldObject *Object `protobuf:"bytes,3,opt,name=old_object,json=oldObject,proto3" json:"old_object,omitempty"`
}

func (m *WatchMessage_Event) Reset()      { *m = WatchMessage_Event{} }
func (*WatchMessage_Event) ProtoMessage() {}
func (*WatchMessage_Event) Descriptor() ([]byte, []int) {
	return fileDescriptor_da25266013800cd9, []int{5, 0}
}
func (m *WatchMessage_Event) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WatchMessage_Event) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WatchMessage_Event.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WatchMessage_Event) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WatchMessage_Event.Merge(m, src)
}
func (m *WatchMessage_Event) XXX_Size() int {
	return m.Size()
}
func (m *WatchMessage_Event) XXX_DiscardUnknown() {
	xxx_messageInfo_WatchMessage_Event.DiscardUnknown(m)
}

var xxx_messageInfo_WatchMessage_Event proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("docker.swarmkit.v1.WatchActionKind", WatchActionKind_name, WatchActionKind_value)
	proto.RegisterType((*Object)(nil), "docker.swarmkit.v1.Object")
	proto.RegisterType((*SelectBySlot)(nil), "docker.swarmkit.v1.SelectBySlot")
	proto.RegisterType((*SelectByCustom)(nil), "docker.swarmkit.v1.SelectByCustom")
	proto.RegisterType((*SelectBy)(nil), "docker.swarmkit.v1.SelectBy")
	proto.RegisterType((*WatchRequest)(nil), "docker.swarmkit.v1.WatchRequest")
	proto.RegisterType((*WatchRequest_WatchEntry)(nil), "docker.swarmkit.v1.WatchRequest.WatchEntry")
	proto.RegisterType((*WatchMessage)(nil), "docker.swarmkit.v1.WatchMessage")
	proto.RegisterType((*WatchMessage_Event)(nil), "docker.swarmkit.v1.WatchMessage.Event")
}

func init() {
	proto.RegisterFile("github.com/docker/swarmkit/api/watch.proto", fileDescriptor_da25266013800cd9)
}

var fileDescriptor_da25266013800cd9 = []byte{
	// 1199 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x96, 0xbd, 0x73, 0x1b, 0xc5,
	0x1b, 0xc7, 0xef, 0x14, 0xf9, 0x24, 0x3d, 0xb6, 0x13, 0xcf, 0xc6, 0x49, 0xee, 0xa7, 0x5f, 0x90,
	0x85, 0x78, 0xcb, 0x24, 0x41, 0x06, 0x13, 0x92, 0x01, 0x02, 0x33, 0x96, 0x2c, 0x46, 0x22, 0xe3,
	0x97, 0x59, 0xdb, 0x49, 0xa9, 0x39, 0xdf, 0x3d, 0x56, 0x0e, 0xdf, 0xdd, 0x8a, 0xbd, 0x93, 0x1d,
	0x77, 0x14, 0x14, 0x4c, 0x2a, 0x1a, 0x66, 0x68, 0x52, 0x41, 0x4d, 0x43, 0x07, 0xff, 0x40, 0x86,
	0x2a, 0x65, 0x68, 0x3c, 0x44, 0xe9, 0x28, 0xf8, 0x0b, 0x28, 0x98, 0x7d, 0x39, 0xdb, 0x51, 0x4e,
	0x36, 0xa9, 0xb4, 0xb7, 0xf7, 0xf9, 0x3e, 0xfb, 0xec, 0xf3, 0x76, 0x82, 0xab, 0x3d, 0x3f, 0xb9,
	0x3f, 0xd8, 0xaa, 0xbb, 0x2c, 0x9c, 0xf7, 0x98, 0xbb, 0x83, 0x7c, 0x3e, 0xde, 0x73, 0x78, 0xb8,
	0xe3, 0x27, 0xf3, 0x4e, 0xdf, 0x9f, 0xdf, 0x73, 0x12, 0xf7, 0x7e, 0xbd, 0xcf, 0x59, 0xc2, 0x08,
	0x51, 0x40, 0x3d, 0x05, 0xea, 0xbb, 0xef, 0x97, 0x4f, 0xd3, 0xc7, 0x7d, 0x74, 0x63, 0xa5, 0x2f,
	0x5f, 0x3f, 0x85, 0x65, 0x5b, 0x5f, 0xa2, 0x9b, 0xa4, 0xf4, 0x69, 0x96, 0x93, 0xfd, 0x3e, 0xa6,
	0xec, 0x6c, 0x8f, 0xf5, 0x98, 0x5c, 0xce, 0x8b, 0x95, 0xde, 0xbd, 0x75, 0x82, 0x05, 0x49, 0x6c,
	0x0d, 0xb6, 0xe7, 0xfb, 0xc1, 0xa0, 0xe7, 0x47, 0xfa, 0x47, 0x09, 0x6b, 0xdf, 0xe4, 0xc1, 0x5a,
	0x95, 0xce, 0x90, 0x3a, 0xe4, 0x23, 0xe6, 0xa1, 0x6d, 0x56, 0xcd, 0x2b, 0x93, 0x0b, 0x76, 0xfd,
	0xe5, 0x10, 0xd4, 0x57, 0x98, 0x87, 0x6d, 0x83, 0x4a, 0x8e, 0xdc, 0x82, 0x42, 0x8c, 0x7c, 0xd7,
	0x77, 0xd1, 0xce, 0x49, 0xc9, 0xff, 0xb3, 0x24, 0xeb, 0x0a, 0x69, 0x1b, 0x34, 0xa5, 0x85, 0x30,
	0xc2, 0x64, 0x8f, 0xf1, 0x1d, 0xfb, 0xcc, 0x78, 0xe1, 0x8a, 0x42, 0x84, 0x50, 0xd3, 0xc2, 0xc3,
	0xc4, 0x89, 0x77, 0xec, 0xfc, 0x78, 0x0f, 0x37, 0x9c, 0x58, 0x48, 0x24, 0x27, 0x0e, 0x72, 0x83,
	0x41, 0x9c, 0x20, 0xb7, 0x27, 0xc6, 0x1f, 0xd4, 0x54, 0x88, 0x38, 0x48, 0xd3, 0xe4, 0x06, 0x58,
	0x31, 0xba, 0x1c, 0x13, 0xdb, 0x92, 0xba, 0x72, 0xf6, 0xcd, 0x04, 0xd1, 0x36, 0xa8, 0x66, 0xc9,
	0xc7, 0x50, 0xe4, 0x18, 0xb3, 0x01, 0x77, 0xd1, 0x2e, 0x48, 0xdd, 0xe5, 0x2c, 0x1d, 0xd5, 0x4c,
	0xdb, 0xa0, 0x87, 0x3c, 0xf9, 0x14, 0x4a, 0xf8, 0x20, 0xc1, 0x28, 0xf6, 0x59, 0x64, 0x17, 0xa5,
	0xf8, 0xb5, 0x2c, 0x71, 0x2b, 0x85, 0xda, 0x06, 0x3d, 0x52, 0x08, 0x87, 0x5d, 0x16, 0x6d, 0xfb,
	0x3d, 0xbb, 0x34, 0xde, 0xe1, 0xa6, 0x24, 0x84, 0xc3, 0x8a, 0x6d, 0x14, 0xd3, 0xdc, 0xd7, 0xd6,
	0x60, 0x6a, 0x1d, 0x03, 0x74, 0x93, 0xc6, 0xfe, 0x7a, 0xc0, 0x12, 0x72, 0x1d, 0x40, 0x67, 0xab,
	0xeb, 0x7b, 0xb2, 0x22, 0x4a, 0x8d, 0xe9, 0xe1, 0xc1, 0x5c, 0x49, 0xa7, 0xb3, 0xb3, 0x44, 0x4b,
	0x1a, 0xe8, 0x78, 0x84, 0x40, 0x3e, 0x0e, 0x58, 0x22, 0xcb, 0x20, 0x4f, 0xe5, 0xba, 0xb6, 0x06,
	0x67, 0x53, 0x8b, 0xcd, 0x41, 0x9c, 0xb0, 0x50, 0x50, 0x3b, 0x7e, 0xa4, 0xad, 0x51, 0xb9, 0x26,
	0xb3, 0x30, 0xe1, 0x47, 0x1e, 0x3e, 0x90, 0xd2, 0x12, 0x55, 0x0f, 0x62, 0x77, 0xd7, 0x09, 0x06,
	0x28, 0xcb, 0xa3, 0x44, 0xd5, 0x43, 0xed, 0x2f, 0x0b, 0x8a, 0xa9, 0x49, 0x62, 0x43, 0xee, 0xd0,
	0x31, 0x6b, 0x78, 0x30, 0x97, 0xeb, 0x2c, 0xb5, 0x0d, 0x9a, 0xf3, 0x3d, 0x72, 0x0d, 0x4a, 0xbe,
	0xd7, 0xed, 0x73, 0xdc, 0xf6, 0xb5, 0xd9, 0xc6, 0xd4, 0xf0, 0x60, 0xae, 0xd8, 0x59, 0x5a, 0x93,
	0x7b, 0x22, 0xec, 0xbe, 0xa7, 0xd6, 0x64, 0x16, 0xf2, 0x91, 0x13, 0xea, 0x83, 0x64, 0x65, 0x3b,
	0x21, 0x92, 0xd7, 0x61, 0x52, 0xfc, 0xa6, 0x46, 0xf2, 0xfa, 0x25, 0x88, 0x4d, 0x2d, 0xbc, 0x0d,
	0x96, 0x2b, 0xaf, 0xa5, 0x2b, 0xab, 0x96, 0x5d, 0x21, 0xc7, 0x03, 0x20, 0x03, 0xaf, 0x42, 0xd1,
	0x81, 0x69, 0xb5, 0x4a, 0x8f, 0xb0, 0x5e, 0xc1, 0xc8, 0x94, 0x92, 0x6a, 0x47, 0xea, 0x2f, 0x64,
	0xaa, 0x90, 0x91, 0x29, 0x51, 0x29, 0x47, 0xb9, 0x7a, 0x0b, 0x0a, 0xa2, 0x7b, 0x05, 0x5c, 0x94,
	0x30, 0x0c, 0x0f, 0xe6, 0x2c, 0xd1, 0xd8, 0x92, 0xb4, 0xc4, 0xcb, 0x8e, 0x47, 0x6e, 0xea, 0x94,
	0xaa, 0x72, 0xaa, 0x9e, 0xe4, 0x98, 0x28, 0x18, 0x11, 0x3a, 0xc1, 0x93, 0x25, 0x98, 0xf6, 0x30,
	0xf6, 0x39, 0x7a, 0xdd, 0x38, 0x71, 0x12, 0xb4, 0xa1, 0x6a, 0x5e, 0x39, 0x9b, 0x5d, 0xcb, 0xa2,
	0x57, 0xd7, 0x05, 0x24, 0x2e, 0xa5, 0x55, 0xf2, 0x99, 0x2c, 0x40, 0x9e, 0xb3, 0x00, 0xed, 0x49,
	0x29, 0xbe, 0x3c, 0x6e, 0x14, 0x51, 0x16, 0xc8, 0x71, 0x24, 0x58, 0xd2, 0x01, 0x08, 0x31, 0xdc,
	0x42, 0x1e, 0xdf, 0xf7, 0xfb, 0xf6, 0x94, 0x54, 0xbe, 0x33, 0x4e, 0xb9, 0xde, 0x47, 0xb7, 0xbe,
	0x7c, 0x88, 0x8b, 0xe4, 0x1e, 0x89, 0xc9, 0x32, 0x5c, 0xe0, 0xb8, 0x8d, 0x1c, 0x23, 0x17, 0xbd,
	0xae, 0x9e, 0x3e, 0x22, 0x62, 0xd3, 0x32, 0x62, 0x97, 0x86, 0x07, 0x73, 0xe7, 0xe9, 0x21, 0xa0,
	0x07, 0x95, 0x0c, 0xdf, 0x79, 0xfe, 0xd2, 0xb6, 0x47, 0xbe, 0x80, 0xd9, 0x63, 0xe6, 0xd4, 0xb0,
	0x10, 0xd6, 0xce, 0x4a, 0x6b, 0x17, 0x87, 0x07, 0x73, 0xe4, 0xc8, 0x9a, 0x9a, 0x2a, 0xd2, 0x18,
	0xe1, 0xa3, 0xbb, 0xa3, 0xb6, 0x54, 0x1f, 0x0b, 0x5b, 0x33, 0x59, 0xb6, 0x54, 0xc3, 0x8f, 0xda,
	0xd2, 0xbb, 0xa2, 0xf9, 0x54, 0x43, 0x9e, 0x4b, 0x8b, 0x5f, 0x3c, 0x35, 0xf2, 0x90, 0x6b, 0xec,
	0xd7, 0xfe, 0xc8, 0xc1, 0xd4, 0x3d, 0xf1, 0x41, 0xa4, 0xf8, 0xd5, 0x00, 0xe3, 0x84, 0xb4, 0xa0,
	0x80, 0x51, 0xc2, 0x7d, 0x8c, 0x6d, 0xb3, 0x7a, 0xe6, 0xca, 0xe4, 0xc2, 0xb5, 0xac, 0xd8, 0x1e,
	0x97, 0xa8, 0x87, 0x56, 0x94, 0xf0, 0x7d, 0x9a, 0x6a, 0xc9, 0x6d, 0x98, 0xe4, 0x18, 0x0f, 0x42,
	0xec, 0x6e, 0x73, 0x16, 0x9e, 0xf4, 0xe1, 0xb8, 0x8b, 0x5c, 0x8c, 0x36, 0x0a, 0x8a, 0xff, 0x9c,
	0xb3, 0x90, 0x5c, 0x07, 0xe2, 0x47, 0x6e, 0x30, 0xf0, 0xb0, 0xcb, 0x02, 0xaf, 0xab, 0xbe, 0xa2,
	0xb2, 0x79, 0x8b, 0x74, 0x46, 0xbf, 0x59, 0x0d, 0x3c, 0x35, 0xd4, 0xca, 0xdf, 0x9b, 0x00, 0x47,
	0x3e, 0x64, 0xce, 0x9f, 0x4f, 0xc0, 0x72, 0xdc, 0x44, 0xcc, 0xdc, 0x9c, 0x2c, 0x98, 0x37, 0xc6,
	0x5e, 0x6a, 0x51, 0x62, 0x77, 0xfc, 0xc8, 0xa3, 0x5a, 0x42, 0x6e, 0x42, 0x61, 0xdb, 0x0f, 0x12,
	0xe4, 0xb1, 0x7d, 0x46, 0x86, 0xe4, 0xf2, 0x49, 0x6d, 0x42, 0x53, 0xb8, 0xf6, 0x5b, 0x1a, 0xdb,
	0x65, 0x8c, 0x63, 0xa7, 0x87, 0xe4, 0x33, 0xb0, 0x70, 0x17, 0xa3, 0x24, 0x0d, 0xed, 0xdb, 0x63,
	0xbd, 0xd0, 0x8a, 0x7a, 0x4b, 0xe0, 0x54, 0xab, 0xc8, 0x87, 0x50, 0xd8, 0x55, 0xd1, 0xfa, 0x2f,
	0x01, 0x4d, 0xd9, 0xf2, 0x2f, 0x26, 0x4c, 0x48, 0x43, 0xc7, 0xc2, 0x60, 0xbe, 0x7a, 0x18, 0x16,
	0xc0, 0xd2, 0x89, 0xc8, 0x8d, 0xff, 0xf6, 0xa8, 0x94, 0x50, 0x4d, 0x92, 0x8f, 0x00, 0x46, 0x12,
	0x78, 0xb2, 0xae, 0xc4, 0xd2, 0xac, 0x5e, 0xfd, 0xc7, 0x84, 0x73, 0x23, 0xae, 0x90, 0x1b, 0x30,
	0x7b, 0x6f, 0x71, 0xa3, 0xd9, 0xee, 0x2e, 0x36, 0x37, 0x3a, 0xab, 0x2b, 0xdd, 0xcd, 0x95, 0x3b,
	0x2b, 0xab, 0xf7, 0x56, 0x66, 0x8c, 0x72, 0xf9, 0xe1, 0xa3, 0xea, 0xc5, 0x11, 0x7c, 0x33, 0xda,
	0x89, 0xd8, 0x9e, 0x70, 0xfc, 0xfc, 0x0b, 0xaa, 0x26, 0x6d, 0x2d, 0x6e, 0xb4, 0x66, 0xcc, 0xf2,
	0xff, 0x1e, 0x3e, 0xaa, 0x5e, 0x18, 0x11, 0x35, 0x39, 0xaa, 0xc9, 0xf4, 0xa2, 0x66, 0x73, 0x6d,
	0x49, 0x68, 0x72, 0x99, 0x9a, 0xcd, 0xbe, 0x97, 0xa5, 0xa1, 0xad, 0xe5, 0xd5, 0xbb, 0xad, 0x99,
	0x7c, 0xa6, 0x86, 0x62, 0xc8, 0x76, 0xb1, 0x7c, 0xe9, 0xdb, 0x1f, 0x2b, 0xc6, 0xaf, 0x3f, 0x55,
	0x46, 0xaf, 0xba, 0x10, 0xc2, 0x84, 0xdc, 0x22, 0x5e, 0xba, 0xa8, 0x9e, 0xd6, 0x88, 0xe5, 0xea,
	0x69, 0xf5, 0x54, 0xbb, 0xf0, 0xfb, 0xcf, 0x7f, 0xff, 0x90, 0x3b, 0x07, 0xd3, 0x92, 0x78, 0x37,
	0x74, 0x22, 0xa7, 0x87, 0xfc, 0x3d, 0xb3, 0xf1, 0xe6, 0xe3, 0x67, 0x15, 0xe3, 0xe9, 0xb3, 0x8a,
	0xf1, 0xf5, 0xb0, 0x62, 0x3e, 0x1e, 0x56, 0xcc, 0x27, 0xc3, 0x8a, 0xf9, 0xe7, 0xb0, 0x62, 0x7e,
	0xf7, 0xbc, 0x62, 0x3c, 0x79, 0x5e, 0x31, 0x9e, 0x3e, 0xaf, 0x18, 0x5b, 0x96, 0xfc, 0x33, 0xf9,
	0xc1, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x96, 0x4e, 0x58, 0x61, 0x63, 0x0b, 0x00, 0x00,
}

type authenticatedWrapperWatchServer struct {
	local     WatchServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperWatchServer(local WatchServer, authorize func(context.Context, []string) error) WatchServer {
	return &authenticatedWrapperWatchServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperWatchServer) Watch(r *WatchRequest, stream Watch_WatchServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-manager"}); err != nil {
		return err
	}
	return p.local.Watch(r, stream)
}

func (m *Object) Copy() *Object {
	if m == nil {
		return nil
	}
	o := &Object{}
	o.CopyFrom(m)
	return o
}

func (m *Object) CopyFrom(src interface{}) {

	o := src.(*Object)
	*m = *o
	if o.Object != nil {
		switch o.Object.(type) {
		case *Object_Node:
			v := Object_Node{
				Node: &Node{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Node, o.GetNode())
			m.Object = &v
		case *Object_Service:
			v := Object_Service{
				Service: &Service{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Service, o.GetService())
			m.Object = &v
		case *Object_Network:
			v := Object_Network{
				Network: &Network{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Network, o.GetNetwork())
			m.Object = &v
		case *Object_Task:
			v := Object_Task{
				Task: &Task{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Task, o.GetTask())
			m.Object = &v
		case *Object_Cluster:
			v := Object_Cluster{
				Cluster: &Cluster{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Cluster, o.GetCluster())
			m.Object = &v
		case *Object_Secret:
			v := Object_Secret{
				Secret: &Secret{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Secret, o.GetSecret())
			m.Object = &v
		case *Object_Resource:
			v := Object_Resource{
				Resource: &Resource{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Resource, o.GetResource())
			m.Object = &v
		case *Object_Extension:
			v := Object_Extension{
				Extension: &Extension{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Extension, o.GetExtension())
			m.Object = &v
		case *Object_Config:
			v := Object_Config{
				Config: &Config{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Config, o.GetConfig())
			m.Object = &v
		}
	}

}

func (m *SelectBySlot) Copy() *SelectBySlot {
	if m == nil {
		return nil
	}
	o := &SelectBySlot{}
	o.CopyFrom(m)
	return o
}

func (m *SelectBySlot) CopyFrom(src interface{}) {

	o := src.(*SelectBySlot)
	*m = *o
}

func (m *SelectByCustom) Copy() *SelectByCustom {
	if m == nil {
		return nil
	}
	o := &SelectByCustom{}
	o.CopyFrom(m)
	return o
}

func (m *SelectByCustom) CopyFrom(src interface{}) {

	o := src.(*SelectByCustom)
	*m = *o
}

func (m *SelectBy) Copy() *SelectBy {
	if m == nil {
		return nil
	}
	o := &SelectBy{}
	o.CopyFrom(m)
	return o
}

func (m *SelectBy) CopyFrom(src interface{}) {

	o := src.(*SelectBy)
	*m = *o
	if o.By != nil {
		switch o.By.(type) {
		case *SelectBy_ID:
			v := SelectBy_ID{
				ID: o.GetID(),
			}
			m.By = &v
		case *SelectBy_IDPrefix:
			v := SelectBy_IDPrefix{
				IDPrefix: o.GetIDPrefix(),
			}
			m.By = &v
		case *SelectBy_Name:
			v := SelectBy_Name{
				Name: o.GetName(),
			}
			m.By = &v
		case *SelectBy_NamePrefix:
			v := SelectBy_NamePrefix{
				NamePrefix: o.GetNamePrefix(),
			}
			m.By = &v
		case *SelectBy_Custom:
			v := SelectBy_Custom{
				Custom: &SelectByCustom{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Custom, o.GetCustom())
			m.By = &v
		case *SelectBy_CustomPrefix:
			v := SelectBy_CustomPrefix{
				CustomPrefix: &SelectByCustom{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.CustomPrefix, o.GetCustomPrefix())
			m.By = &v
		case *SelectBy_ServiceID:
			v := SelectBy_ServiceID{
				ServiceID: o.GetServiceID(),
			}
			m.By = &v
		case *SelectBy_NodeID:
			v := SelectBy_NodeID{
				NodeID: o.GetNodeID(),
			}
			m.By = &v
		case *SelectBy_Slot:
			v := SelectBy_Slot{
				Slot: &SelectBySlot{},
			}
			github_com_docker_swarmkit_api_deepcopy.Copy(v.Slot, o.GetSlot())
			m.By = &v
		case *SelectBy_DesiredState:
			v := SelectBy_DesiredState{
				DesiredState: o.GetDesiredState(),
			}
			m.By = &v
		case *SelectBy_Role:
			v := SelectBy_Role{
				Role: o.GetRole(),
			}
			m.By = &v
		case *SelectBy_Membership:
			v := SelectBy_Membership{
				Membership: o.GetMembership(),
			}
			m.By = &v
		case *SelectBy_ReferencedNetworkID:
			v := SelectBy_ReferencedNetworkID{
				ReferencedNetworkID: o.GetReferencedNetworkID(),
			}
			m.By = &v
		case *SelectBy_ReferencedSecretID:
			v := SelectBy_ReferencedSecretID{
				ReferencedSecretID: o.GetReferencedSecretID(),
			}
			m.By = &v
		case *SelectBy_ReferencedConfigID:
			v := SelectBy_ReferencedConfigID{
				ReferencedConfigID: o.GetReferencedConfigID(),
			}
			m.By = &v
		case *SelectBy_Kind:
			v := SelectBy_Kind{
				Kind: o.GetKind(),
			}
			m.By = &v
		}
	}

}

func (m *WatchRequest) Copy() *WatchRequest {
	if m == nil {
		return nil
	}
	o := &WatchRequest{}
	o.CopyFrom(m)
	return o
}

func (m *WatchRequest) CopyFrom(src interface{}) {

	o := src.(*WatchRequest)
	*m = *o
	if o.Entries != nil {
		m.Entries = make([]*WatchRequest_WatchEntry, len(o.Entries))
		for i := range m.Entries {
			m.Entries[i] = &WatchRequest_WatchEntry{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Entries[i], o.Entries[i])
		}
	}

	if o.ResumeFrom != nil {
		m.ResumeFrom = &Version{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.ResumeFrom, o.ResumeFrom)
	}
}

func (m *WatchRequest_WatchEntry) Copy() *WatchRequest_WatchEntry {
	if m == nil {
		return nil
	}
	o := &WatchRequest_WatchEntry{}
	o.CopyFrom(m)
	return o
}

func (m *WatchRequest_WatchEntry) CopyFrom(src interface{}) {

	o := src.(*WatchRequest_WatchEntry)
	*m = *o
	if o.Filters != nil {
		m.Filters = make([]*SelectBy, len(o.Filters))
		for i := range m.Filters {
			m.Filters[i] = &SelectBy{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Filters[i], o.Filters[i])
		}
	}

}

func (m *WatchMessage) Copy() *WatchMessage {
	if m == nil {
		return nil
	}
	o := &WatchMessage{}
	o.CopyFrom(m)
	return o
}

func (m *WatchMessage) CopyFrom(src interface{}) {

	o := src.(*WatchMessage)
	*m = *o
	if o.Events != nil {
		m.Events = make([]*WatchMessage_Event, len(o.Events))
		for i := range m.Events {
			m.Events[i] = &WatchMessage_Event{}
			github_com_docker_swarmkit_api_deepcopy.Copy(m.Events[i], o.Events[i])
		}
	}

	if o.Version != nil {
		m.Version = &Version{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Version, o.Version)
	}
}

func (m *WatchMessage_Event) Copy() *WatchMessage_Event {
	if m == nil {
		return nil
	}
	o := &WatchMessage_Event{}
	o.CopyFrom(m)
	return o
}

func (m *WatchMessage_Event) CopyFrom(src interface{}) {

	o := src.(*WatchMessage_Event)
	*m = *o
	if o.Object != nil {
		m.Object = &Object{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Object, o.Object)
	}
	if o.OldObject != nil {
		m.OldObject = &Object{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.OldObject, o.OldObject)
	}
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// WatchClient is the client API for Watch service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WatchClient interface {
	// Watch starts a stream that returns any changes to objects that match
	// the specified selectors. When the stream begins, it immediately sends
	// an empty message back to the client. It is important to wait for
	// this message before taking any actions that depend on an established
	// stream of changes for consistency.
	Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (Watch_WatchClient, error)
}

type watchClient struct {
	cc *grpc.ClientConn
}

func NewWatchClient(cc *grpc.ClientConn) WatchClient {
	return &watchClient{cc}
}

func (c *watchClient) Watch(ctx context.Context, in *WatchRequest, opts ...grpc.CallOption) (Watch_WatchClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Watch_serviceDesc.Streams[0], "/docker.swarmkit.v1.Watch/Watch", opts...)
	if err != nil {
		return nil, err
	}
	x := &watchWatchClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Watch_WatchClient interface {
	Recv() (*WatchMessage, error)
	grpc.ClientStream
}

type watchWatchClient struct {
	grpc.ClientStream
}

func (x *watchWatchClient) Recv() (*WatchMessage, error) {
	m := new(WatchMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// WatchServer is the server API for Watch service.
type WatchServer interface {
	// Watch starts a stream that returns any changes to objects that match
	// the specified selectors. When the stream begins, it immediately sends
	// an empty message back to the client. It is important to wait for
	// this message before taking any actions that depend on an established
	// stream of changes for consistency.
	Watch(*WatchRequest, Watch_WatchServer) error
}

func RegisterWatchServer(s *grpc.Server, srv WatchServer) {
	s.RegisterService(&_Watch_serviceDesc, srv)
}

func _Watch_Watch_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(WatchRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(WatchServer).Watch(m, &watchWatchServer{stream})
}

type Watch_WatchServer interface {
	Send(*WatchMessage) error
	grpc.ServerStream
}

type watchWatchServer struct {
	grpc.ServerStream
}

func (x *watchWatchServer) Send(m *WatchMessage) error {
	return x.ServerStream.SendMsg(m)
}

var _Watch_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Watch",
	HandlerType: (*WatchServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Watch",
			Handler:       _Watch_Watch_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "github.com/docker/swarmkit/api/watch.proto",
}

func (m *Object) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Object) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Object != nil {
		nn1, err := m.Object.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn1
	}
	return i, nil
}

func (m *Object_Node) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Node != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Node.Size()))
		n2, err := m.Node.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}
func (m *Object_Service) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Service != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Service.Size()))
		n3, err := m.Service.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *Object_Network) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Network != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Network.Size()))
		n4, err := m.Network.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func (m *Object_Task) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Task != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Task.Size()))
		n5, err := m.Task.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *Object_Cluster) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Cluster != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Cluster.Size()))
		n6, err := m.Cluster.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *Object_Secret) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Secret != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Secret.Size()))
		n7, err := m.Secret.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *Object_Resource) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Resource != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Resource.Size()))
		n8, err := m.Resource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *Object_Extension) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Extension != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Extension.Size()))
		n9, err := m.Extension.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *Object_Config) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Config != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Config.Size()))
		n10, err := m.Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func (m *SelectBySlot) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SelectBySlot) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ServiceID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintWatch(dAtA, i, uint64(len(m.ServiceID)))
		i += copy(dAtA[i:], m.ServiceID)
	}
	if m.Slot != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Slot))
	}
	return i, nil
}

func (m *SelectByCustom) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SelectByCustom) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintWatch(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if len(m.Index) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintWatch(dAtA, i, uint64(len(m.Index)))
		i += copy(dAtA[i:], m.Index)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	return i, nil
}

func (m *SelectBy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SelectBy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.By != nil {
		nn11, err := m.By.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn11
	}
	return i, nil
}

func (m *SelectBy_ID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.ID)))
	i += copy(dAtA[i:], m.ID)
	return i, nil
}
func (m *SelectBy_IDPrefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.IDPrefix)))
	i += copy(dAtA[i:], m.IDPrefix)
	return i, nil
}
func (m *SelectBy_Name) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	return i, nil
}
func (m *SelectBy_NamePrefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.NamePrefix)))
	i += copy(dAtA[i:], m.NamePrefix)
	return i, nil
}
func (m *SelectBy_Custom) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Custom != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Custom.Size()))
		n12, err := m.Custom.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	return i, nil
}
func (m *SelectBy_CustomPrefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.CustomPrefix != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.CustomPrefix.Size()))
		n13, err := m.CustomPrefix.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *SelectBy_ServiceID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x3a
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.ServiceID)))
	i += copy(dAtA[i:], m.ServiceID)
	return i, nil
}
func (m *SelectBy_NodeID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x42
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.NodeID)))
	i += copy(dAtA[i:], m.NodeID)
	return i, nil
}
func (m *SelectBy_Slot) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Slot != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Slot.Size()))
		n14, err := m.Slot.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func (m *SelectBy_DesiredState) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x50
	i++
	i = encodeVarintWatch(dAtA, i, uint64(m.DesiredState))
	return i, nil
}
func (m *SelectBy_Role) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x58
	i++
	i = encodeVarintWatch(dAtA, i, uint64(m.Role))
	return i, nil
}
func (m *SelectBy_Membership) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x60
	i++
	i = encodeVarintWatch(dAtA, i, uint64(m.Membership))
	return i, nil
}
func (m *SelectBy_ReferencedNetworkID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x6a
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.ReferencedNetworkID)))
	i += copy(dAtA[i:], m.ReferencedNetworkID)
	return i, nil
}
func (m *SelectBy_ReferencedSecretID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x72
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.ReferencedSecretID)))
	i += copy(dAtA[i:], m.ReferencedSecretID)
	return i, nil
}
func (m *SelectBy_Kind) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x7a
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.Kind)))
	i += copy(dAtA[i:], m.Kind)
	return i, nil
}
func (m *SelectBy_ReferencedConfigID) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x82
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintWatch(dAtA, i, uint64(len(m.ReferencedConfigID)))
	i += copy(dAtA[i:], m.ReferencedConfigID)
	return i, nil
}
func (m *WatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, msg := range m.Entries {
			dAtA[i] = 0xa
			i++
			i = encodeVarintWatch(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.ResumeFrom != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.ResumeFrom.Size()))
		n15, err := m.ResumeFrom.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.IncludeOldObject {
		dAtA[i] = 0x18
		i++
		if m.IncludeOldObject {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *WatchRequest_WatchEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchRequest_WatchEntry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Kind) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintWatch(dAtA, i, uint64(len(m.Kind)))
		i += copy(dAtA[i:], m.Kind)
	}
	if m.Action != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Action))
	}
	if len(m.Filters) > 0 {
		for _, msg := range m.Filters {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintWatch(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *WatchMessage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchMessage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, msg := range m.Events {
			dAtA[i] = 0xa
			i++
			i = encodeVarintWatch(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Version != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Version.Size()))
		n16, err := m.Version.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *WatchMessage_Event) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WatchMessage_Event) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Action != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Action))
	}
	if m.Object != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.Object.Size()))
		n17, err := m.Object.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.OldObject != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintWatch(dAtA, i, uint64(m.OldObject.Size()))
		n18, err := m.OldObject.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	return i, nil
}

func encodeVarintWatch(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}

type raftProxyWatchServer struct {
	local                       WatchServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyWatchServer(local WatchServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) WatchServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		p, ok := peer.FromContext(ctx)
		if !ok {
			return ctx, status.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := p.Addr.String()
		md, ok := metadata.FromIncomingContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, status.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewOutgoingContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyWatchServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyWatchServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyWatchServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

type Watch_WatchServerWrapper struct {
	Watch_WatchServer
	ctx context.Context
}

func (s Watch_WatchServerWrapper) Context() context.Context {
	return s.ctx
}

func (p *raftProxyWatchServer) Watch(r *WatchRequest, stream Watch_WatchServer) error {
	ctx := stream.Context()
	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return err
			}
			streamWrapper := Watch_WatchServerWrapper{
				Watch_WatchServer: stream,
				ctx:               ctx,
			}
			return p.local.Watch(r, streamWrapper)
		}
		return err
	}
	ctx, err = p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return err
	}
	clientStream, err := NewWatchClient(conn).Watch(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (m *Object) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Object != nil {
		n += m.Object.Size()
	}
	return n
}

func (m *Object_Node) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Service) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Network) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Task) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Cluster) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Secret) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Resource) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Resource != nil {
		l = m.Resource.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Extension) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Extension != nil {
		l = m.Extension.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *Object_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *SelectBySlot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceID)
	if l > 0 {
		n += 1 + l + sovWatch(uint64(l))
	}
	if m.Slot != 0 {
		n += 1 + sovWatch(uint64(m.Slot))
	}
	return n
}

func (m *SelectByCustom) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovWatch(uint64(l))
	}
	l = len(m.Index)
	if l > 0 {
		n += 1 + l + sovWatch(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}

func (m *SelectBy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.By != nil {
		n += m.By.Size()
	}
	return n
}

func (m *SelectBy_ID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_IDPrefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.IDPrefix)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_Name) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_NamePrefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NamePrefix)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_Custom) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Custom != nil {
		l = m.Custom.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *SelectBy_CustomPrefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.CustomPrefix != nil {
		l = m.CustomPrefix.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *SelectBy_ServiceID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ServiceID)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_NodeID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.NodeID)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_Slot) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Slot != nil {
		l = m.Slot.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}
func (m *SelectBy_DesiredState) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovWatch(uint64(m.DesiredState))
	return n
}
func (m *SelectBy_Role) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovWatch(uint64(m.Role))
	return n
}
func (m *SelectBy_Membership) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovWatch(uint64(m.Membership))
	return n
}
func (m *SelectBy_ReferencedNetworkID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ReferencedNetworkID)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_ReferencedSecretID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ReferencedSecretID)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_Kind) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	n += 1 + l + sovWatch(uint64(l))
	return n
}
func (m *SelectBy_ReferencedConfigID) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ReferencedConfigID)
	n += 2 + l + sovWatch(uint64(l))
	return n
}
func (m *WatchRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovWatch(uint64(l))
		}
	}
	if m.ResumeFrom != nil {
		l = m.ResumeFrom.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	if m.IncludeOldObject {
		n += 2
	}
	return n
}

func (m *WatchRequest_WatchEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Kind)
	if l > 0 {
		n += 1 + l + sovWatch(uint64(l))
	}
	if m.Action != 0 {
		n += 1 + sovWatch(uint64(m.Action))
	}
	if len(m.Filters) > 0 {
		for _, e := range m.Filters {
			l = e.Size()
			n += 1 + l + sovWatch(uint64(l))
		}
	}
	return n
}

func (m *WatchMessage) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Events) > 0 {
		for _, e := range m.Events {
			l = e.Size()
			n += 1 + l + sovWatch(uint64(l))
		}
	}
	if m.Version != nil {
		l = m.Version.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}

func (m *WatchMessage_Event) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovWatch(uint64(m.Action))
	}
	if m.Object != nil {
		l = m.Object.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	if m.OldObject != nil {
		l = m.OldObject.Size()
		n += 1 + l + sovWatch(uint64(l))
	}
	return n
}

func sovWatch(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozWatch(x uint64) (n int) {
	return sovWatch(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Object) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object{`,
		`Object:` + fmt.Sprintf("%v", this.Object) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Node) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Node{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Service) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Service{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Network) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Network{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Task{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Cluster) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Cluster{`,
		`Cluster:` + strings.Replace(fmt.Sprintf("%v", this.Cluster), "Cluster", "Cluster", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Secret{`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "Secret", "Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Resource) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Resource{`,
		`Resource:` + strings.Replace(fmt.Sprintf("%v", this.Resource), "Resource", "Resource", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Extension) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Extension{`,
		`Extension:` + strings.Replace(fmt.Sprintf("%v", this.Extension), "Extension", "Extension", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Object_Config) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Object_Config{`,
		`Config:` + strings.Replace(fmt.Sprintf("%v", this.Config), "Config", "Config", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBySlot) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBySlot{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`Slot:` + fmt.Sprintf("%v", this.Slot) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectByCustom) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectByCustom{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Index:` + fmt.Sprintf("%v", this.Index) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy{`,
		`By:` + fmt.Sprintf("%v", this.By) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_ID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_ID{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_IDPrefix) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_IDPrefix{`,
		`IDPrefix:` + fmt.Sprintf("%v", this.IDPrefix) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Name) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Name{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_NamePrefix) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_NamePrefix{`,
		`NamePrefix:` + fmt.Sprintf("%v", this.NamePrefix) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Custom) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Custom{`,
		`Custom:` + strings.Replace(fmt.Sprintf("%v", this.Custom), "SelectByCustom", "SelectByCustom", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_CustomPrefix) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_CustomPrefix{`,
		`CustomPrefix:` + strings.Replace(fmt.Sprintf("%v", this.CustomPrefix), "SelectByCustom", "SelectByCustom", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_ServiceID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_ServiceID{`,
		`ServiceID:` + fmt.Sprintf("%v", this.ServiceID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_NodeID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_NodeID{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Slot) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Slot{`,
		`Slot:` + strings.Replace(fmt.Sprintf("%v", this.Slot), "SelectBySlot", "SelectBySlot", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_DesiredState) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_DesiredState{`,
		`DesiredState:` + fmt.Sprintf("%v", this.DesiredState) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Role) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Role{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Membership) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Membership{`,
		`Membership:` + fmt.Sprintf("%v", this.Membership) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_ReferencedNetworkID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_ReferencedNetworkID{`,
		`ReferencedNetworkID:` + fmt.Sprintf("%v", this.ReferencedNetworkID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_ReferencedSecretID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_ReferencedSecretID{`,
		`ReferencedSecretID:` + fmt.Sprintf("%v", this.ReferencedSecretID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_Kind) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_Kind{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SelectBy_ReferencedConfigID) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SelectBy_ReferencedConfigID{`,
		`ReferencedConfigID:` + fmt.Sprintf("%v", this.ReferencedConfigID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WatchRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WatchRequest{`,
		`Entries:` + strings.Replace(fmt.Sprintf("%v", this.Entries), "WatchRequest_WatchEntry", "WatchRequest_WatchEntry", 1) + `,`,
		`ResumeFrom:` + strings.Replace(fmt.Sprintf("%v", this.ResumeFrom), "Version", "Version", 1) + `,`,
		`IncludeOldObject:` + fmt.Sprintf("%v", this.IncludeOldObject) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WatchRequest_WatchEntry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WatchRequest_WatchEntry{`,
		`Kind:` + fmt.Sprintf("%v", this.Kind) + `,`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`Filters:` + strings.Replace(fmt.Sprintf("%v", this.Filters), "SelectBy", "SelectBy", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WatchMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WatchMessage{`,
		`Events:` + strings.Replace(fmt.Sprintf("%v", this.Events), "WatchMessage_Event", "WatchMessage_Event", 1) + `,`,
		`Version:` + strings.Replace(fmt.Sprintf("%v", this.Version), "Version", "Version", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *WatchMessage_Event) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&WatchMessage_Event{`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`Object:` + strings.Replace(fmt.Sprintf("%v", this.Object), "Object", "Object", 1) + `,`,
		`OldObject:` + strings.Replace(fmt.Sprintf("%v", this.OldObject), "Object", "Object", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringWatch(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Object) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Object: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Object: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Node{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Node{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Service{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Service{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Network{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Network{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Task{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Task{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Cluster{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Secret{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Secret{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Resource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Resource{v}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Extension", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Extension{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Extension{v}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Config{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Object = &Object_Config{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SelectBySlot) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SelectBySlot: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SelectBySlot: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ServiceID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Slot", wireType)
			}
			m.Slot = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Slot |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SelectByCustom) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SelectByCustom: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SelectByCustom: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Index = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SelectBy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SelectBy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SelectBy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_ID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IDPrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_IDPrefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_Name{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NamePrefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_NamePrefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Custom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SelectByCustom{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.By = &SelectBy_Custom{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomPrefix", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SelectByCustom{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.By = &SelectBy_CustomPrefix{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_ServiceID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_NodeID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Slot", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &SelectBySlot{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.By = &SelectBy_Slot{v}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DesiredState", wireType)
			}
			var v TaskState
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= TaskState(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.By = &SelectBy_DesiredState{v}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var v NodeRole
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= NodeRole(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.By = &SelectBy_Role{v}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Membership", wireType)
			}
			var v NodeSpec_Membership
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= NodeSpec_Membership(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.By = &SelectBy_Membership{v}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedNetworkID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_ReferencedNetworkID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedSecretID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_ReferencedSecretID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_Kind{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedConfigID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.By = &SelectBy_ReferencedConfigID{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &WatchRequest_WatchEntry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeFrom", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeFrom == nil {
				m.ResumeFrom = &Version{}
			}
			if err := m.ResumeFrom.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludeOldObject", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IncludeOldObject = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchRequest_WatchEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Kind = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= WatchActionKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, &SelectBy{})
			if err := m.Filters[len(m.Filters)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchMessage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WatchMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WatchMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Events", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Events = append(m.Events, &WatchMessage_Event{})
			if err := m.Events[len(m.Events)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Version == nil {
				m.Version = &Version{}
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WatchMessage_Event) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Event: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Event: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Action |= WatchActionKind(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Object", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Object == nil {
				m.Object = &Object{}
			}
			if err := m.Object.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldObject", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWatch
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWatch
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OldObject == nil {
				m.OldObject = &Object{}
			}
			if err := m.OldObject.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWatch(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthWatch
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipWatch(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowWatch
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWatch
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthWatch
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthWatch
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowWatch
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipWatch(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthWatch
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthWatch = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowWatch   = fmt.Errorf("proto: integer overflow")
)
