The LaTeX-package ``fcolumn'', under LPPL 1.3
Author: Edgar Olthof 
E-mail: edgar <dot> olthof <at> inter <dot> nl <dot> net

DESCRIPTION
In financial reports, text and currency amounts are regularly put in
one table, e.g., a year balance or a profit-and-loss overview.
This package provides the settings for automatically typesetting
such columns, including the sum line (preceded by a rule of the correct
width), using the specifier ``f''.

The column specifier f itself is rather simple.  It is the predefined
version of a generic column F.  The generic version expects four
arguments: |#1| is the separator, |#2| is the decimal mark, |#3| is
the coding used for grouping digits of the integer part and decimal
part, and #4 is anything added before typesetting the contents of a 
column.  For example the f-column in the current version of the package
is using 3,2 as #3, meaning that numbers are typeset with 2 decimal 
digits and grouping is done on 3 digits.  The grouping character is 
``.'' and the decimal separator is ``,'', thereby coding for the 
continental European standard.  People in the Anglo-Saxon world would
rather code |\newcolumntype{f}{F,.{3,2}{}}|.

To show where and how the f-column is used, let's look at a typical
financial table.

properties    31 dec 2014   debts         31 dec 2014
-----------------------------------------------------
house          200.000,00   equity capital  50.000,00
bank account      -603,23   mortgage       150.000,00
savings         28.000,00                           
cash               145,85   profit          27.542,62
               ----------                  ----------
               227.542,62                  227.542,62

The core part of this table is input as 
\begin{tabular}{lflf}
house        &  200000    &  equity capital &  50000    \\
bank account &    -603,23 &  mortgage       & 150000    \\
savings      &   28000                                  \\
cash         &     145,85 &  profit         &  27542,62 \\
\sumline
\end{tabular}

The column specifier ``f'' (for ``finance'') is able to do the 
typesetting.  It constructs the sumline, typesets the numbers,
calculates the totals, makes rules of the correct widths, and 
checks whether the two columns are in balance; if not, the user
is warned via a message.  A special command \resetsumline exists
which allows one to restart a table, so that multiple tables that
are aligned are possible in one tabular or longtable environment.
   The fcolumn specifier can be used in a tabular environment
and in the longtable environment.  Specific fcolumn formatting,
like colour and/or font changes are possible, see the file
fcolumn.pdf.
   From v1.4.3 onwards fcolumn supports tagged pdf.

To install:
-----------
Type ``make install'' or run the file fcolumn.ins through
(La)TeX (in a directory also containing fcolumn.dtx) and move
the resultant file fcolumn.sty to a place searched by TeX.

To generate the documentation:
------------------------------
Type ``make''.  Or run the file fcolumn.dtx through LaTeX,
update the glossary and index by makeindex:

  makeindex -s gglo.ist -o fcolumn.gls fcolumn.glo
  makeindex -s gind.ist -o fcolumn.ind fcolumn.idx

and then LaTeX fcolumn.dtx again; presto!  If this doesn't work
because tagging support is not implemented at your location (yet),
you may remove or comment out the line that starts with \DocumentMetadata
in fcolumn.dtx; then follow the description above again.
