+++
title = "grub_conf resource"
draft = false
gh_repo = "inspec"
platform = "linux"

[menu]
  [menu.inspec]
    title = "grub_conf"
    identifier = "inspec/resources/os/grub_conf.md grub_conf resource"
    parent = "inspec/resources/os"
+++

Grub is a boot loader on the Linux platform used to load and then transfer control to an operating system kernel, after which that kernel initializes the rest of the operating system. Use the `grub_conf` Chef InSpec audit resource to test boot loader configuration settings that are defined in the `grub.conf` configuration file.

## Availability

### Installation

{{% inspec/inspec_installation %}}

### Version

This resource first became available in v1.0.0 of InSpec.

## Syntax

A `grub_conf` resource block declares a list of settings in a `grub.conf` file:

    describe grub_conf('path', 'kernel') do
      its('setting') { should eq 'value' }
    end

or:

    describe grub_conf('path') do
      its('default') { should eq '0' } #
      its('setting') { should eq 'value' }
    end

where

- `'service_name'` is a service listed in the `grub.conf` file
- `'path'` is the path to the `grub.conf` file
- `'kernel'` specifies the default kernel (by using `'default'`) or a specific kernel; `'default'` defines the position in the list of kernels at which the default kernel is defined, i.e. `should eq '0'` for the first kernel listed or `'path', 'default'` to use the default kernel as specified in the `grub.conf` file
- `'value'` is the value that is expected

## Examples

The following examples show how to use this Chef InSpec audit resource.

### Test a grub.conf file

A Grub configuration file located at `/etc/grub.conf` is similar to the following:

    # grub.conf generated by anaconda
    #
    # Note:  You do not need to rerun grub after making changes to this file
    # NOTICE:  You have a /boot partition.  This means that
    #          all kernel and initrd paths are relative to /boot/, eg.
    #          root (hd0,0)
    #          kernel /vmlinuz-version ro root=/dev/hda6
    #          initrd /initrd-version.img
    #boot=/dev/hda
    default=0
    timeout=10
    splashimage=(hd0,0)/grub/splash.xpm.gz
    title Red Hat Enterprise Linux ES (2.6.32-573.7.1.el6.x86_64)
        root (hd0,0)
        kernel /vmlinuz-2.6.32-573.7.1.el6.x86_64 ro root=/dev/hda6
        initrd /initrd-2.6.32-573.7.1.el6.x86_64.img
    title Red Hat Enterprise Linux ES (2.6.32-358.14.1.el6.x86_64)
        root (hd0,0)
        kernel /vmlinuz-2.6.32-358.14.1.el6.x86_64 ro root=/dev/hda6 ramdisk_size=400000
        initrd /initrd-2.6.32-358.14.1.el6.x86_64.img

This file defines two versions of RedHat Enterprise Linux, with version `2.6.32-573.7.1.el6.x86_64` specified as the default.

The following test verifies the kernel, ensures that kernel is the default kernel, its initial RAM disk (`initrd`), and the timeout:

    describe grub_conf('/etc/grub.conf',  'default') do
      its('kernel') { should include '/vmlinuz-2.6.32-573.7.1.el6.x86_64' }
      its('initrd') { should include '/initrd-2.6.32-573.7.1.el6.x86_64.img' }
      its('default') { should_not eq '1' }
      its('timeout') { should eq '10' }
    end

The following test verifies the `ramdisk_size` for the non-default kernel:

    describe grub_conf('/etc/grub.conf',  'Red Hat Enterprise Linux ES (2.6.32-358.14.1.el6.x86_64)') do
       its('kernel') { should include 'ramdisk_size=400000' }
     end

### Test a configuration file and boot configuration

    describe grub_conf('/etc/grub.conf',  'default') do
      its('kernel') { should include '/vmlinuz-2.6.32-573.7.1.el6.x86_64' }
      its('initrd') { should include '/initramfs-2.6.32-573.el6.x86_64.img=1' }
      its('default') { should_not eq '1' }
      its('timeout') { should eq '5' }
    end

### Test a specific kernel

    grub_conf('/etc/grub.conf',  'CentOS (2.6.32-573.12.1.el6.x86_64)') do
      its('kernel') { should include 'audit=1' }
    end

## Matchers

For a full list of available matchers, please visit our [matchers page](/inspec/matchers/).
