/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.protocol.giopmsgheaders.FragmentMessage;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.spi.orb.ORB;
import org.omg.CORBA.SystemException;

public class BufferManagerWriteStream
extends BufferManagerWrite {
    private int fragmentCount = 0;

    BufferManagerWriteStream(ORB oRB) {
        super(oRB);
    }

    @Override
    public boolean sentFragment() {
        return this.fragmentCount > 0;
    }

    @Override
    public int getBufferSize() {
        return this.orb.getORBData().getGIOPFragmentSize();
    }

    @Override
    public void overflow(ByteBufferWithInfo byteBufferWithInfo) {
        MessageBase.setFlag(byteBufferWithInfo.byteBuffer, 2);
        try {
            this.sendFragment(false);
        }
        catch (SystemException systemException) {
            this.orb.getPIHandler().invokeClientPIEndingPoint(2, systemException);
            throw systemException;
        }
        byteBufferWithInfo.position(0);
        byteBufferWithInfo.buflen = byteBufferWithInfo.byteBuffer.limit();
        byteBufferWithInfo.fragmented = true;
        FragmentMessage fragmentMessage = ((CDROutputObject)this.outputObject).getMessageHeader().createFragmentMessage();
        fragmentMessage.write((CDROutputObject)this.outputObject);
    }

    private void sendFragment(boolean bl) {
        Connection connection = ((OutputObject)this.outputObject).getMessageMediator().getConnection();
        connection.writeLock();
        try {
            connection.sendWithoutLock((OutputObject)this.outputObject);
            ++this.fragmentCount;
        }
        finally {
            connection.writeUnlock();
        }
    }

    @Override
    public void sendMessage() {
        this.sendFragment(true);
        this.sentFullMessage = true;
    }

    @Override
    public void close() {
    }
}

