/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.superobject;

import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.object.Shape;

public class SuperObject
extends PythonBuiltinObject {
    private final Assumption neverReinitialized = Truffle.getRuntime().createAssumption("super object was never reinitialized");
    private Object type;
    private Object objecttype;
    private Object object;

    public SuperObject(Object cls, Shape instanceShape) {
        super(cls, instanceShape);
    }

    @CompilerDirectives.TruffleBoundary
    private void invalidateAssumption() {
        this.neverReinitialized.invalidate();
    }

    public void init(Object newType, Object newObjecttype, Object newObject) {
        if (this.type != null) {
            this.invalidateAssumption();
        }
        this.type = newType;
        this.objecttype = newObjecttype;
        this.object = newObject;
    }

    public Object getObjectType() {
        return this.objecttype;
    }

    public Object getType() {
        return this.type;
    }

    public Object getObject() {
        return this.object;
    }

    public Assumption getNeverReinitializedAssumption() {
        return this.neverReinitialized;
    }
}

