/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import org.firebirdsql.gds.impl.GDSFactoryPlugin;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FBConnection;

public abstract class BaseGDSFactoryPlugin
implements GDSFactoryPlugin {
    @Override
    public Class<?> getConnectionClass() {
        return FBConnection.class;
    }

    @Override
    public String getDefaultProtocol() {
        return this.getSupportedProtocolList().get(0);
    }

    @Override
    public String getDatabasePath(String jdbcUrl) throws SQLException {
        for (String protocol : this.getSupportedProtocolList()) {
            if (!jdbcUrl.startsWith(protocol)) continue;
            return jdbcUrl.substring(protocol.length());
        }
        throw FbExceptionBuilder.forNonTransientConnectionException(337248263).messageParameter((Object)jdbcUrl, (Object)("JDBC URL not supported by protocol: " + this.getTypeName())).toSQLException();
    }

    protected static void requirePath(String path) throws SQLException {
        if (path == null) {
            throw FbExceptionBuilder.toNonTransientConnectionException(337248329);
        }
    }

    @Override
    public String getDatabasePath(String server, Integer port, String path) throws SQLException {
        BaseGDSFactoryPlugin.requirePath(path);
        if (server == null) {
            return path;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("//").append(server);
        if (port != null) {
            sb.append(':').append(port);
        }
        sb.append('/').append(path);
        return sb.toString();
    }

    public final int hashCode() {
        return this.getTypeName().hashCode();
    }

    public final boolean equals(Object obj) {
        return obj != null && (obj == this || this.getClass() == obj.getClass());
    }
}

