/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyLanguageFacadeKt;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstFromImportStatement;
import com.jetbrains.python.ast.PyAstImportStatementBase;
import com.jetbrains.python.ast.PyAstStatement;
import com.jetbrains.python.ast.PyAstStringLiteralExpression;
import com.jetbrains.python.ast.controlFlow.AstScopeOwner;
import com.jetbrains.python.ast.docstring.DocStringUtilCore;
import com.jetbrains.python.ast.impl.PyPsiUtilsCore;
import com.jetbrains.python.ast.impl.PyUtilCore;
import com.jetbrains.python.psi.FutureFeature;
import com.jetbrains.python.psi.LanguageLevel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface PyAstFile
extends PyAstElement,
PsiFile,
PyAstDocStringOwner,
AstScopeOwner {
    default public List<? extends PyAstStatement> getStatements() {
        ArrayList<PyAstStatement> stmts = new ArrayList<PyAstStatement>();
        for (PsiElement child : this.getChildren()) {
            if (!(child instanceof PyAstStatement)) continue;
            PyAstStatement statement = (PyAstStatement)child;
            stmts.add(statement);
        }
        return stmts;
    }

    default public LanguageLevel getLanguageLevel() {
        return PyLanguageFacadeKt.getEffectiveLanguageLevel((PsiFile)this);
    }

    public boolean hasImportFromFuture(FutureFeature var1);

    @ApiStatus.Internal
    default public boolean isAcceptedFor(@NotNull Class<?> visitorClass) {
        if (visitorClass == null) {
            PyAstFile.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    @Nullable
    default public String getDocStringValue() {
        return DocStringUtilCore.getDocStringValue(this);
    }

    default public List<? extends PyAstImportStatementBase> getImportBlock() {
        ArrayList result = new ArrayList();
        PsiElement firstChild = this.getFirstChild();
        PsiElement currentStatement = firstChild instanceof PyAstImportStatementBase ? firstChild : PsiTreeUtil.getNextSiblingOfType((PsiElement)firstChild, PyAstImportStatementBase.class);
        if (currentStatement != null) {
            ArrayList<PyAstImportStatementBase> fromFuture = new ArrayList<PyAstImportStatementBase>();
            while (currentStatement instanceof PyAstFromImportStatement && ((PyAstFromImportStatement)currentStatement).isFromFuture()) {
                fromFuture.add((PyAstImportStatementBase)currentStatement);
                currentStatement = PyPsiUtilsCore.getNextNonCommentSibling(currentStatement, true);
            }
            boolean hasModuleLevelDunders = false;
            while (PyUtilCore.isAssignmentToModuleLevelDunderName(currentStatement)) {
                hasModuleLevelDunders = true;
                currentStatement = PyPsiUtilsCore.getNextNonCommentSibling(currentStatement, true);
            }
            if (!hasModuleLevelDunders) {
                result.addAll(fromFuture);
            }
            while (currentStatement instanceof PyAstImportStatementBase) {
                result.add((PyAstImportStatementBase)currentStatement);
                currentStatement = PyPsiUtilsCore.getNextNonCommentSibling(currentStatement, true);
            }
        }
        return result;
    }

    @Override
    @Nullable
    default public PyAstStringLiteralExpression getDocStringExpression() {
        return DocStringUtilCore.findDocStringExpression(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitorClass", "com/jetbrains/python/ast/PyAstFile", "isAcceptedFor"));
    }
}

