/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.array.ArrayTableCellRenderer;
import com.jetbrains.python.debugger.array.AsyncArrayTableModel;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.ColumnFilter;
import com.jetbrains.python.debugger.containerview.DataViewStrategy;
import com.jetbrains.python.debugger.containerview.PyDataViewerCommunityPanel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayViewStrategy
extends DataViewStrategy {
    private final String myTypeName;

    @NotNull
    public static ArrayViewStrategy createInstanceForNumpyArray() {
        return new ArrayViewStrategy("ndarray");
    }

    @NotNull
    public static ArrayViewStrategy createInstanceForNumpyRecarray() {
        return new ArrayViewStrategy("recarray");
    }

    @NotNull
    public static ArrayViewStrategy createInstanceForEagerTensor() {
        return new ArrayViewStrategy("EagerTensor");
    }

    @NotNull
    public static ArrayViewStrategy createInstanceForResourceVariable() {
        return new ArrayViewStrategy("ResourceVariable");
    }

    @NotNull
    public static ArrayViewStrategy createInstanceForSparseTensor() {
        return new ArrayViewStrategy("SparseTensor");
    }

    @NotNull
    public static ArrayViewStrategy createInstanceForTensor() {
        return new ArrayViewStrategy("Tensor");
    }

    protected ArrayViewStrategy(@NotNull String typeName) {
        if (typeName == null) {
            ArrayViewStrategy.$$$reportNull$$$0(0);
        }
        this.myTypeName = typeName;
    }

    @Override
    public AsyncArrayTableModel createTableModel(int rowCount, int columnCount, @NotNull PyDataViewerCommunityPanel panel2, @NotNull PyDebugValue debugValue) {
        if (panel2 == null) {
            ArrayViewStrategy.$$$reportNull$$$0(1);
        }
        if (debugValue == null) {
            ArrayViewStrategy.$$$reportNull$$$0(2);
        }
        return new AsyncArrayTableModel(rowCount, columnCount, panel2, debugValue, this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ColoredCellRenderer createCellRenderer(double minValue, double maxValue, @NotNull ArrayChunk arrayChunk) {
        void arrayChunk2;
        if (arrayChunk == null) {
            ArrayViewStrategy.$$$reportNull$$$0(3);
        }
        ArrayTableCellRenderer renderer = new ArrayTableCellRenderer(minValue, maxValue, arrayChunk2.getType());
        renderer.fillColorRange(arrayChunk2.getMin(), arrayChunk2.getMax());
        return renderer;
    }

    @Override
    public boolean isNumeric(String dtypeKind) {
        if (dtypeKind != null) {
            return "biufc".contains(dtypeKind.substring(0, 1));
        }
        return false;
    }

    @Override
    @NotNull
    public String sortModifier(@NotNull String varName, @NotNull RowSorter.SortKey key) {
        if (varName == null) {
            ArrayViewStrategy.$$$reportNull$$$0(4);
        }
        if (key == null) {
            ArrayViewStrategy.$$$reportNull$$$0(5);
        }
        String string = String.format("%s[%s[:,%d].argsort()%s]", varName, varName, key.getColumn(), key.getSortOrder() == SortOrder.ASCENDING ? "" : "[::-1]");
        if (string == null) {
            ArrayViewStrategy.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String filterModifier(@NotNull String varName, @NotNull ColumnFilter filter) {
        if (varName == null) {
            ArrayViewStrategy.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            ArrayViewStrategy.$$$reportNull$$$0(8);
        }
        if (filter.isSubstring()) {
            throw new UnsupportedOperationException("Substring search is not supported on numpy arrays");
        }
        String string = String.format("%1$s[_np_vectorize(lambda %4$s: bool(%2$s))(%1$s[:, %3$d])]", varName, filter.getFilter(), filter.getColumn(), "x");
        if (string == null) {
            ArrayViewStrategy.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    @Nullable
    public String getInitExecuteString() {
        return "import numpy as _np; _np_vectorize = _np.vectorize";
    }

    @Override
    @NotNull
    public String getTypeName() {
        String string = this.myTypeName;
        if (string == null) {
            ArrayViewStrategy.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayChunk";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/array/ArrayViewStrategy";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/array/ArrayViewStrategy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "sortModifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterModifier";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCellRenderer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "sortModifier";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

