/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class HttpHeader {
    private static final int BUFFER_INT_SIZE = 4;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private byte[] name;
    private byte[] value;

    private HttpHeader() {
    }

    public HttpHeader(String name, String value) {
        this.name = name.getBytes(UTF8);
        this.value = value.getBytes(UTF8);
    }

    public HttpHeader(byte[] name, byte[] value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return new String(this.name, UTF8);
    }

    public byte[] getNameBytes() {
        return this.name;
    }

    public String getValue() {
        if (this.value == null) {
            return "";
        }
        return new String(this.value, UTF8);
    }

    public byte[] getValueBytes() {
        return this.value;
    }

    public String toString() {
        return this.getName() + ":" + this.getValue();
    }

    public static List<HttpHeader> loadHeadersListFromMarshalledHeadersBlob(ByteBuffer headersBlob) {
        ArrayList<HttpHeader> headers = new ArrayList<HttpHeader>(16);
        while (headersBlob.hasRemaining()) {
            int nameLen = headersBlob.getInt();
            if (nameLen <= 0) continue;
            byte[] nameBuf = new byte[nameLen];
            headersBlob.get(nameBuf);
            int valLen = headersBlob.getInt();
            byte[] valueBuf = new byte[valLen];
            headersBlob.get(valueBuf);
            headers.add(new HttpHeader(nameBuf, valueBuf));
        }
        return headers;
    }

    public static byte[] marshalHeadersForJni(List<HttpHeader> headers) {
        int size = 0;
        for (HttpHeader header : headers) {
            if (header.getNameBytes().length <= 0) continue;
            size += header.getNameBytes().length + header.getValueBytes().length + 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (HttpHeader header : headers) {
            if (header.getNameBytes().length <= 0) continue;
            buffer.putInt(header.getNameBytes().length);
            buffer.put(header.getNameBytes());
            buffer.putInt(header.getValueBytes().length);
            buffer.put(header.getValueBytes());
        }
        return buffer.array();
    }

    public static HttpHeader[] loadHeadersFromMarshalledHeadersBlob(ByteBuffer headersBlob) {
        List<HttpHeader> headers = HttpHeader.loadHeadersListFromMarshalledHeadersBlob(headersBlob);
        HttpHeader[] headersArray = new HttpHeader[headers.size()];
        return headers.toArray(headersArray);
    }
}

