/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.collectors;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.opensearch.performanceanalyzer.commons.collectors.StatsCollector;
import org.opensearch.performanceanalyzer.commons.stats.ServiceMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.util.Util;

public abstract class PerformanceAnalyzerMetricsCollector
implements Runnable {
    private static final Logger LOG = LogManager.getLogger(PerformanceAnalyzerMetricsCollector.class);
    private int timeInterval;
    private long startTime;
    private String collectorName;
    private MeasurementSet statLatencyMetric;
    private StatExceptionCode errorMetric;
    protected StringBuilder value;
    protected State state;
    private boolean threadContentionMonitoringEnabled;
    private AtomicBoolean bInProgress = new AtomicBoolean(false);

    protected PerformanceAnalyzerMetricsCollector(int timeInterval, String collectorName, MeasurementSet statLatencyMetric, StatExceptionCode errorMetric) {
        this.timeInterval = timeInterval;
        this.collectorName = collectorName;
        this.statLatencyMetric = statLatencyMetric;
        this.errorMetric = errorMetric;
        this.value = new StringBuilder();
        this.state = State.HEALTHY;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public boolean inProgress() {
        return this.bInProgress.get();
    }

    public String getCollectorName() {
        return this.collectorName;
    }

    public abstract void collectMetrics(long var1);

    public void setStartTime(long startTime) {
        this.startTime = startTime;
        this.bInProgress.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long mCurrT = System.currentTimeMillis();
        try {
            Util.invokePrivileged(() -> this.collectMetrics(this.startTime));
            LOG.debug("[ {} ] Successfully collected ClusterManager Event Metrics.", (Object)this.getCollectorName());
            ServiceMetrics.COMMONS_STAT_METRICS_AGGREGATOR.updateStat(this.statLatencyMetric, System.currentTimeMillis() - mCurrT);
        }
        catch (Exception ex) {
            LOG.error("[ {} ] Error in metric collection for startTime {}: {}", new Supplier[]{() -> mCurrT, () -> this.getCollectorName(), () -> ex.toString()});
            StatsCollector.instance().logException(this.errorMetric);
        }
        finally {
            this.bInProgress.set(false);
        }
    }

    @VisibleForTesting
    public StringBuilder getValue() {
        return this.value;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setThreadContentionMonitoringEnabled(boolean enabled) {
        this.threadContentionMonitoringEnabled = enabled;
    }

    public boolean getThreadContentionMonitoringEnabled() {
        return this.threadContentionMonitoringEnabled;
    }

    public static enum State {
        HEALTHY,
        SLOW,
        MUTED;

    }
}

