"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderAnnotations = void 0;
var merge_utils_1 = require("../../../../../utils/themes/merge_utils");
var spec_1 = require("../../../state/utils/spec");
var specs_1 = require("../../../utils/specs");
var lines_1 = require("./lines");
var rect_1 = require("./rect");
function renderAnnotations(ctx, _a, renderOnBackground) {
    var annotationDimensions = _a.annotationDimensions, annotationSpecs = _a.annotationSpecs, rotation = _a.rotation, renderingArea = _a.renderingArea;
    if (renderOnBackground === void 0) { renderOnBackground = true; }
    annotationDimensions.forEach(function (annotation, id) {
        var spec = spec_1.getSpecsById(annotationSpecs, id);
        if (!spec) {
            return null;
        }
        var isBackground = !spec.zIndex || (spec.zIndex && spec.zIndex <= 0);
        if ((isBackground && renderOnBackground) || (!isBackground && !renderOnBackground)) {
            if (specs_1.isLineAnnotation(spec)) {
                var lineStyle = merge_utils_1.mergeWithDefaultAnnotationLine(spec.style);
                lines_1.renderLineAnnotations(ctx, annotation, lineStyle, rotation, renderingArea);
            }
            else if (specs_1.isRectAnnotation(spec)) {
                var rectStyle = merge_utils_1.mergeWithDefaultAnnotationRect(spec.style);
                rect_1.renderRectAnnotations(ctx, annotation, rectStyle, rotation, renderingArea);
            }
        }
    });
}
exports.renderAnnotations = renderAnnotations;
//# sourceMappingURL=index.js.map