/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core.lock;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.alerting.core.lock.LockModel;
import org.opensearch.alerting.core.lock.LockServiceKt;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.engine.DocumentMissingException;
import org.opensearch.index.engine.VersionConflictEngineException;
import org.opensearch.transport.client.Client;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011J\u001e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00122\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002J\u001c\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u001e\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u001c\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00152\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\tH\u0002J\u000e\u0010!\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/opensearch/alerting/core/lock/LockService;", "", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "<init>", "(Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;)V", "testInstant", "Ljava/time/Instant;", "lockIndexExist", "", "acquireLock", "", "scheduledJob", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "listener", "Lorg/opensearch/core/action/ActionListener;", "Lorg/opensearch/alerting/core/lock/LockModel;", "acquireLockWithId", "scheduledJobId", "", "createLock", "tempLock", "updateLock", "findLock", "lockId", "release", "lock", "deleteLock", "createLockIndex", "isLockReleased", "getNow", "setTime", "Companion", "alerting-core"})
public final class LockService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @Nullable
    private Instant testInstant;
    @NotNull
    public static final String LOCK_INDEX_NAME = ".opensearch-alerting-config-lock";
    @NotNull
    private static final TimeValue LOCK_EXPIRED_MINUTES = new TimeValue(5L, TimeUnit.MINUTES);

    public LockService(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.client = client;
        this.clusterService = clusterService;
    }

    public final boolean lockIndexExist() {
        return this.clusterService.state().routingTable().hasIndex(LOCK_INDEX_NAME);
    }

    public final void acquireLock(@NotNull ScheduledJob scheduledJob, @NotNull ActionListener<LockModel> listener) {
        Intrinsics.checkNotNullParameter((Object)scheduledJob, (String)"scheduledJob");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        String scheduledJobId = scheduledJob.getId();
        this.acquireLockWithId(scheduledJobId, listener);
    }

    public final void acquireLockWithId(@NotNull String scheduledJobId, @NotNull ActionListener<LockModel> listener) {
        Intrinsics.checkNotNullParameter((Object)scheduledJobId, (String)"scheduledJobId");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        String lockId = LockModel.Companion.generateLockId(scheduledJobId);
        this.createLockIndex((ActionListener<Boolean>)((ActionListener)new ActionListener<Boolean>(this, lockId, listener, scheduledJobId){
            final /* synthetic */ LockService this$0;
            final /* synthetic */ String $lockId;
            final /* synthetic */ ActionListener<LockModel> $listener;
            final /* synthetic */ String $scheduledJobId;
            {
                this.this$0 = $receiver;
                this.$lockId = $lockId;
                this.$listener = $listener;
                this.$scheduledJobId = $scheduledJobId;
            }

            public void onResponse(boolean created) {
                if (created) {
                    try {
                        this.this$0.findLock(this.$lockId, (ActionListener<LockModel>)((ActionListener)new ActionListener<LockModel>(this.this$0, this.$listener, this.$scheduledJobId){
                            final /* synthetic */ LockService this$0;
                            final /* synthetic */ ActionListener<LockModel> $listener;
                            final /* synthetic */ String $scheduledJobId;
                            {
                                this.this$0 = $receiver;
                                this.$listener = $listener;
                                this.$scheduledJobId = $scheduledJobId;
                            }

                            public void onResponse(LockModel existingLock) {
                                if (existingLock != null) {
                                    Instant currentTimestamp = LockService.access$getNow(this.this$0);
                                    if (LockService.access$isLockReleased(this.this$0, existingLock)) {
                                        LockServiceKt.access$getLog$p().debug("lock is released or expired: {}", (Object)existingLock);
                                        LockModel updateLock2 = new LockModel(existingLock, LockService.access$getNow(this.this$0), false);
                                        LockService.access$updateLock(this.this$0, updateLock2, this.$listener);
                                    } else {
                                        LockServiceKt.access$getLog$p().debug("Lock is NOT released. {}", (Object)existingLock);
                                        if (existingLock.getLockTime().getEpochSecond() + LockService.Companion.getLOCK_EXPIRED_MINUTES().getSeconds() < currentTimestamp.getEpochSecond()) {
                                            LockServiceKt.access$getLog$p().debug("Lock is expired. Renewing Lock {}", (Object)existingLock);
                                            LockModel updateLock3 = new LockModel(existingLock, LockService.access$getNow(this.this$0), false);
                                            LockService.access$updateLock(this.this$0, updateLock3, this.$listener);
                                        } else {
                                            LockServiceKt.access$getLog$p().debug("Lock is NOT expired. Not running monitor {}", (Object)existingLock);
                                            this.$listener.onResponse(null);
                                        }
                                    }
                                } else {
                                    LockModel tempLock = new LockModel(this.$scheduledJobId, LockService.access$getNow(this.this$0), false);
                                    LockServiceKt.access$getLog$p().debug("Lock does not exist. Creating new lock {}", (Object)tempLock);
                                    LockService.access$createLock(this.this$0, tempLock, this.$listener);
                                }
                            }

                            public void onFailure(Exception e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                this.$listener.onFailure(e);
                            }
                        }));
                    }
                    catch (VersionConflictEngineException e) {
                        LockServiceKt.access$getLog$p().debug("could not acquire lock {}", (Object)e.getMessage());
                        this.$listener.onResponse(null);
                    }
                } else {
                    this.$listener.onResponse(null);
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$listener.onFailure(e);
            }
        }));
    }

    private final void createLock(LockModel tempLock, ActionListener<LockModel> listener) {
        try {
            IndexRequest indexRequest = new IndexRequest(LOCK_INDEX_NAME).id(tempLock.getLockId());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
            ToXContent.Params params = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
            IndexRequest request = indexRequest.source(tempLock.toXContent(xContentBuilder, params)).setIfSeqNo(-2L).setIfPrimaryTerm(0L).create(true);
            this.client.index(request, (ActionListener)new ActionListener<IndexResponse>(listener, tempLock){
                final /* synthetic */ ActionListener<LockModel> $listener;
                final /* synthetic */ LockModel $tempLock;
                {
                    this.$listener = $listener;
                    this.$tempLock = $tempLock;
                }

                public void onResponse(IndexResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$listener.onResponse((Object)new LockModel(this.$tempLock, response.getSeqNo(), response.getPrimaryTerm()));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e instanceof VersionConflictEngineException) {
                        LockServiceKt.access$getLog$p().debug("Lock is already created. {}", (Object)e.getMessage());
                        this.$listener.onResponse(null);
                        return;
                    }
                    this.$listener.onFailure(e);
                }
            });
        }
        catch (IOException ex) {
            LockServiceKt.access$getLog$p().error("IOException occurred creating lock", (Throwable)ex);
            listener.onFailure((Exception)ex);
        }
    }

    private final void updateLock(LockModel updateLock2, ActionListener<LockModel> listener) {
        try {
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(LOCK_INDEX_NAME)).id(updateLock2.getLockId()).setIfSeqNo(updateLock2.getSeqNo()).setIfPrimaryTerm(updateLock2.getPrimaryTerm());
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"jsonBuilder(...)");
            ToXContent.Params params = ToXContent.EMPTY_PARAMS;
            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
            UpdateRequest updateRequest2 = updateRequest.doc(updateLock2.toXContent(xContentBuilder, params)).fetchSource(true);
            this.client.update(updateRequest2, (ActionListener)new ActionListener<UpdateResponse>(listener, updateLock2){
                final /* synthetic */ ActionListener<LockModel> $listener;
                final /* synthetic */ LockModel $updateLock;
                {
                    this.$listener = $listener;
                    this.$updateLock = $updateLock;
                }

                public void onResponse(UpdateResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$listener.onResponse((Object)new LockModel(this.$updateLock, response.getSeqNo(), response.getPrimaryTerm()));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e instanceof VersionConflictEngineException) {
                        LockServiceKt.access$getLog$p().debug("could not acquire lock {}", (Object)e.getMessage());
                    }
                    if (e instanceof DocumentMissingException) {
                        LockServiceKt.access$getLog$p().debug("Document is deleted. This happens if the job is already removed and this is the last run.{}", (Object)e.getMessage());
                    }
                    if (e instanceof IOException) {
                        LockServiceKt.access$getLog$p().error("IOException occurred updating lock.", (Throwable)e);
                    }
                    this.$listener.onResponse(null);
                }
            });
        }
        catch (IOException ex) {
            LockServiceKt.access$getLog$p().error("IOException occurred updating lock.", (Throwable)ex);
            listener.onResponse(null);
        }
    }

    public final void findLock(@NotNull String lockId, @NotNull ActionListener<LockModel> listener) {
        Intrinsics.checkNotNullParameter((Object)lockId, (String)"lockId");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        GetRequest getRequest = new GetRequest(LOCK_INDEX_NAME).id(lockId);
        this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(listener){
            final /* synthetic */ ActionListener<LockModel> $listener;
            {
                this.$listener = $listener;
            }

            public void onResponse(GetResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                if (!response.isExists()) {
                    this.$listener.onResponse(null);
                } else {
                    try {
                        XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
                        parser.nextToken();
                        Intrinsics.checkNotNull((Object)parser);
                        this.$listener.onResponse((Object)LockModel.Companion.parse(parser, response.getSeqNo(), response.getPrimaryTerm()));
                    }
                    catch (IOException e) {
                        LockServiceKt.access$getLog$p().error("IOException occurred finding lock", (Throwable)e);
                        this.$listener.onResponse(null);
                    }
                }
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                LockServiceKt.access$getLog$p().error("Exception occurred finding lock", (Throwable)e);
                this.$listener.onFailure(e);
            }
        });
    }

    public final void release(@Nullable LockModel lock, @NotNull ActionListener<Boolean> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (lock == null) {
            LockServiceKt.access$getLog$p().error("Lock is null. Nothing to release.");
            listener.onResponse((Object)false);
        } else {
            LockServiceKt.access$getLog$p().debug("Releasing lock: {}", (Object)lock);
            LockModel lockToRelease = new LockModel(lock, true);
            this.updateLock(lockToRelease, (ActionListener<LockModel>)((ActionListener)new ActionListener<LockModel>(listener){
                final /* synthetic */ ActionListener<Boolean> $listener;
                {
                    this.$listener = $listener;
                }

                public void onResponse(LockModel releasedLock) {
                    this.$listener.onResponse((Object)(releasedLock != null ? 1 : 0));
                }

                public void onFailure(Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.$listener.onFailure(e);
                }
            }));
        }
    }

    public final void deleteLock(@NotNull String lockId, @NotNull ActionListener<Boolean> listener) {
        Intrinsics.checkNotNullParameter((Object)lockId, (String)"lockId");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        DeleteRequest deleteRequest = new DeleteRequest(LOCK_INDEX_NAME).id(lockId);
        this.client.delete(deleteRequest, (ActionListener)new ActionListener<DeleteResponse>(listener){
            final /* synthetic */ ActionListener<Boolean> $listener;
            {
                this.$listener = $listener;
            }

            public void onResponse(DeleteResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$listener.onResponse((Object)(response.getResult() == DocWriteResponse.Result.DELETED || response.getResult() == DocWriteResponse.Result.NOT_FOUND ? 1 : 0));
            }

            public void onFailure(Exception e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e instanceof IndexNotFoundException || e.getCause() instanceof IndexNotFoundException) {
                    LockServiceKt.access$getLog$p().debug("Index is not found to delete lock. {}", (Object)e.getMessage());
                    this.$listener.onResponse((Object)true);
                } else {
                    this.$listener.onFailure(e);
                }
            }
        });
    }

    private final void createLockIndex(ActionListener<Boolean> listener) {
        if (this.lockIndexExist()) {
            listener.onResponse((Object)true);
        } else {
            CreateIndexRequest indexRequest = new CreateIndexRequest(LOCK_INDEX_NAME).mapping(Companion.lockMapping()).settings(Settings.builder().put("index.hidden", true).build());
            this.client.admin().indices().create(indexRequest, (ActionListener)new ActionListener<CreateIndexResponse>(listener){
                final /* synthetic */ ActionListener<Boolean> $listener;
                {
                    this.$listener = $listener;
                }

                public void onResponse(CreateIndexResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    this.$listener.onResponse((Object)response.isAcknowledged());
                }

                public void onFailure(Exception ex) {
                    Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                    LockServiceKt.access$getLog$p().error("Failed to update config index schema", (Throwable)ex);
                    if (ex instanceof ResourceAlreadyExistsException || ex.getCause() instanceof ResourceAlreadyExistsException) {
                        this.$listener.onResponse((Object)true);
                    } else {
                        this.$listener.onFailure(ex);
                    }
                }
            });
        }
    }

    private final boolean isLockReleased(LockModel lock) {
        return lock.getReleased();
    }

    private final Instant getNow() {
        Instant instant;
        if (this.testInstant != null) {
            Instant instant2 = this.testInstant;
            instant = instant2;
            Intrinsics.checkNotNull((Object)instant2);
        } else {
            Instant instant3 = Instant.now();
            Intrinsics.checkNotNull((Object)instant3);
            instant = instant3;
        }
        return instant;
    }

    public final void setTime(@NotNull Instant testInstant) {
        Intrinsics.checkNotNullParameter((Object)testInstant, (String)"testInstant");
        this.testInstant = testInstant;
    }

    @JvmStatic
    @Nullable
    public static final String lockMapping() {
        return Companion.lockMapping();
    }

    public static final /* synthetic */ Instant access$getNow(LockService $this) {
        return $this.getNow();
    }

    public static final /* synthetic */ boolean access$isLockReleased(LockService $this, LockModel lock) {
        return $this.isLockReleased(lock);
    }

    public static final /* synthetic */ void access$updateLock(LockService $this, LockModel updateLock2, ActionListener listener) {
        $this.updateLock(updateLock2, (ActionListener<LockModel>)listener);
    }

    public static final /* synthetic */ void access$createLock(LockService $this, LockModel tempLock, ActionListener listener) {
        $this.createLock(tempLock, (ActionListener<LockModel>)listener);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/opensearch/alerting/core/lock/LockService$Companion;", "", "<init>", "()V", "LOCK_INDEX_NAME", "", "LOCK_EXPIRED_MINUTES", "Lorg/opensearch/common/unit/TimeValue;", "getLOCK_EXPIRED_MINUTES", "()Lorg/opensearch/common/unit/TimeValue;", "lockMapping", "alerting-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeValue getLOCK_EXPIRED_MINUTES() {
            return LOCK_EXPIRED_MINUTES;
        }

        @JvmStatic
        @Nullable
        public final String lockMapping() {
            String string;
            URL uRL = LockService.class.getClassLoader().getResource("mappings/opensearch-alerting-config-lock.json");
            if (uRL != null) {
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                string = new String(byArray, charset);
            } else {
                string = null;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

