/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _clcc7d_h_
#define _clcc7d_h_


#ifdef __cplusplus
extern "C" {
#endif

#define NVCC7D_CORE_CHANNEL_DMA                                                 (0x0000CC7D)

#define NV_DISP_NOTIFIER                                                             0x00000000
#define NV_DISP_NOTIFIER_SIZEOF                                                      0x00000010
#define NV_DISP_NOTIFIER__0                                                          0x00000000
#define NV_DISP_NOTIFIER__0_PRESENT_COUNT                                            7:0
#define NV_DISP_NOTIFIER__0_FIELD                                                    8:8
#define NV_DISP_NOTIFIER__0_FLIP_TYPE                                                9:9
#define NV_DISP_NOTIFIER__0_FLIP_TYPE_NON_TEARING                                    0x00000000
#define NV_DISP_NOTIFIER__0_FLIP_TYPE_IMMEDIATE                                      0x00000001
#define NV_DISP_NOTIFIER__0_R1                                                       15:10
#define NV_DISP_NOTIFIER__0_R2                                                       23:16
#define NV_DISP_NOTIFIER__0_R3                                                       29:24
#define NV_DISP_NOTIFIER__0_STATUS                                                   31:30
#define NV_DISP_NOTIFIER__0_STATUS_NOT_BEGUN                                         0x00000000
#define NV_DISP_NOTIFIER__0_STATUS_BEGUN                                             0x00000001
#define NV_DISP_NOTIFIER__0_STATUS_FINISHED                                          0x00000002
#define NV_DISP_NOTIFIER__1                                                          0x00000001
#define NV_DISP_NOTIFIER__1_R4                                                       31:0
#define NV_DISP_NOTIFIER__2                                                          0x00000002
#define NV_DISP_NOTIFIER__2_TIMESTAMP_LO                                             31:0
#define NV_DISP_NOTIFIER__3                                                          0x00000003
#define NV_DISP_NOTIFIER__3_TIMESTAMP_HI                                             31:0


// dma opcode instructions
#define NVCC7D_DMA                                                                     
#define NVCC7D_DMA_OPCODE                                                        31:29 
#define NVCC7D_DMA_OPCODE_METHOD                                            0x00000000 
#define NVCC7D_DMA_OPCODE_JUMP                                              0x00000001 
#define NVCC7D_DMA_OPCODE_NONINC_METHOD                                     0x00000002 
#define NVCC7D_DMA_OPCODE_SET_SUBDEVICE_MASK                                0x00000003 
#define NVCC7D_DMA_METHOD_COUNT                                                  27:18 
#define NVCC7D_DMA_METHOD_OFFSET                                                  15:2 
#define NVCC7D_DMA_DATA                                                           31:0 
#define NVCC7D_DMA_DATA_NOP                                                 0x00000000 
#define NVCC7D_DMA_JUMP_OFFSET                                                    15:2 
#define NVCC7D_DMA_SET_SUBDEVICE_MASK_VALUE                                       11:0 

// if cap SUPPORT_FLEXIBLE_WIN_MAPPING is FALSE, this define can be used to obtain which head a window is mapped to
#define NVC37D_WINDOW_MAPPED_TO_HEAD(w) ((w)>>1)
#define NVC37D_GET_VALID_WINDOWMASK_FOR_HEAD(h) ((1<<((h)*2)) | (1<<((h)*2+1)))

// class methods
#define NVCC7D_PUT                                                              (0x00000000)
#define NVCC7D_PUT_PTR                                                          13:0
#define NVCC7D_GET                                                              (0x00000004)
#define NVCC7D_GET_PTR                                                          13:0
#define NVCC7D_UPDATE                                                           (0x00000200)
#define NVCC7D_UPDATE_SPECIAL_HANDLING                                          21:20
#define NVCC7D_UPDATE_SPECIAL_HANDLING_NONE                                     (0x00000000)
#define NVCC7D_UPDATE_SPECIAL_HANDLING_INTERRUPT_RM                             (0x00000001)
#define NVCC7D_UPDATE_SPECIAL_HANDLING_MODE_SWITCH                              (0x00000002)
#define NVCC7D_UPDATE_SPECIAL_HANDLING_REASON                                   19:12
#define NVCC7D_UPDATE_INHIBIT_INTERRUPTS                                        24:24
#define NVCC7D_UPDATE_INHIBIT_INTERRUPTS_FALSE                                  (0x00000000)
#define NVCC7D_UPDATE_INHIBIT_INTERRUPTS_TRUE                                   (0x00000001)
#define NVCC7D_UPDATE_RELEASE_ELV                                               0:0
#define NVCC7D_UPDATE_RELEASE_ELV_FALSE                                         (0x00000000)
#define NVCC7D_UPDATE_RELEASE_ELV_TRUE                                          (0x00000001)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN                                             8:4
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_NONE                               (0x00000000)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN(i)                                 (0x00000001 +(i))
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN__SIZE_1                            16
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_0                                  (0x00000001)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_1                                  (0x00000002)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_2                                  (0x00000003)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_3                                  (0x00000004)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_4                                  (0x00000005)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_5                                  (0x00000006)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_6                                  (0x00000007)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_7                                  (0x00000008)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_8                                  (0x00000009)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_9                                  (0x0000000A)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_A                                  (0x0000000B)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_B                                  (0x0000000C)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_C                                  (0x0000000D)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_D                                  (0x0000000E)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_E                                  (0x0000000F)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_LOCK_PIN_F                                  (0x00000010)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_0                        (0x00000014)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_1                        (0x00000015)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_2                        (0x00000016)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_FLIP_LOCK_3                        (0x00000017)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK(i)                       (0x00000018 +(i))
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK__SIZE_1                  8
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_0                        (0x00000018)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_1                        (0x00000019)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_2                        (0x0000001A)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_3                        (0x0000001B)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_4                        (0x0000001C)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_5                        (0x0000001D)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_6                        (0x0000001E)
#define NVCC7D_UPDATE_FLIP_LOCK_PIN_INTERNAL_SCAN_LOCK_7                        (0x0000001F)
#define NVCC7D_UPDATE_FORCE_FULLSCREEN                                          28:28
#define NVCC7D_UPDATE_FORCE_FULLSCREEN_FALSE                                    (0x00000000)
#define NVCC7D_UPDATE_FORCE_FULLSCREEN_TRUE                                     (0x00000001)
#define NVCC7D_SET_NOTIFIER_CONTROL                                             (0x0000020C)
#define NVCC7D_SET_NOTIFIER_CONTROL_MODE                                        0:0
#define NVCC7D_SET_NOTIFIER_CONTROL_MODE_WRITE                                  (0x00000000)
#define NVCC7D_SET_NOTIFIER_CONTROL_MODE_WRITE_AWAKEN                           (0x00000001)
#define NVCC7D_SET_NOTIFIER_CONTROL_NOTIFY                                      12:12
#define NVCC7D_SET_NOTIFIER_CONTROL_NOTIFY_DISABLE                              (0x00000000)
#define NVCC7D_SET_NOTIFIER_CONTROL_NOTIFY_ENABLE                               (0x00000001)
#define NVCC7D_SET_CONTROL                                                      (0x00000210)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN(i)                                     ((i)+0):((i)+0)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN__SIZE_1                                4
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN_DISABLE                                (0x00000000)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN_ENABLE                                 (0x00000001)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN0                                       0:0
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN0_DISABLE                               (0x00000000)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN0_ENABLE                                (0x00000001)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN1                                       1:1
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN1_DISABLE                               (0x00000000)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN1_ENABLE                                (0x00000001)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN2                                       2:2
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN2_DISABLE                               (0x00000000)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN2_ENABLE                                (0x00000001)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN3                                       3:3
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN3_DISABLE                               (0x00000000)
#define NVCC7D_SET_CONTROL_FLIP_LOCK_PIN3_ENABLE                                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS                                              (0x00000218)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR(i)                     ((i)+0):((i)+0)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR__SIZE_1                8
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_DISABLE                (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR_ENABLE                 (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0                       0:0
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR0_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1                       1:1
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR1_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2                       2:2
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR2_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3                       3:3
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR3_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4                       4:4
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR4_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5                       5:5
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR5_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6                       6:6
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR6_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7                       7:7
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_DISABLE               (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CURSOR7_ENABLE                (0x00000001)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE                          16:16
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_DISABLE                  (0x00000000)
#define NVCC7D_SET_INTERLOCK_FLAGS_INTERLOCK_WITH_CORE_ENABLE                   (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS                                       (0x0000021C)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW(i)              ((i)+0):((i)+0)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW__SIZE_1         32
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_DISABLE         (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW_ENABLE          (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0                0:0
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW0_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1                1:1
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW1_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2                2:2
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW2_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3                3:3
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW3_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4                4:4
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW4_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5                5:5
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW5_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6                6:6
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW6_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7                7:7
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW7_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8                8:8
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW8_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9                9:9
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_DISABLE        (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW9_ENABLE         (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10               10:10
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW10_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11               11:11
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW11_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12               12:12
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW12_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13               13:13
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW13_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14               14:14
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW14_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15               15:15
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW15_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16               16:16
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW16_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17               17:17
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW17_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18               18:18
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW18_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19               19:19
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW19_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20               20:20
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW20_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21               21:21
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW21_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22               22:22
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW22_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23               23:23
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW23_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24               24:24
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW24_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25               25:25
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW25_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26               26:26
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW26_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27               27:27
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW27_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28               28:28
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW28_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29               29:29
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW29_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30               30:30
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW30_ENABLE        (0x00000001)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31               31:31
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_DISABLE       (0x00000000)
#define NVCC7D_SET_WINDOW_INTERLOCK_FLAGS_INTERLOCK_WITH_WINDOW31_ENABLE        (0x00000001)
#define NVCC7D_GET_RG_SCAN_LINE(b)                                              (0x00000220 + (b)*0x00000004)
#define NVCC7D_GET_RG_SCAN_LINE_LINE                                            15:0
#define NVCC7D_GET_RG_SCAN_LINE_VBLANK                                          16:16
#define NVCC7D_GET_RG_SCAN_LINE_VBLANK_FALSE                                    (0x00000000)
#define NVCC7D_GET_RG_SCAN_LINE_VBLANK_TRUE                                     (0x00000001)
#define NVCC7D_SET_GET_BLANKING_CTRL(b)                                         (0x00000240 + (b)*0x00000004)
#define NVCC7D_SET_GET_BLANKING_CTRL_BLANK                                      0:0
#define NVCC7D_SET_GET_BLANKING_CTRL_BLANK_NO_CHANGE                            (0x00000000)
#define NVCC7D_SET_GET_BLANKING_CTRL_BLANK_ENABLE                               (0x00000001)
#define NVCC7D_SET_GET_BLANKING_CTRL_UNBLANK                                    1:1
#define NVCC7D_SET_GET_BLANKING_CTRL_UNBLANK_NO_CHANGE                          (0x00000000)
#define NVCC7D_SET_GET_BLANKING_CTRL_UNBLANK_ENABLE                             (0x00000001)
#define NVCC7D_SET_SURFACE_ADDRESS_HI_NOTIFIER                                  (0x00000260)
#define NVCC7D_SET_SURFACE_ADDRESS_HI_NOTIFIER_ADDRESS_HI                       31:0
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER                                  (0x00000264)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_ADDRESS_LO                       31:4
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_TARGET                           3:2
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_TARGET_IOVA                      (0x00000000)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_TARGET_PHYSICAL_NVM              (0x00000001)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_TARGET_PHYSICAL_PCI              (0x00000002)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_TARGET_PHYSICAL_PCI_COHERENT     (0x00000003)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_ENABLE                           0:0
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_ENABLE_DISABLE                   (0x00000000)
#define NVCC7D_SET_SURFACE_ADDRESS_LO_NOTIFIER_ENABLE_ENABLE                    (0x00000001)

#define NVCC7D_SOR_SET_CONTROL(a)                                               (0x00000300 + (a)*0x00000020)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK                                       7:0
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_NONE                                  (0x00000000)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD0                                 (0x00000001)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD1                                 (0x00000002)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD2                                 (0x00000004)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD3                                 (0x00000008)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD4                                 (0x00000010)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD5                                 (0x00000020)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD6                                 (0x00000040)
#define NVCC7D_SOR_SET_CONTROL_OWNER_MASK_HEAD7                                 (0x00000080)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL                                         11:8
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_LVDS_CUSTOM                             (0x00000000)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_SINGLE_TMDS_A                           (0x00000001)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_SINGLE_TMDS_B                           (0x00000002)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_DUAL_TMDS                               (0x00000005)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_DP_A                                    (0x00000008)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_DP_B                                    (0x00000009)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_HDMI_FRL                                (0x0000000C)
#define NVCC7D_SOR_SET_CONTROL_PROTOCOL_CUSTOM                                  (0x0000000F)
#define NVCC7D_SOR_SET_CONTROL_DE_SYNC_POLARITY                                 16:16
#define NVCC7D_SOR_SET_CONTROL_DE_SYNC_POLARITY_POSITIVE_TRUE                   (0x00000000)
#define NVCC7D_SOR_SET_CONTROL_DE_SYNC_POLARITY_NEGATIVE_TRUE                   (0x00000001)
#define NVCC7D_SOR_SET_CONTROL_PIXEL_REPLICATE_MODE                             21:20
#define NVCC7D_SOR_SET_CONTROL_PIXEL_REPLICATE_MODE_OFF                         (0x00000000)
#define NVCC7D_SOR_SET_CONTROL_PIXEL_REPLICATE_MODE_X2                          (0x00000001)
#define NVCC7D_SOR_SET_CONTROL_PIXEL_REPLICATE_MODE_X4                          (0x00000002)
#define NVCC7D_SOR_SET_CUSTOM_REASON(a)                                         (0x00000304 + (a)*0x00000020)
#define NVCC7D_SOR_SET_CUSTOM_REASON_CODE                                       31:0
#define NVCC7D_SOR_SET_SW_SPARE_A(a)                                            (0x00000308 + (a)*0x00000020)
#define NVCC7D_SOR_SET_SW_SPARE_A_CODE                                          31:0
#define NVCC7D_SOR_SET_SW_SPARE_B(a)                                            (0x0000030C + (a)*0x00000020)
#define NVCC7D_SOR_SET_SW_SPARE_B_CODE                                          31:0

#define NVCC7D_DSI_SET_CONTROL(a)                                               (0x00000500 + (a)*0x00000020)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK                                       7:0
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_NONE                                  (0x00000000)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD0                                 (0x00000001)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD1                                 (0x00000002)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD2                                 (0x00000004)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD3                                 (0x00000008)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD4                                 (0x00000010)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD5                                 (0x00000020)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD6                                 (0x00000040)
#define NVCC7D_DSI_SET_CONTROL_OWNER_MASK_HEAD7                                 (0x00000080)
#define NVCC7D_DSI_SET_CUSTOM_REASON(a)                                         (0x00000504 + (a)*0x00000020)
#define NVCC7D_DSI_SET_CUSTOM_REASON_CODE                                       31:0
#define NVCC7D_DSI_SET_SW_SPARE_A(a)                                            (0x00000508 + (a)*0x00000020)
#define NVCC7D_DSI_SET_SW_SPARE_A_CODE                                          31:0
#define NVCC7D_DSI_SET_SW_SPARE_B(a)                                            (0x0000050C + (a)*0x00000020)
#define NVCC7D_DSI_SET_SW_SPARE_B_CODE                                          31:0

#define NVCC7D_WINDOW_SET_CONTROL(a)                                            (0x00001000 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER                                         3:0
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD(i)                                 (0x00000000 +(i))
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD__SIZE_1                            8
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD0                                   (0x00000000)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD1                                   (0x00000001)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD2                                   (0x00000002)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD3                                   (0x00000003)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD4                                   (0x00000004)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD5                                   (0x00000005)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD6                                   (0x00000006)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_HEAD7                                   (0x00000007)
#define NVCC7D_WINDOW_SET_CONTROL_OWNER_NONE                                    (0x0000000F)
#define NVCC7D_WINDOW_SET_CONTROL_HIDE                                          8:8
#define NVCC7D_WINDOW_SET_CONTROL_HIDE_FALSE                                    (0x00000000)
#define NVCC7D_WINDOW_SET_CONTROL_HIDE_TRUE                                     (0x00000001)
#define NVCC7D_WINDOW_SET_CONTROL_DISABLE_PHYSICAL_FLIPS                        9:9
#define NVCC7D_WINDOW_SET_CONTROL_DISABLE_PHYSICAL_FLIPS_FALSE                  (0x00000000)
#define NVCC7D_WINDOW_SET_CONTROL_DISABLE_PHYSICAL_FLIPS_TRUE                   (0x00000001)
#define NVCC7D_WINDOW_SET_CONTROL_ALLOW_SUPERFRAME                              10:10
#define NVCC7D_WINDOW_SET_CONTROL_ALLOW_SUPERFRAME_FALSE                        (0x00000000)
#define NVCC7D_WINDOW_SET_CONTROL_ALLOW_SUPERFRAME_TRUE                         (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS(a)                         (0x00001004 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP             0:0
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP_FALSE       (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP_TRUE        (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP             1:1
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP_FALSE       (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP_TRUE        (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP             2:2
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP_FALSE       (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP_TRUE        (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP             3:3
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP_FALSE       (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP_TRUE        (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PACKED422              4:4
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PACKED422_FALSE        (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PACKED422_TRUE         (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR420              5:5
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR420_FALSE        (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR420_TRUE         (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR444              6:6
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR444_FALSE        (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_PLANAR444_TRUE         (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420         7:7
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420_FALSE   (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420_TRUE    (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422         8:8
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422_FALSE   (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422_TRUE    (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R        9:9
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R_FALSE  (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R_TRUE   (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444         10:10
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444_FALSE   (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444_TRUE    (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420          11:11
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420_FALSE    (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420_TRUE     (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444          12:12
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444_FALSE    (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444_TRUE     (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420     13:13
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422     14:14
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R    15:15
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444     16:16
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS(a)                 (0x00001008 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP     0:0
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED1BPP_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP     1:1
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED2BPP_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP     2:2
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED4BPP_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP     3:3
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_RGB_PACKED8BPP_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PACKED422      4:4
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PACKED422_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PACKED422_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR420      5:5
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR420_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR420_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR444      6:6
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR444_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_PLANAR444_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420 7:7
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR420_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422 8:8
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R 9:9
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR422R_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444 10:10
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_YUV_SEMI_PLANAR444_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420  11:11
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR420_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444  12:12
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_PLANAR444_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420 13:13
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR420_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422 14:14
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R 15:15
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR422R_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444 16:16
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444_FALSE (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_ROTATED_FORMAT_USAGE_BOUNDS_EXT_YUV_SEMI_PLANAR444_TRUE (0x00000001)
#define NVCC7D_WINDOW_SET_MAX_INPUT_SCALE_FACTOR(a)                             (0x0000100C + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_MAX_INPUT_SCALE_FACTOR_HORIZONTAL                     15:0
#define NVCC7D_WINDOW_SET_MAX_INPUT_SCALE_FACTOR_VERTICAL                       31:16
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS(a)                                (0x00001010 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_MAX_PIXELS_FETCHED_PER_LINE       14:0
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_ILUT_ALLOWED                      16:16
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_ILUT_ALLOWED_FALSE                (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_ILUT_ALLOWED_TRUE                 (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_TMO_LUT_ALLOWED                   28:28
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_TMO_LUT_ALLOWED_FALSE             (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_TMO_LUT_ALLOWED_TRUE              (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_INPUT_SCALER_TAPS                 22:20
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_INPUT_SCALER_TAPS_TAPS_2          (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_INPUT_SCALER_TAPS_TAPS_5          (0x00000004)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_UPSCALING_ALLOWED                 24:24
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_UPSCALING_ALLOWED_FALSE           (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_UPSCALING_ALLOWED_TRUE            (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_OVERFETCH_ENABLED                 30:30
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_OVERFETCH_ENABLED_FALSE           (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_OVERFETCH_ENABLED_TRUE            (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_LAYOUT                            26:25
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_LAYOUT_PITCH_BLOCKLINEAR          (0x00000000)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_LAYOUT_PITCH                      (0x00000001)
#define NVCC7D_WINDOW_SET_WINDOW_USAGE_BOUNDS_LAYOUT_BLOCKLINEAR                (0x00000002)
#define NVCC7D_WINDOW_SET_PHYSICAL(a)                                           (0x00001014 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW                                       31:0
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_NONE                                  (0x00000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW0                               (0x00000001)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW1                               (0x00000002)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW2                               (0x00000004)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW3                               (0x00000008)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW4                               (0x00000010)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW5                               (0x00000020)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW6                               (0x00000040)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW7                               (0x00000080)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW8                               (0x00000100)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW9                               (0x00000200)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW10                              (0x00000400)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW11                              (0x00000800)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW12                              (0x00001000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW13                              (0x00002000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW14                              (0x00004000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW15                              (0x00008000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW16                              (0x00010000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW17                              (0x00020000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW18                              (0x00040000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW19                              (0x00080000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW20                              (0x00100000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW21                              (0x00200000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW22                              (0x00400000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW23                              (0x00800000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW24                              (0x01000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW25                              (0x02000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW26                              (0x04000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW27                              (0x08000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW28                              (0x10000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW29                              (0x20000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW30                              (0x40000000)
#define NVCC7D_WINDOW_SET_PHYSICAL_WINDOW_WINDOW31                              (0x80000000)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES(a)                                    (0x00001024 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_SIZE_OUT                          0:0
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_SIZE_OUT_FALSE                    (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_SIZE_OUT_TRUE                     (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONTROL               1:1
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONTROL_FALSE         (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONTROL_TRUE          (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONSTANT_ALPHA        2:2
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONSTANT_ALPHA_FALSE  (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_CONSTANT_ALPHA_TRUE   (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_FACTOR_SELECT         3:3
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_FACTOR_SELECT_FALSE   (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_OVERRIDES_SET_COMPOSITION_FACTOR_SELECT_TRUE    (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_SIZE_OUT(a)                                     (0x00001028 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_GUEST_SIZE_OUT_WIDTH                                  15:0
#define NVCC7D_WINDOW_SET_GUEST_SIZE_OUT_HEIGHT                                 31:16
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL(a)                          (0x0000102C + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_COLOR_KEY_SELECT            1:0
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DISABLE    (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_COLOR_KEY_SELECT_SRC        (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_COLOR_KEY_SELECT_DST        (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_DEPTH                       11:4
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_BYPASS                      16:16
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_BYPASS_DISABLE              (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONTROL_BYPASS_ENABLE               (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONSTANT_ALPHA(a)                   (0x00001030 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONSTANT_ALPHA_K1                   7:0
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_CONSTANT_ALPHA_K2                   15:8
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT(a)                    (0x00001034 + (a)*0x00000080)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT 3:0
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT 7:4
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_SRC (0x00000005)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT 11:8
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT 15:12
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1 (0x00000004)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_K1_TIMES_DST (0x00000006)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_COLOR_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT 19:16
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT 23:20
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K1 (0x00000002)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_SRC_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_DST (0x00000008)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT 27:24
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT 31:28
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ZERO (0x00000000)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_ONE (0x00000001)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_K2 (0x00000003)
#define NVCC7D_WINDOW_SET_GUEST_COMPOSITION_FACTOR_SELECT_DST_ALPHA_FACTOR_NO_MATCH_SELECT_NEG_K1_TIMES_SRC (0x00000007)

#define NVCC7D_HEAD_SET_PROCAMP(a)                                              (0x00002000 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PROCAMP_COLOR_SPACE                                     1:0
#define NVCC7D_HEAD_SET_PROCAMP_COLOR_SPACE_RGB                                 (0x00000000)
#define NVCC7D_HEAD_SET_PROCAMP_COLOR_SPACE_YUV_601                             (0x00000001)
#define NVCC7D_HEAD_SET_PROCAMP_COLOR_SPACE_YUV_709                             (0x00000002)
#define NVCC7D_HEAD_SET_PROCAMP_COLOR_SPACE_YUV_2020                            (0x00000003)
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_LPF                                      3:3
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_LPF_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_LPF_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_DOWN_V                                   4:4
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_DOWN_V_DISABLE                           (0x00000000)
#define NVCC7D_HEAD_SET_PROCAMP_CHROMA_DOWN_V_ENABLE                            (0x00000001)
#define NVCC7D_HEAD_SET_PROCAMP_DYNAMIC_RANGE                                   28:28
#define NVCC7D_HEAD_SET_PROCAMP_DYNAMIC_RANGE_VESA                              (0x00000000)
#define NVCC7D_HEAD_SET_PROCAMP_DYNAMIC_RANGE_CEA                               (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE(a)                              (0x00002004 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_CRC_MODE                        1:0
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_CRC_MODE_ACTIVE_RASTER          (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_CRC_MODE_COMPLETE_RASTER        (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_CRC_MODE_NON_ACTIVE_RASTER      (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_HSYNC_POLARITY                  2:2
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_HSYNC_POLARITY_POSITIVE_TRUE    (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_HSYNC_POLARITY_NEGATIVE_TRUE    (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_VSYNC_POLARITY                  3:3
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_VSYNC_POLARITY_POSITIVE_TRUE    (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_VSYNC_POLARITY_NEGATIVE_TRUE    (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH                     7:4
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_16_422          (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_18_444          (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_20_422          (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_24_422          (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_24_444          (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_30_444          (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_32_422          (0x00000006)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_36_444          (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_48_444          (0x00000008)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_16_444          (0x00000009)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_PIXEL_DEPTH_BPP_18_444NP        (0x0000000A)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_COLOR_SPACE_OVERRIDE            24:24
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_COLOR_SPACE_OVERRIDE_DISABLE    (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_COLOR_SPACE_OVERRIDE_ENABLE     (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_COLOR_SPACE_FLAG                23:12
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN                  31:26
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN0             (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN1             (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN2             (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN3             (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN4             (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN5             (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN6             (0x00000006)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN7             (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN8             (0x00000008)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN9             (0x00000009)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN10            (0x0000000A)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN11            (0x0000000B)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN12            (0x0000000C)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN13            (0x0000000D)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN14            (0x0000000E)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN15            (0x0000000F)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN16            (0x00000010)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN17            (0x00000011)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN18            (0x00000012)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN19            (0x00000013)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN20            (0x00000014)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN21            (0x00000015)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN22            (0x00000016)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN23            (0x00000017)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN24            (0x00000018)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN25            (0x00000019)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN26            (0x0000001A)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN27            (0x0000001B)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN28            (0x0000001C)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN29            (0x0000001D)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN30            (0x0000001E)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_WIN31            (0x0000001F)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_RESOURCE_EXT_PACKET_WIN_NONE             (0x0000003F)
#define NVCC7D_HEAD_SET_CONTROL(a)                                              (0x00002008 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CONTROL_STRUCTURE                                       1:0
#define NVCC7D_HEAD_SET_CONTROL_STRUCTURE_PROGRESSIVE                           (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_STEREO3D_STRUCTURE                              2:2
#define NVCC7D_HEAD_SET_CONTROL_STEREO3D_STRUCTURE_NORMAL                       (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_STEREO3D_STRUCTURE_FRAME_PACKED                 (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_YUV420PACKER                                    3:3
#define NVCC7D_HEAD_SET_CONTROL_YUV420PACKER_DISABLE                            (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_YUV420PACKER_ENABLE                             (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_MODE                                  11:10
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_MODE_NO_LOCK                          (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_MODE_FRAME_LOCK                       (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_MODE_RASTER_LOCK                      (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN                                   8:4
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_NONE                     (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN(i)                       (0x00000001 +(i))
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN__SIZE_1                  16
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_0                        (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_1                        (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_2                        (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_3                        (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_4                        (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_5                        (0x00000006)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_6                        (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_7                        (0x00000008)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_8                        (0x00000009)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_9                        (0x0000000A)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_A                        (0x0000000B)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_B                        (0x0000000C)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_C                        (0x0000000D)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_D                        (0x0000000E)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_E                        (0x0000000F)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_LOCK_PIN_F                        (0x00000010)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_FLIP_LOCK_0              (0x00000014)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_FLIP_LOCK_1              (0x00000015)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_FLIP_LOCK_2              (0x00000016)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_FLIP_LOCK_3              (0x00000017)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK(i)             (0x00000018 +(i))
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK__SIZE_1        8
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_0              (0x00000018)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_1              (0x00000019)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_2              (0x0000001A)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_3              (0x0000001B)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_4              (0x0000001C)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_5              (0x0000001D)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_6              (0x0000001E)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCK_PIN_INTERNAL_SCAN_LOCK_7              (0x0000001F)
#define NVCC7D_HEAD_SET_CONTROL_SINK_LOCKOUT_WINDOW                             15:12
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_MODE                                23:22
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_MODE_NO_LOCK                        (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_MODE_FRAME_LOCK                     (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_MODE_RASTER_LOCK                    (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN                                 20:16
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_NONE                   (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN(i)                     (0x00000001 +(i))
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN__SIZE_1                16
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_0                      (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_1                      (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_2                      (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_3                      (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_4                      (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_5                      (0x00000006)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_6                      (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_7                      (0x00000008)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_8                      (0x00000009)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_9                      (0x0000000A)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_A                      (0x0000000B)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_B                      (0x0000000C)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_C                      (0x0000000D)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_D                      (0x0000000E)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_E                      (0x0000000F)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_LOCK_PIN_F                      (0x00000010)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_FLIP_LOCK_0            (0x00000014)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_FLIP_LOCK_1            (0x00000015)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_FLIP_LOCK_2            (0x00000016)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_FLIP_LOCK_3            (0x00000017)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK(i)           (0x00000018 +(i))
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK__SIZE_1      8
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_0            (0x00000018)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_1            (0x00000019)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_2            (0x0000001A)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_3            (0x0000001B)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_4            (0x0000001C)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_5            (0x0000001D)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_6            (0x0000001E)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_LOCK_PIN_INTERNAL_SCAN_LOCK_7            (0x0000001F)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN                                      28:24
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_NONE                        (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN(i)                          (0x00000001 +(i))
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN__SIZE_1                     16
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_0                           (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_1                           (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_2                           (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_3                           (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_4                           (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_5                           (0x00000006)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_6                           (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_7                           (0x00000008)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_8                           (0x00000009)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_9                           (0x0000000A)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_A                           (0x0000000B)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_B                           (0x0000000C)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_C                           (0x0000000D)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_D                           (0x0000000E)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_E                           (0x0000000F)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_LOCK_PIN_F                           (0x00000010)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_FLIP_LOCK_0                 (0x00000014)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_FLIP_LOCK_1                 (0x00000015)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_FLIP_LOCK_2                 (0x00000016)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_FLIP_LOCK_3                 (0x00000017)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK(i)                (0x00000018 +(i))
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK__SIZE_1           8
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_0                 (0x00000018)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_1                 (0x00000019)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_2                 (0x0000001A)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_3                 (0x0000001B)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_4                 (0x0000001C)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_5                 (0x0000001D)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_6                 (0x0000001E)
#define NVCC7D_HEAD_SET_CONTROL_STEREO_PIN_INTERNAL_SCAN_LOCK_7                 (0x0000001F)
#define NVCC7D_HEAD_SET_CONTROL_SINK_STEREO_LOCK_MODE                           30:30
#define NVCC7D_HEAD_SET_CONTROL_SINK_STEREO_LOCK_MODE_DISABLE                   (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SINK_STEREO_LOCK_MODE_ENABLE                    (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_STEREO_LOCK_MODE                         31:31
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_STEREO_LOCK_MODE_DISABLE                 (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_SOURCE_STEREO_LOCK_MODE_ENABLE                  (0x00000001)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY(a)                                (0x0000200C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_HERTZ                             30:0
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_ADJ1000DIV1001                    31:31
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_ADJ1000DIV1001_FALSE              (0x00000000)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_ADJ1000DIV1001_TRUE               (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER(a)                                (0x00002014 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_VERTICAL_TAPS                     2:0
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_VERTICAL_TAPS_TAPS_2              (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_VERTICAL_TAPS_TAPS_5              (0x00000004)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_HORIZONTAL_TAPS                   6:4
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_HORIZONTAL_TAPS_TAPS_2            (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_OUTPUT_SCALER_HORIZONTAL_TAPS_TAPS_5            (0x00000004)
#define NVCC7D_HEAD_SET_DITHER_CONTROL(a)                                       (0x00002018 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_ENABLE                                   0:0
#define NVCC7D_HEAD_SET_DITHER_CONTROL_ENABLE_DISABLE                           (0x00000000)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_ENABLE_ENABLE                            (0x00000001)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_BITS                                     5:4
#define NVCC7D_HEAD_SET_DITHER_CONTROL_BITS_TO_6_BITS                           (0x00000000)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_BITS_TO_8_BITS                           (0x00000001)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_BITS_TO_10_BITS                          (0x00000002)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_BITS_TO_12_BITS                          (0x00000003)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_OFFSET_ENABLE                            2:2
#define NVCC7D_HEAD_SET_DITHER_CONTROL_OFFSET_ENABLE_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_OFFSET_ENABLE_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE                                     10:8
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_DYNAMIC_ERR_ACC                     (0x00000000)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_STATIC_ERR_ACC                      (0x00000001)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_DYNAMIC_2X2                         (0x00000002)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_STATIC_2X2                          (0x00000003)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_TEMPORAL                            (0x00000004)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_MODE_ROUND                               (0x00000005)
#define NVCC7D_HEAD_SET_DITHER_CONTROL_PHASE                                    13:12
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION(a)                            (0x0000201C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_NOT_DRIVER                    0:0
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_NOT_DRIVER_FALSE              (0x00000000)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_NOT_DRIVER_TRUE               (0x00000001)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING                       4:4
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING_DISABLE               (0x00000000)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING_ENABLE                (0x00000001)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING_MODE                  9:8
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING_MODE_VBLANK           (0x00000000)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_CONFIGURATION_HOPPING_MODE_HBLANK           (0x00000001)
#define NVCC7D_HEAD_SET_DISPLAY_ID(a,b)                                         (0x00002020 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_DISPLAY_ID_CODE                                         31:0
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_MAX(a)                            (0x00002028 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_MAX_HERTZ                         30:0
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_MAX_ADJ1000DIV1001                31:31
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_MAX_ADJ1000DIV1001_FALSE          (0x00000000)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_MAX_ADJ1000DIV1001_TRUE           (0x00000001)
#define NVCC7D_HEAD_SET_MAX_OUTPUT_SCALE_FACTOR(a)                              (0x0000202C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_MAX_OUTPUT_SCALE_FACTOR_HORIZONTAL                      15:0
#define NVCC7D_HEAD_SET_MAX_OUTPUT_SCALE_FACTOR_VERTICAL                        31:16
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS(a)                                    (0x00002030 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR                                2:0
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR_USAGE_NONE                     (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR_USAGE_W32_H32                  (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR_USAGE_W64_H64                  (0x00000002)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR_USAGE_W128_H128                (0x00000003)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_CURSOR_USAGE_W256_H256                (0x00000004)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OLUT_ALLOWED                          4:4
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OLUT_ALLOWED_FALSE                    (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OLUT_ALLOWED_TRUE                     (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_LTM_ALLOWED                           5:5
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_LTM_ALLOWED_FALSE                     (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_LTM_ALLOWED_TRUE                      (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OUTPUT_SCALER_TAPS                    14:12
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OUTPUT_SCALER_TAPS_TAPS_2             (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OUTPUT_SCALER_TAPS_TAPS_5             (0x00000004)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_UPSCALING_ALLOWED                     8:8
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_UPSCALING_ALLOWED_FALSE               (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_UPSCALING_ALLOWED_TRUE                (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OVERFETCH_ENABLED                     16:16
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OVERFETCH_ENABLED_FALSE               (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_OVERFETCH_ENABLED_TRUE                (0x00000001)
#define NVCC7D_HEAD_SET_HEAD_USAGE_BOUNDS_ELV_START                             31:17
#define NVCC7D_HEAD_SET_STALL_LOCK(a)                                           (0x00002034 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_STALL_LOCK_ENABLE                                       0:0
#define NVCC7D_HEAD_SET_STALL_LOCK_ENABLE_FALSE                                 (0x00000000)
#define NVCC7D_HEAD_SET_STALL_LOCK_ENABLE_TRUE                                  (0x00000001)
#define NVCC7D_HEAD_SET_STALL_LOCK_MODE                                         2:2
#define NVCC7D_HEAD_SET_STALL_LOCK_MODE_CONTINUOUS                              (0x00000000)
#define NVCC7D_HEAD_SET_STALL_LOCK_MODE_ONE_SHOT                                (0x00000001)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN                                     8:4
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_NONE                       (0x00000000)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN(i)                         (0x00000001 +(i))
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN__SIZE_1                    16
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_0                          (0x00000001)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_1                          (0x00000002)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_2                          (0x00000003)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_3                          (0x00000004)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_4                          (0x00000005)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_5                          (0x00000006)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_6                          (0x00000007)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_7                          (0x00000008)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_8                          (0x00000009)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_9                          (0x0000000A)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_A                          (0x0000000B)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_B                          (0x0000000C)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_C                          (0x0000000D)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_D                          (0x0000000E)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_E                          (0x0000000F)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_LOCK_PIN_F                          (0x00000010)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_FLIP_LOCK_0                (0x00000014)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_FLIP_LOCK_1                (0x00000015)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_FLIP_LOCK_2                (0x00000016)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_FLIP_LOCK_3                (0x00000017)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK(i)               (0x00000018 +(i))
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK__SIZE_1          8
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_0                (0x00000018)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_1                (0x00000019)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_2                (0x0000001A)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_3                (0x0000001B)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_4                (0x0000001C)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_5                (0x0000001D)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_6                (0x0000001E)
#define NVCC7D_HEAD_SET_STALL_LOCK_LOCK_PIN_INTERNAL_SCAN_LOCK_7                (0x0000001F)
#define NVCC7D_HEAD_SET_STALL_LOCK_UNSTALL_MODE                                 12:12
#define NVCC7D_HEAD_SET_STALL_LOCK_UNSTALL_MODE_CRASH_LOCK                      (0x00000000)
#define NVCC7D_HEAD_SET_STALL_LOCK_UNSTALL_MODE_LINE_LOCK                       (0x00000001)
#define NVCC7D_HEAD_SET_STALL_LOCK_TEPOLARITY                                   14:14
#define NVCC7D_HEAD_SET_STALL_LOCK_TEPOLARITY_POSITIVE_TRUE                     (0x00000000)
#define NVCC7D_HEAD_SET_STALL_LOCK_TEPOLARITY_NEGATIVE_TRUE                     (0x00000001)
#define NVCC7D_HEAD_SET_STALL_LOCK_UNSTALL_SYNC_ADVANCE                         25:16
#define NVCC7D_HEAD_SET_LOCK_CHAIN(a)                                           (0x00002044 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LOCK_CHAIN_POSITION                                     3:0
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_IN(a)                                    (0x00002048 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_IN_X                                     14:0
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_IN_Y                                     30:16
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_IN(a)                                     (0x0000204C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_IN_WIDTH                                  14:0
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_IN_HEIGHT                                 30:16
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_OUT(a)                                    (0x00002058 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_OUT_WIDTH                                 14:0
#define NVCC7D_HEAD_SET_VIEWPORT_SIZE_OUT_HEIGHT                                30:16
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_OUT_ADJUST(a)                            (0x0000205C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_OUT_ADJUST_X                             15:0
#define NVCC7D_HEAD_SET_VIEWPORT_POINT_OUT_ADJUST_Y                             31:16
#define NVCC7D_HEAD_SET_TILE_MASK(a)                                            (0x00002060 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE                                          7:0
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_NONE                                     (0x00000000)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE0                                    (0x00000001)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE1                                    (0x00000002)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE2                                    (0x00000004)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE3                                    (0x00000008)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE4                                    (0x00000010)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE5                                    (0x00000020)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE6                                    (0x00000040)
#define NVCC7D_HEAD_SET_TILE_MASK_TILE_TILE7                                    (0x00000080)
#define NVCC7D_HEAD_SET_RASTER_SIZE(a)                                          (0x00002064 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_SIZE_WIDTH                                       15:0
#define NVCC7D_HEAD_SET_RASTER_SIZE_HEIGHT                                      31:16
#define NVCC7D_HEAD_SET_RASTER_SYNC_END(a)                                      (0x00002068 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_SYNC_END_X                                       14:0
#define NVCC7D_HEAD_SET_RASTER_SYNC_END_Y                                       30:16
#define NVCC7D_HEAD_SET_RASTER_BLANK_END(a)                                     (0x0000206C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_BLANK_END_X                                      14:0
#define NVCC7D_HEAD_SET_RASTER_BLANK_END_Y                                      30:16
#define NVCC7D_HEAD_SET_RASTER_BLANK_START(a)                                   (0x00002070 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_BLANK_START_X                                    14:0
#define NVCC7D_HEAD_SET_RASTER_BLANK_START_Y                                    30:16
#define NVCC7D_HEAD_SET_OVERSCAN_COLOR(a)                                       (0x00002078 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OVERSCAN_COLOR_RED_CR                                   9:0
#define NVCC7D_HEAD_SET_OVERSCAN_COLOR_GREEN_Y                                  19:10
#define NVCC7D_HEAD_SET_OVERSCAN_COLOR_BLUE_CB                                  29:20
#define NVCC7D_HEAD_SET_FRAME_PACKED_VACTIVE_COLOR(a)                           (0x0000207C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_FRAME_PACKED_VACTIVE_COLOR_RED_CR                       9:0
#define NVCC7D_HEAD_SET_FRAME_PACKED_VACTIVE_COLOR_GREEN_Y                      19:10
#define NVCC7D_HEAD_SET_FRAME_PACKED_VACTIVE_COLOR_BLUE_CB                      29:20
#define NVCC7D_HEAD_SET_HDMI_CTRL(a)                                            (0x00002080 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HDMI_CTRL_VIDEO_FORMAT                                  2:0
#define NVCC7D_HEAD_SET_HDMI_CTRL_VIDEO_FORMAT_NORMAL                           (0x00000000)
#define NVCC7D_HEAD_SET_HDMI_CTRL_VIDEO_FORMAT_EXTENDED                         (0x00000001)
#define NVCC7D_HEAD_SET_HDMI_CTRL_VIDEO_FORMAT_STEREO3D                         (0x00000002)
#define NVCC7D_HEAD_SET_HDMI_CTRL_HDMI_VIC                                      11:4
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_CURSOR(a)                               (0x00002098 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_CURSOR_MODE                             0:0
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_CURSOR_MODE_MONO                        (0x00000000)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_CURSOR_MODE_STEREO                      (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR(a)                                       (0x0000209C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_ENABLE                                   31:31
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_ENABLE_DISABLE                           (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_ENABLE_ENABLE                            (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_FORMAT                                   7:0
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_FORMAT_A1R5G5B5                          (0x000000E9)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_FORMAT_A8R8G8B8                          (0x000000CF)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_SIZE                                     9:8
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_SIZE_W32_H32                             (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_SIZE_W64_H64                             (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_SIZE_W128_H128                           (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_SIZE_W256_H256                           (0x00000003)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_HOT_SPOT_X                               19:12
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_HOT_SPOT_Y                               27:20
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION(a)                           (0x000020A0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_K1                           7:0
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_CURSOR_COLOR_FACTOR_SELECT   11:8
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_CURSOR_COLOR_FACTOR_SELECT_K1 (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_CURSOR_COLOR_FACTOR_SELECT_K1_TIMES_SRC (0x00000005)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_VIEWPORT_COLOR_FACTOR_SELECT 15:12
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_VIEWPORT_COLOR_FACTOR_SELECT_ZERO (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_VIEWPORT_COLOR_FACTOR_SELECT_K1 (0x00000002)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_VIEWPORT_COLOR_FACTOR_SELECT_NEG_K1_TIMES_SRC (0x00000007)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_MODE                         16:16
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_MODE_BLEND                   (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_MODE_XOR                     (0x00000001)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_BYPASS                       20:20
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_BYPASS_DISABLE               (0x00000000)
#define NVCC7D_HEAD_SET_CONTROL_CURSOR_COMPOSITION_BYPASS_ENABLE                (0x00000001)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL(a)                                      (0x000020A4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_ENABLE                                  0:0
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_ENABLE_DISABLE                          (0x00000000)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_ENABLE_ENABLE                           (0x00000001)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_INTERPOLATE                             1:1
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_INTERPOLATE_DISABLE                     (0x00000000)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_INTERPOLATE_ENABLE                      (0x00000001)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_MIRROR                                  2:2
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_MIRROR_DISABLE                          (0x00000000)
#define NVCC7D_HEAD_SET_CMI_LUT_CONTROL_MIRROR_ENABLE                           (0x00000001)
#define NVCC7D_HEAD_SET_CMI_FP_NORM_SCALE(a)                                    (0x000020A8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CMI_FP_NORM_SCALE_FPNORM                                31:0
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL(a)                                      (0x000020AC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_ENABLE                                  0:0
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_ENABLE_DISABLE                          (0x00000000)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_ENABLE_ENABLE                           (0x00000001)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_INTERPOLATE                             1:1
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_INTERPOLATE_DISABLE                     (0x00000000)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_INTERPOLATE_ENABLE                      (0x00000001)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_MIRROR                                  2:2
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_MIRROR_DISABLE                          (0x00000000)
#define NVCC7D_HEAD_SET_CMO_LUT_CONTROL_MIRROR_ENABLE                           (0x00000001)
#define NVCC7D_HEAD_SET_CM3D0CONTROL(a)                                         (0x000020B8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_MODE                                       0:0
#define NVCC7D_HEAD_SET_CM3D0CONTROL_MODE_GAMUT_MAPPING                         (0x00000000)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_MODE_PANEL_CORR                            (0x00000001)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_ROUND                                      1:1
#define NVCC7D_HEAD_SET_CM3D0CONTROL_ROUND_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_ROUND_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_LAST_ENTRY_ADD1                            2:2
#define NVCC7D_HEAD_SET_CM3D0CONTROL_LAST_ENTRY_ADD1_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_LAST_ENTRY_ADD1_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_SIZE                                       3:3
#define NVCC7D_HEAD_SET_CM3D0CONTROL_SIZE_SIZE_9X9X9                            (0x00000000)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_SIZE_SIZE_17X17X17                         (0x00000001)
#define NVCC7D_HEAD_SET_CM3D0CONTROL_RANGE_SCALE                                8:6
#define NVCC7D_HEAD_SET_CM3D0CONTROL_CONTENT_OFFSET                             22:9
#define NVCC7D_HEAD_SET_CM3D1CONTROL(a)                                         (0x000020BC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_MODE                                       0:0
#define NVCC7D_HEAD_SET_CM3D1CONTROL_MODE_GAMUT_MAPPING                         (0x00000000)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_MODE_PANEL_CORR                            (0x00000001)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_ROUND                                      1:1
#define NVCC7D_HEAD_SET_CM3D1CONTROL_ROUND_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_ROUND_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_LAST_ENTRY_ADD1                            2:2
#define NVCC7D_HEAD_SET_CM3D1CONTROL_LAST_ENTRY_ADD1_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_LAST_ENTRY_ADD1_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_SIZE                                       3:3
#define NVCC7D_HEAD_SET_CM3D1CONTROL_SIZE_SIZE_9X9X9                            (0x00000000)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_SIZE_SIZE_17X17X17                         (0x00000001)
#define NVCC7D_HEAD_SET_CM3D1CONTROL_RANGE_SCALE                                8:6
#define NVCC7D_HEAD_SET_CM3D1CONTROL_CONTENT_OFFSET                             22:9
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_HI(a)                             (0x000020C0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_HI_HERTZ                          3:0
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_HI_MAX(a)                         (0x000020C4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PIXEL_CLOCK_FREQUENCY_HI_MAX_HERTZ                      3:0
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE(a,b)                                 (0x000020C8 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW                               15:10
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN0                          (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN1                          (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN2                          (0x00000002)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN3                          (0x00000003)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN4                          (0x00000004)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN5                          (0x00000005)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN6                          (0x00000006)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN7                          (0x00000007)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN8                          (0x00000008)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN9                          (0x00000009)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN10                         (0x0000000A)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN11                         (0x0000000B)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN12                         (0x0000000C)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN13                         (0x0000000D)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN14                         (0x0000000E)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN15                         (0x0000000F)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN16                         (0x00000010)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN17                         (0x00000011)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN18                         (0x00000012)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN19                         (0x00000013)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN20                         (0x00000014)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN21                         (0x00000015)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN22                         (0x00000016)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN23                         (0x00000017)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN24                         (0x00000018)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN25                         (0x00000019)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN26                         (0x0000001A)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN27                         (0x0000001B)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN28                         (0x0000001C)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN29                         (0x0000001D)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN30                         (0x0000001E)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_WIN31                         (0x0000001F)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_WINDOW_NONE                          (0x0000003F)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_INDEX                                1:1
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_ENABLE                               0:0
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_ENABLE_DISABLE                       (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_ENABLE_ENABLE                        (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_OVERRIDE                    2:2
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_OVERRIDE_DISABLE            (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_OVERRIDE_ENABLE             (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION                             9:8
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_VBLANK                      (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_VSYNC                       (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LOCATION_LINE                        (0x00000002)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LINE_ID                              30:16
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LINE_ID_REVERSED                     31:31
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LINE_ID_REVERSED_DISABLE             (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_LINE_ID_REVERSED_ENABLE              (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB0OVERRIDE                          4:4
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB0OVERRIDE_DISABLE                  (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB0OVERRIDE_ENABLE                   (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB1OVERRIDE                          5:5
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB1OVERRIDE_DISABLE                  (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB1OVERRIDE_ENABLE                   (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB2OVERRIDE                          6:6
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB2OVERRIDE_DISABLE                  (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB2OVERRIDE_ENABLE                   (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB3OVERRIDE                          7:7
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB3OVERRIDE_DISABLE                  (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_OVERRIDE_HB3OVERRIDE_ENABLE                   (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_OVERRIDE(a,b)                          (0x000020D0 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_OVERRIDE_HB0                           7:0
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_OVERRIDE_HB1                           15:8
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_OVERRIDE_HB2                           23:16
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_OVERRIDE_HB3                           31:24
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_RG_REL_SEMAPHORE(a,b)                (0x00002110 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_RG_REL_SEMAPHORE_ADDRESS_HI          31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE(a,b)                (0x00002130 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_ADDRESS_LO          31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_TARGET              3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_TARGET_IOVA         (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_TARGET_PHYSICAL_NVM (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_TARGET_PHYSICAL_PCI (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_TARGET_PHYSICAL_PCI_COHERENT (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_ENABLE              0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_ENABLE_DISABLE      (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_RG_REL_SEMAPHORE_ENABLE_ENABLE       (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CRC(a)                               (0x00002150 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CRC_ADDRESS_HI                       31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC(a)                               (0x00002154 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_ADDRESS_LO                       31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_TARGET                           3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_TARGET_IOVA                      (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_TARGET_PHYSICAL_NVM              (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_TARGET_PHYSICAL_PCI              (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_TARGET_PHYSICAL_PCI_COHERENT     (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_ENABLE                           0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_ENABLE_DISABLE                   (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CRC_ENABLE_ENABLE                    (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_OLUT(a)                              (0x00002158 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_OLUT_ADDRESS_HI                      31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT(a)                              (0x0000215C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_ADDRESS_LO                      31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_TARGET                          3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_TARGET_IOVA                     (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_TARGET_PHYSICAL_NVM             (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_TARGET_PHYSICAL_PCI             (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_TARGET_PHYSICAL_PCI_COHERENT    (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_ENABLE                          0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_ENABLE_DISABLE                  (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_OLUT_ENABLE_ENABLE                   (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CM3D0(a)                             (0x00002160 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CM3D0_ADDRESS_HI                     31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0(a)                             (0x00002164 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_ADDRESS_LO                     31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_TARGET                         3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_TARGET_IOVA                    (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_TARGET_PHYSICAL_NVM            (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_TARGET_PHYSICAL_PCI            (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_TARGET_PHYSICAL_PCI_COHERENT   (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_ENABLE                         0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_ENABLE_DISABLE                 (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D0_ENABLE_ENABLE                  (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CM3D1(a)                             (0x00002168 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CM3D1_ADDRESS_HI                     31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1(a)                             (0x0000216C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_ADDRESS_LO                     31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_TARGET                         3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_TARGET_IOVA                    (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_TARGET_PHYSICAL_NVM            (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_TARGET_PHYSICAL_PCI            (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_TARGET_PHYSICAL_PCI_COHERENT   (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_ENABLE                         0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_ENABLE_DISABLE                 (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CM3D1_ENABLE_ENABLE                  (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CURSOR(a,b)                          (0x00002170 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_HI_CURSOR_ADDRESS_HI                    31:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR(a,b)                          (0x00002178 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_ADDRESS_LO                    31:4
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_TARGET                        3:2
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_TARGET_IOVA                   (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_TARGET_PHYSICAL_NVM           (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_TARGET_PHYSICAL_PCI           (0x00000002)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_TARGET_PHYSICAL_PCI_COHERENT  (0x00000003)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_KIND                          1:1
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_KIND_PITCH                    (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_KIND_BLOCKLINEAR              (0x00000001)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_ENABLE                        0:0
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_ENABLE_DISABLE                (0x00000000)
#define NVCC7D_HEAD_SET_SURFACE_ADDRESS_LO_CURSOR_ENABLE_ENABLE                 (0x00000001)
#define NVCC7D_HEAD_SET_CRC_CONTROL(a)                                          (0x00002184 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL                         5:0
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_0                   (0x00000000)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_1                   (0x00000001)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_2                   (0x00000002)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_3                   (0x00000003)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_4                   (0x00000004)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_5                   (0x00000005)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_6                   (0x00000006)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_7                   (0x00000007)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_8                   (0x00000008)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_9                   (0x00000009)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_10                  (0x0000000A)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_11                  (0x0000000B)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_12                  (0x0000000C)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_13                  (0x0000000D)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_14                  (0x0000000E)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_15                  (0x0000000F)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_16                  (0x00000010)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_17                  (0x00000011)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_18                  (0x00000012)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_19                  (0x00000013)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_20                  (0x00000014)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_21                  (0x00000015)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_22                  (0x00000016)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_23                  (0x00000017)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_24                  (0x00000018)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_25                  (0x00000019)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_26                  (0x0000001A)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_27                  (0x0000001B)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_28                  (0x0000001C)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_29                  (0x0000001D)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_30                  (0x0000001E)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_WIN_31                  (0x0000001F)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CONTROLLING_CHANNEL_CORE                    (0x00000020)
#define NVCC7D_HEAD_SET_CRC_CONTROL_EXPECT_BUFFER_COLLAPSE                      8:8
#define NVCC7D_HEAD_SET_CRC_CONTROL_EXPECT_BUFFER_COLLAPSE_FALSE                (0x00000000)
#define NVCC7D_HEAD_SET_CRC_CONTROL_EXPECT_BUFFER_COLLAPSE_TRUE                 (0x00000001)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC                                 19:12
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_NONE                            (0x00000000)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SF                              (0x00000030)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR(i)                          (0x00000050 +(i))
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR__SIZE_1                     8
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR0                            (0x00000050)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR1                            (0x00000051)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR2                            (0x00000052)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR3                            (0x00000053)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR4                            (0x00000054)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR5                            (0x00000055)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR6                            (0x00000056)
#define NVCC7D_HEAD_SET_CRC_CONTROL_PRIMARY_CRC_SOR7                            (0x00000057)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC                               27:20
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_NONE                          (0x00000000)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SF                            (0x00000030)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR(i)                        (0x00000050 +(i))
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR__SIZE_1                   8
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR0                          (0x00000050)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR1                          (0x00000051)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR2                          (0x00000052)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR3                          (0x00000053)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR4                          (0x00000054)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR5                          (0x00000055)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR6                          (0x00000056)
#define NVCC7D_HEAD_SET_CRC_CONTROL_SECONDARY_CRC_SOR7                          (0x00000057)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CRC_DURING_SNOOZE                           9:9
#define NVCC7D_HEAD_SET_CRC_CONTROL_CRC_DURING_SNOOZE_DISABLE                   (0x00000000)
#define NVCC7D_HEAD_SET_CRC_CONTROL_CRC_DURING_SNOOZE_ENABLE                    (0x00000001)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL(a)                                      (0x0000218C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_USE_BEGIN_FIELD                         0:0
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_USE_BEGIN_FIELD_DISABLE                 (0x00000000)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_USE_BEGIN_FIELD_ENABLE                  (0x00000001)
#define NVCC7D_HEAD_SET_PRESENT_CONTROL_BEGIN_FIELD                             6:4
#define NVCC7D_HEAD_SET_SW_SPARE_A(a)                                           (0x00002194 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SW_SPARE_A_CODE                                         31:0
#define NVCC7D_HEAD_SET_SW_SPARE_B(a)                                           (0x00002198 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SW_SPARE_B_CODE                                         31:0
#define NVCC7D_HEAD_SET_SW_SPARE_C(a)                                           (0x0000219C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SW_SPARE_C_CODE                                         31:0
#define NVCC7D_HEAD_SET_SW_SPARE_D(a)                                           (0x000021A0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SW_SPARE_D_CODE                                         31:0
#define NVCC7D_HEAD_SET_DISPLAY_RATE(a)                                         (0x000021A8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DISPLAY_RATE_RUN_MODE                                   1:0
#define NVCC7D_HEAD_SET_DISPLAY_RATE_RUN_MODE_CONTINUOUS                        (0x00000000)
#define NVCC7D_HEAD_SET_DISPLAY_RATE_RUN_MODE_ONE_SHOT                          (0x00000001)
#define NVCC7D_HEAD_SET_DISPLAY_RATE_RUN_MODE_ONE_SHOT_SELF_REFRESH             (0x00000002)
#define NVCC7D_HEAD_SET_DISPLAY_RATE_MIN_REFRESH_INTERVAL                       25:4
#define NVCC7D_HEAD_SET_DISPLAY_RATE_MIN_REFRESH                                2:2
#define NVCC7D_HEAD_SET_DISPLAY_RATE_MIN_REFRESH_DISABLE                        (0x00000000)
#define NVCC7D_HEAD_SET_DISPLAY_RATE_MIN_REFRESH_ENABLE                         (0x00000001)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL(a,b)                           (0x000021CC + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_PAYLOAD_SIZE                   15:15
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_32BIT     (0x00000000)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_PAYLOAD_SIZE_PAYLOAD_64BIT     (0x00000001)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_REL_MODE                       14:14
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_REL_MODE_WRITE                 (0x00000000)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_REL_MODE_WRITE_AWAKEN          (0x00000001)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_RUN_MODE                       10:10
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_RUN_MODE_ONE_TIME              (0x00000000)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_RUN_MODE_CONTINUOUS            (0x00000001)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_CONTROL_RASTER_LINE                    31:16
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_VALUE(a,b)                             (0x000021EC + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_VALUE_VALUE                            31:0
#define NVCC7D_HEAD_SET_OUTPUT_SCALER_COEFF_VALUE(a)                            (0x00002214 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OUTPUT_SCALER_COEFF_VALUE_DATA                          9:0
#define NVCC7D_HEAD_SET_OUTPUT_SCALER_COEFF_VALUE_INDEX                         19:12
#define NVCC7D_HEAD_SET_MIN_FRAME_IDLE(a)                                       (0x00002218 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_MIN_FRAME_IDLE_LEADING_RASTER_LINES                     14:0
#define NVCC7D_HEAD_SET_MIN_FRAME_IDLE_TRAILING_RASTER_LINES                    30:16
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_ALPHA_RED(a)                              (0x00002220 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_ALPHA_RED_ALPHA                           7:0
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_ALPHA_RED_RED                             31:16
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_GREEN_BLUE(a)                             (0x00002224 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_GREEN_BLUE_GREEN                          15:0
#define NVCC7D_HEAD_SET_DESKTOP_COLOR_GREEN_BLUE_BLUE                           31:16
#define NVCC7D_HEAD_SET_CURSOR_COLOR_NORM_SCALE(a)                              (0x00002228 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CURSOR_COLOR_NORM_SCALE_VALUE                           15:0
#define NVCC7D_HEAD_SET_XOR_BLEND_FACTOR(a)                                     (0x0000222C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_XOR_BLEND_FACTOR_LOG2PEAK_LUMINANCE                     3:0
#define NVCC7D_HEAD_SET_XOR_BLEND_FACTOR_S1                                     16:4
#define NVCC7D_HEAD_SET_XOR_BLEND_FACTOR_S2                                     30:18
#define NVCC7D_HEAD_SET_CLAMP_RANGE_GREEN(a)                                    (0x00002238 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CLAMP_RANGE_GREEN_LOW                                   11:0
#define NVCC7D_HEAD_SET_CLAMP_RANGE_GREEN_HIGH                                  27:16
#define NVCC7D_HEAD_SET_CLAMP_RANGE_RED_BLUE(a)                                 (0x0000223C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CLAMP_RANGE_RED_BLUE_LOW                                11:0
#define NVCC7D_HEAD_SET_CLAMP_RANGE_RED_BLUE_HIGH                               27:16
#define NVCC7D_HEAD_SET_OCSC0CONTROL(a)                                         (0x00002240 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0CONTROL_ENABLE                                     0:0
#define NVCC7D_HEAD_SET_OCSC0CONTROL_ENABLE_DISABLE                             (0x00000000)
#define NVCC7D_HEAD_SET_OCSC0CONTROL_ENABLE_ENABLE                              (0x00000001)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C00(a)                                 (0x00002244 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C00_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C01(a)                                 (0x00002248 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C01_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C02(a)                                 (0x0000224C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C02_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C03(a)                                 (0x00002250 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C03_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C10(a)                                 (0x00002254 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C10_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C11(a)                                 (0x00002258 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C11_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C12(a)                                 (0x0000225C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C12_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C13(a)                                 (0x00002260 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C13_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C20(a)                                 (0x00002264 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C20_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C21(a)                                 (0x00002268 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C21_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C22(a)                                 (0x0000226C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C22_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C23(a)                                 (0x00002270 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC0COEFFICIENT_C23_VALUE                              20:0
#define NVCC7D_HEAD_SET_OLUT_CONTROL(a)                                         (0x00002280 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_INTERPOLATE                                0:0
#define NVCC7D_HEAD_SET_OLUT_CONTROL_INTERPOLATE_DISABLE                        (0x00000000)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_INTERPOLATE_ENABLE                         (0x00000001)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MIRROR                                     1:1
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MIRROR_DISABLE                             (0x00000000)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MIRROR_ENABLE                              (0x00000001)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MODE                                       3:2
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MODE_SEGMENTED                             (0x00000000)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MODE_DIRECT8                               (0x00000001)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_MODE_DIRECT10                              (0x00000002)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_SIZE                                       18:8
#define NVCC7D_HEAD_SET_OLUT_CONTROL_DIRECT_ROUND                               4:4
#define NVCC7D_HEAD_SET_OLUT_CONTROL_DIRECT_ROUND_DISABLE                       (0x00000000)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_DIRECT_ROUND_ENABLE                        (0x00000001)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_LEVEL                                      25:20
#define NVCC7D_HEAD_SET_OLUT_CONTROL_SEGMENT_SIZE_BITS                          5:5
#define NVCC7D_HEAD_SET_OLUT_CONTROL_SEGMENT_SIZE_BITS_SIZE_3BITS               (0x00000000)
#define NVCC7D_HEAD_SET_OLUT_CONTROL_SEGMENT_SIZE_BITS_SIZE_4BITS               (0x00000001)
#define NVCC7D_HEAD_SET_OLUT_FP_NORM_SCALE(a)                                   (0x00002284 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OLUT_FP_NORM_SCALE_VALUE                                31:0
#define NVCC7D_HEAD_SET_OCSC1CONTROL(a)                                         (0x0000229C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1CONTROL_ENABLE                                     0:0
#define NVCC7D_HEAD_SET_OCSC1CONTROL_ENABLE_DISABLE                             (0x00000000)
#define NVCC7D_HEAD_SET_OCSC1CONTROL_ENABLE_ENABLE                              (0x00000001)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C00(a)                                 (0x000022A0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C00_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C01(a)                                 (0x000022A4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C01_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C02(a)                                 (0x000022A8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C02_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C03(a)                                 (0x000022AC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C03_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C10(a)                                 (0x000022B0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C10_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C11(a)                                 (0x000022B4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C11_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C12(a)                                 (0x000022B8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C12_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C13(a)                                 (0x000022BC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C13_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C20(a)                                 (0x000022C0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C20_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C21(a)                                 (0x000022C4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C21_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C22(a)                                 (0x000022C8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C22_VALUE                              20:0
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C23(a)                                 (0x000022CC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_OCSC1COEFFICIENT_C23_VALUE                              20:0
#define NVCC7D_HEAD_SET_HEAD_POSITION(a)                                        (0x000022D0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HEAD_POSITION_X                                         2:0
#define NVCC7D_HEAD_SET_HEAD_POSITION_Y                                         6:4
#define NVCC7D_HEAD_SET_DSC_CONTROL(a)                                          (0x000022D4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_CONTROL_ENABLE                                      0:0
#define NVCC7D_HEAD_SET_DSC_CONTROL_ENABLE_FALSE                                (0x00000000)
#define NVCC7D_HEAD_SET_DSC_CONTROL_ENABLE_TRUE                                 (0x00000001)
#define NVCC7D_HEAD_SET_DSC_CONTROL_AUTO_RESET                                  3:3
#define NVCC7D_HEAD_SET_DSC_CONTROL_AUTO_RESET_DISABLE                          (0x00000000)
#define NVCC7D_HEAD_SET_DSC_CONTROL_AUTO_RESET_ENABLE                           (0x00000001)
#define NVCC7D_HEAD_SET_DSC_CONTROL_FULL_ICH_ERR_PRECISION                      4:4
#define NVCC7D_HEAD_SET_DSC_CONTROL_FULL_ICH_ERR_PRECISION_DISABLE              (0x00000000)
#define NVCC7D_HEAD_SET_DSC_CONTROL_FULL_ICH_ERR_PRECISION_ENABLE               (0x00000001)
#define NVCC7D_HEAD_SET_DSC_CONTROL_FORCE_ICH_RESET                             5:5
#define NVCC7D_HEAD_SET_DSC_CONTROL_FORCE_ICH_RESET_FALSE                       (0x00000000)
#define NVCC7D_HEAD_SET_DSC_CONTROL_FORCE_ICH_RESET_TRUE                        (0x00000001)
#define NVCC7D_HEAD_SET_DSC_CONTROL_FLATNESS_DET_THRESH                         15:6
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL(a)                                      (0x000022D8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_ENABLE                                  0:0
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_ENABLE_FALSE                            (0x00000000)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_ENABLE_TRUE                             (0x00000001)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LOCATION                                2:1
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LOCATION_VBLANK                         (0x00000000)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LOCATION_VSYNC                          (0x00000001)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LOCATION_LINE                           (0x00000002)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_SIZE                                    10:3
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_FREQUENCY                               11:11
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_FREQUENCY_EVERY_FRAME                   (0x00000000)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_FREQUENCY_ONCE                          (0x00000001)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LINE_ID                                 26:12
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LINE_ID_REVERSED                        27:27
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LINE_ID_REVERSED_DISABLE                (0x00000000)
#define NVCC7D_HEAD_SET_DSC_PPS_CONTROL_LINE_ID_REVERSED_ENABLE                 (0x00000001)
#define NVCC7D_HEAD_SET_DSC_PPS_HEAD(a)                                         (0x000022DC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_HEAD_BYTE0                                      7:0
#define NVCC7D_HEAD_SET_DSC_PPS_HEAD_BYTE1                                      15:8
#define NVCC7D_HEAD_SET_DSC_PPS_HEAD_BYTE2                                      23:16
#define NVCC7D_HEAD_SET_DSC_PPS_HEAD_BYTE3                                      31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0(a)                                        (0x000022E0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_DSC_VERSION_MINOR                         3:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_DSC_VERSION_MAJOR                         7:4
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_PPS_IDENTIFIER                            15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_RESERVED                                  23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_LINEBUF_DEPTH                             27:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA0_BITS_PER_COMPONENT                        31:28
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1(a)                                        (0x000022E4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_BITS_PER_PIXEL_HIGH                       1:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_VBR_ENABLE                                2:2
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_SIMPLE422                                 3:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_CONVERT_RGB                               4:4
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_BLOCK_PRED_ENABLE                         5:5
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_RESERVED                                  7:6
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_BITS_PER_PIXEL_LOW                        15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_PIC_HEIGHT_HIGH                           23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA1_PIC_HEIGHT_LOW                            31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA2(a)                                        (0x000022E8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA2_PIC_WIDTH_HIGH                            7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA2_PIC_WIDTH_LOW                             15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA2_SLICE_HEIGHT_HIGH                         23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA2_SLICE_HEIGHT_LOW                          31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA3(a)                                        (0x000022EC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA3_SLICE_WIDTH_HIGH                          7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA3_SLICE_WIDTH_LOW                           15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA3_CHUNK_SIZE_HIGH                           23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA3_CHUNK_SIZE_LOW                            31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4(a)                                        (0x000022F0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4_INITIAL_XMIT_DELAY_HIGH                   1:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4_RESERVED                                  7:2
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4_INITIAL_XMIT_DELAY_LOW                    15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4_INITIAL_DEC_DELAY_HIGH                    23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA4_INITIAL_DEC_DELAY_LOW                     31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5(a)                                        (0x000022F4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5_RESERVED0                                 7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5_INITIAL_SCALE_VALUE                       13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5_RESERVED1                                 15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5_SCALE_INCREMENT_INTERVAL_HIGH             23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA5_SCALE_INCREMENT_INTERVAL_LOW              31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6(a)                                        (0x000022F8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_SCALE_DECREMENT_INTERVAL_HIGH             3:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_RESERVED0                                 7:4
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_SCALE_DECREMENT_INTERVAL_LOW              15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_RESERVED1                                 23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_FIRST_LINE_BPG_OFFSET                     28:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA6_RESERVED2                                 31:29
#define NVCC7D_HEAD_SET_DSC_PPS_DATA7(a)                                        (0x000022FC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA7_NFL_BPG_OFFSET_HIGH                       7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA7_NFL_BPG_OFFSET_LOW                        15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA7_SLICE_BPG_OFFSET_HIGH                     23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA7_SLICE_BPG_OFFSET_LOW                      31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA8(a)                                        (0x00002300 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA8_INITIAL_OFFSET_HIGH                       7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA8_INITIAL_OFFSET_LOW                        15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA8_FINAL_OFFSET_HIGH                         23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA8_FINAL_OFFSET_LOW                          31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9(a)                                        (0x00002304 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_FLATNESS_MIN_QP                           4:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_RESERVED0                                 7:5
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_FLATNESS_MAX_QP                           12:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_RESERVED1                                 15:13
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_RC_MODEL_SIZE_HIGH                        23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA9_RC_MODEL_SIZE_LOW                         31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10(a)                                       (0x00002308 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RC_EDGE_FACTOR                           3:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RESERVED0                                7:4
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RC_QUANT_INCR_LIMIT0                     12:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RESERVED1                                15:13
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RC_QUANT_INCR_LIMIT1                     20:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RESERVED2                                23:21
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RC_TGT_OFFSET_LO                         27:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA10_RC_TGT_OFFSET_HI                         31:28
#define NVCC7D_HEAD_SET_DSC_PPS_DATA11(a)                                       (0x0000230C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA11_RC_BUF_THRESH0                           7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA11_RC_BUF_THRESH1                           15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA11_RC_BUF_THRESH2                           23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA11_RC_BUF_THRESH3                           31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA12(a)                                       (0x00002310 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA12_RC_BUF_THRESH4                           7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA12_RC_BUF_THRESH5                           15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA12_RC_BUF_THRESH6                           23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA12_RC_BUF_THRESH7                           31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA13(a)                                       (0x00002314 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA13_RC_BUF_THRESH8                           7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA13_RC_BUF_THRESH9                           15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA13_RC_BUF_THRESH10                          23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA13_RC_BUF_THRESH11                          31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14(a)                                       (0x00002318 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_BUF_THRESH12                          7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_BUF_THRESH13                          15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_RANGE_MAX_QP_HIGH0                    18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_RANGE_MIN_QP0                         23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_RANGE_BPG_OFFSET0                     29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA14_RC_RANGE_MAX_QP_LOW0                     31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15(a)                                       (0x0000231C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MAX_QP_HIGH1                    2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MIN_QP1                         7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_BPG_OFFSET1                     13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MAX_QP_LOW1                     15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MAX_QP_HIGH2                    18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MIN_QP2                         23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_BPG_OFFSET2                     29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA15_RC_RANGE_MAX_QP_LOW2                     31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16(a)                                       (0x00002320 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MAX_QP_HIGH3                    2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MIN_QP3                         7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_BPG_OFFSET3                     13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MAX_QP_LOW3                     15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MAX_QP_HIGH4                    18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MIN_QP4                         23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_BPG_OFFSET4                     29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA16_RC_RANGE_MAX_QP_LOW4                     31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17(a)                                       (0x00002324 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MAX_QP_HIGH5                    2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MIN_QP5                         7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_BPG_OFFSET5                     13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MAX_QP_LOW5                     15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MAX_QP_HIGH6                    18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MIN_QP6                         23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_BPG_OFFSET6                     29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA17_RC_RANGE_MAX_QP_LOW6                     31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18(a)                                       (0x00002328 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MAX_QP_HIGH7                    2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MIN_QP7                         7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_BPG_OFFSET7                     13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MAX_QP_LOW7                     15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MAX_QP_HIGH8                    18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MIN_QP8                         23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_BPG_OFFSET8                     29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA18_RC_RANGE_MAX_QP_LOW8                     31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19(a)                                       (0x0000232C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MAX_QP_HIGH9                    2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MIN_QP9                         7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_BPG_OFFSET9                     13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MAX_QP_LOW9                     15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MAX_QP_HIGH10                   18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MIN_QP10                        23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_BPG_OFFSET10                    29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA19_RC_RANGE_MAX_QP_LOW10                    31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20(a)                                       (0x00002330 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MAX_QP_HIGH11                   2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MIN_QP11                        7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_BPG_OFFSET11                    13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MAX_QP_LOW11                    15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MAX_QP_HIGH12                   18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MIN_QP12                        23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_BPG_OFFSET12                    29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA20_RC_RANGE_MAX_QP_LOW12                    31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21(a)                                       (0x00002334 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MAX_QP_HIGH13                   2:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MIN_QP13                        7:3
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_BPG_OFFSET13                    13:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MAX_QP_LOW13                    15:14
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MAX_QP_HIGH14                   18:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MIN_QP14                        23:19
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_BPG_OFFSET14                    29:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA21_RC_RANGE_MAX_QP_LOW14                    31:30
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22(a)                                       (0x00002338 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_NATIVE422                                0:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_NATIVE420                                1:1
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_RESERVED0                                7:2
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_SECOND_LINE_BPG_OFFSET                   12:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_RESERVED1                                15:13
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_NSL_BPG_OFFSET_HIGH                      23:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA22_NSL_BPG_OFFSETLOW                        31:24
#define NVCC7D_HEAD_SET_DSC_PPS_DATA23(a)                                       (0x0000233C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA23_SECOND_LINE_OFFSET_ADJ_HIGH              7:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA23_SECOND_LINE_OFFSET_ADJ_LOW               15:8
#define NVCC7D_HEAD_SET_DSC_PPS_DATA23_RESERVED                                 31:16
#define NVCC7D_HEAD_SET_DSC_PPS_DATA24(a)                                       (0x00002340 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA24_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA25(a)                                       (0x00002344 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA25_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA26(a)                                       (0x00002348 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA26_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA27(a)                                       (0x0000234C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA27_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA28(a)                                       (0x00002350 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA28_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA29(a)                                       (0x00002354 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA29_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA30(a)                                       (0x00002358 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA30_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_DSC_PPS_DATA31(a)                                       (0x0000235C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DSC_PPS_DATA31_RESERVED                                 31:0
#define NVCC7D_HEAD_SET_RASTER_HBLANK_DELAY(a)                                  (0x00002364 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_HBLANK_DELAY_BLANK_START                         15:0
#define NVCC7D_HEAD_SET_RASTER_HBLANK_DELAY_BLANK_END                           31:16
#define NVCC7D_HEAD_SET_HDMI_DSC_HCACTIVE(a)                                    (0x00002368 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HDMI_DSC_HCACTIVE_BYTES                                 15:0
#define NVCC7D_HEAD_SET_HDMI_DSC_HCACTIVE_TRI_BYTES                             31:16
#define NVCC7D_HEAD_SET_HDMI_DSC_HCBLANK(a)                                     (0x0000236C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HDMI_DSC_HCBLANK_WIDTH                                  15:0
#define NVCC7D_HEAD_SW_RESERVED(a,b)                                            (0x00002370 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SW_RESERVED_VALUE                                           31:0
#define NVCC7D_HEAD_SET_DP_CTRL(a)                                              (0x0000237C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DP_CTRL_EFFECTIVE_BITS_PER_PIXEL_ADJ                    9:0
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_VALUE_HI(a,b)                          (0x00002380 + (a)*0x00000800 + (b)*0x00000004)
#define NVCC7D_HEAD_SET_RG_REL_SEMAPHORE_VALUE_HI_VALUE                         31:0
#define NVCC7D_HEAD_SET_HEAD_INFOFRAME(a)                                       (0x000023A0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_HEAD_INFOFRAME_FID                                      7:0
#define NVCC7D_HEAD_SET_HEAD_INFOFRAME_EN                                       16:16
#define NVCC7D_HEAD_SET_HEAD_INFOFRAME_EN_DISABLE                               (0x00000000)
#define NVCC7D_HEAD_SET_HEAD_INFOFRAME_EN_ENABLE                                (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL(a)                                       (0x000023A4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MODE                                     1:0
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MODE_DISABLE                             (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MODE_EMP_VTEM_QMS                        (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MODE_EMP_OTHERS                          (0x00000002)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_FREQUENCY                                12:12
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_FREQUENCY_EVERY_FRAME                    (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_FREQUENCY_ONCE                           (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LOCATION                                 5:4
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LOCATION_VBLANK                          (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LOCATION_VSYNC                           (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LOCATION_LINE                            (0x00000002)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LINE_ID                                  30:16
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LINE_ID_REVERSED                         31:31
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LINE_ID_REVERSED_DISABLE                 (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_LINE_ID_REVERSED_ENABLE                  (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MTD_STATE_CTRL                           14:14
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MTD_STATE_CTRL_ACTIVE                    (0x00000000)
#define NVCC7D_HEAD_SET_INFOFRAME_CTRL_MTD_STATE_CTRL_ARM                       (0x00000001)
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER(a)                                     (0x000023A8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_HB0                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_HB1                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_HB2                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_HEADER_HB3                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA0(a)                                      (0x000023AC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA0_DB0                                     7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA0_DB1                                     15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA0_DB2                                     23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA0_DB3                                     31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA1(a)                                      (0x000023B0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA1_DB4                                     7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA1_DB5                                     15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA1_DB6                                     23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA1_DB7                                     31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA2(a)                                      (0x000023B4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA2_DB8                                     7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA2_DB9                                     15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA2_DB10                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA2_DB11                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA3(a)                                      (0x000023B8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA3_DB12                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA3_DB13                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA3_DB14                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA3_DB15                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA4(a)                                      (0x000023BC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA4_DB16                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA4_DB17                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA4_DB18                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA4_DB19                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA5(a)                                      (0x000023C0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA5_DB20                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA5_DB21                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA5_DB22                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA5_DB23                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA6(a)                                      (0x000023C4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA6_DB24                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA6_DB25                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA6_DB26                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA6_DB27                                    31:24
#define NVCC7D_HEAD_SET_INFOFRAME_DATA7(a)                                      (0x000023C8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_INFOFRAME_DATA7_DB28                                    7:0
#define NVCC7D_HEAD_SET_INFOFRAME_DATA7_DB29                                    15:8
#define NVCC7D_HEAD_SET_INFOFRAME_DATA7_DB30                                    23:16
#define NVCC7D_HEAD_SET_INFOFRAME_DATA7_DB31                                    31:24
#define NVCC7D_HEAD_SET_RASTER_SIZE_FRACTION(a)                                 (0x000023CC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RASTER_SIZE_FRACTION_HEIGHT                             15:0
#define NVCC7D_HEAD_SET_LTM_CONTROL(a)                                          (0x000023D0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_CONTROL_ENABLE                                      0:0
#define NVCC7D_HEAD_SET_LTM_CONTROL_ENABLE_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_ENABLE_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_MODE                                        1:1
#define NVCC7D_HEAD_SET_LTM_CONTROL_MODE_TMO                                    (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_MODE_LTM                                    (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_TONE_SELECT                                 2:2
#define NVCC7D_HEAD_SET_LTM_CONTROL_TONE_SELECT_INTENSITY                       (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_TONE_SELECT_CDB                             (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_SKIN_TONE_ENABLE                            3:3
#define NVCC7D_HEAD_SET_LTM_CONTROL_SKIN_TONE_ENABLE_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_SKIN_TONE_ENABLE_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_INTERPOLATE                             4:4
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_INTERPOLATE_DISABLE                     (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_INTERPOLATE_ENABLE                      (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT8                                 5:5
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT8_DISABLE                         (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT8_ENABLE                          (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT10                                6:6
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT10_DISABLE                        (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT10_ENABLE                         (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT_ROUND                            7:7
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT_ROUND_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_LUT_DIRECT_ROUND_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_SOURCE                                 9:8
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_SOURCE_MAX_RGB                         (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_SOURCE_LIN_I                           (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_SOURCE_PQI                             (0x00000002)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_SOURCE_CDB                             (0x00000003)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_RANGE                                  11:10
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_RANGE_RANGE_10000                      (0x00000000)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_RANGE_RANGE_5000                       (0x00000001)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_RANGE_RANGE_2500                       (0x00000002)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_RANGE_RANGE_1250                       (0x00000003)
#define NVCC7D_HEAD_SET_LTM_CONTROL_HIST_END_LINE                               31:16
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C00(a)                                    (0x000023D4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C00_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C01(a)                                    (0x000023D8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C01_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C02(a)                                    (0x000023DC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C02_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C03(a)                                    (0x000023E0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C03_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C10(a)                                    (0x000023E4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C10_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C11(a)                                    (0x000023E8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C11_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C12(a)                                    (0x000023EC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C12_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C13(a)                                    (0x000023F0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C13_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C20(a)                                    (0x000023F4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C20_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C21(a)                                    (0x000023F8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C21_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C22(a)                                    (0x000023FC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C22_VALUE                                 20:0
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C23(a)                                    (0x00002400 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_COEFF_C23_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C00(a)                                    (0x00002404 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C00_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C01(a)                                    (0x00002408 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C01_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C02(a)                                    (0x0000240C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C02_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C03(a)                                    (0x00002410 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C03_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C10(a)                                    (0x00002414 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C10_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C11(a)                                    (0x00002418 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C11_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C12(a)                                    (0x0000241C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C12_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C13(a)                                    (0x00002420 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C13_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C20(a)                                    (0x00002424 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C20_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C21(a)                                    (0x00002428 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C21_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C22(a)                                    (0x0000242C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C22_VALUE                                 20:0
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C23(a)                                    (0x00002430 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_COEFF_C23_VALUE                                 20:0
#define NVCC7D_HEAD_SET_LTM_MAX_SELECTIVE_UPDATE(a)                             (0x00002434 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_MAX_SELECTIVE_UPDATE_SIZE                           31:0
#define NVCC7D_HEAD_SET_SELF_REFRESH_OVERRIDE(a)                                (0x00002438 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SELF_REFRESH_OVERRIDE_FRAME_RELEASE                     0:0
#define NVCC7D_HEAD_SET_SELF_REFRESH_OVERRIDE_FRAME_RELEASE_AUTOMATIC           (0x00000000)
#define NVCC7D_HEAD_SET_SELF_REFRESH_OVERRIDE_FRAME_RELEASE_MANUAL              (0x00000001)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE(a)                                     (0x0000243C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_ENABLE                                 0:0
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_ENABLE_DISABLE                         (0x00000000)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_ENABLE_ENABLE                          (0x00000001)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_EARLY_REGION                           1:1
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_EARLY_REGION_DISABLE                   (0x00000000)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_EARLY_REGION_ENABLE                    (0x00000001)
#define NVCC7D_HEAD_SET_CURSOR_DIRTY(a)                                         (0x00002440 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_CURSOR_DIRTY_STATE                                      0:0
#define NVCC7D_HEAD_SET_CURSOR_DIRTY_STATE_FALSE                                (0x00000000)
#define NVCC7D_HEAD_SET_CURSOR_DIRTY_STATE_TRUE                                 (0x00000001)
#define NVCC7D_HEAD_SET_DPM_CONTROL(a)                                          (0x00002444 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_DPM_CONTROL_ENABLE                                      0:0
#define NVCC7D_HEAD_SET_DPM_CONTROL_ENABLE_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_DPM_CONTROL_ENABLE_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_DPM_CONTROL_ALPM                                        1:1
#define NVCC7D_HEAD_SET_DPM_CONTROL_ALPM_DISABLE                                (0x00000000)
#define NVCC7D_HEAD_SET_DPM_CONTROL_ALPM_ENABLE                                 (0x00000001)
#define NVCC7D_HEAD_SET_DPM_CONTROL_ALPM_TYPE                                   2:2
#define NVCC7D_HEAD_SET_DPM_CONTROL_ALPM_TYPE_AUX_LESS                          (0x00000000)
#define NVCC7D_HEAD_SET_DPM_CONTROL_AS_SDP                                      3:3
#define NVCC7D_HEAD_SET_DPM_CONTROL_AS_SDP_DISABLE                              (0x00000000)
#define NVCC7D_HEAD_SET_DPM_CONTROL_AS_SDP_ENABLE                               (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL(a)                                         (0x00002448 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_ENABLE                                     0:0
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_ENABLE_DISABLE                             (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_ENABLE_ENABLE                              (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_SELF_REFRESH                               1:1
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_SELF_REFRESH_DISABLE                       (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_SELF_REFRESH_ENABLE                        (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_MODE                                       3:2
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_MODE_PSR1                                  (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_MODE_PANEL_REPLAY                          (0x00000002)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CRC                                        4:4
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CRC_DISABLE                                (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CRC_ENABLE                                 (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_LOCATION                                   7:6
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_LOCATION_VBLANK                            (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_LOCATION_VSYNC                             (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_LOCATION_LINE                              (0x00000002)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_LINE_ID                                    22:8
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CAPTURE_INDICATOR                          23:23
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CAPTURE_INDICATOR_SAME                     (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_CAPTURE_INDICATOR_EARLY                    (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_IDLE_SDP                                   24:24
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_IDLE_SDP_DISABLE                           (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_IDLE_SDP_ENABLE                            (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_OVERRIDE_SU_VSC                            25:25
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_OVERRIDE_SU_VSC_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_VSC_SDP_CTRL_OVERRIDE_SU_VSC_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_VSC_SDP_HEADER(a)                                       (0x0000244C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_HEADER_HEADER_BYTE                              31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA0(a)                                        (0x00002450 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA0_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA1(a)                                        (0x00002454 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA1_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA2(a)                                        (0x00002458 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA2_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA3(a)                                        (0x0000245C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA3_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA4(a)                                        (0x00002460 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA4_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA5(a)                                        (0x00002464 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA5_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA6(a)                                        (0x00002468 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA6_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_VSC_SDP_DATA7(a)                                        (0x0000246C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_VSC_SDP_DATA7_DATA_BYTE                                 31:0
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL(a)                                      (0x00002470 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_INPUT_MATRIX                     0:0
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_INPUT_MATRIX_DISABLE             (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_INPUT_MATRIX_ENABLE              (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_FVLUT                            1:1
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_FVLUT_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_FVLUT_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_INTERPOLATE                       4:4
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_INTERPOLATE_DISABLE               (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_INTERPOLATE_ENABLE                (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_MIRROR                            5:5
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_MIRROR_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_MIRROR_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_CURVE                             7:6
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_CURVE_CSCLUT_PQ                   (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_CURVE_CSCLUT_HLG                  (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_FVLUT_CURVE_CSCLUT_DIRECT               (0x00000002)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_OUTPUT_MATRIX                    2:2
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_OUTPUT_MATRIX_DISABLE            (0x00000000)
#define NVCC7D_HEAD_SET_RGB2ITP_CONTROL_ENABLE_OUTPUT_MATRIX_ENABLE             (0x00000001)
#define NVCC7D_HEAD_SET_RGB2ITP_LUT_FP_NORM_SCALE(a)                            (0x00002474 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_RGB2ITP_LUT_FP_NORM_SCALE_VALUE                         31:0
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL(a)                                      (0x00002478 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_INPUT_MATRIX                     0:0
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_INPUT_MATRIX_DISABLE             (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_INPUT_MATRIX_ENABLE              (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_FVLUT                            1:1
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_FVLUT_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_FVLUT_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_INTERPOLATE                       4:4
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_INTERPOLATE_DISABLE               (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_INTERPOLATE_ENABLE                (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_MIRROR                            5:5
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_MIRROR_DISABLE                    (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_MIRROR_ENABLE                     (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_CURVE                             7:6
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_CURVE_CSCLUT_PQ                   (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_CURVE_CSCLUT_HLG                  (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_FVLUT_CURVE_CSCLUT_DIRECT               (0x00000002)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_OUTPUT_MATRIX                    2:2
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_OUTPUT_MATRIX_DISABLE            (0x00000000)
#define NVCC7D_HEAD_SET_ITP2RGB_CONTROL_ENABLE_OUTPUT_MATRIX_ENABLE             (0x00000001)
#define NVCC7D_HEAD_SET_ITP2RGB_LUT_FP_SCALE(a)                                 (0x0000247C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_ITP2RGB_LUT_FP_SCALE_VALUE                              15:0
#define NVCC7D_HEAD_SET_BLANK_OUTPUT_COLOR(a)                                   (0x00002484 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_BLANK_OUTPUT_COLOR_RED_CR                               9:0
#define NVCC7D_HEAD_SET_BLANK_OUTPUT_COLOR_GREEN_Y                              19:10
#define NVCC7D_HEAD_SET_BLANK_OUTPUT_COLOR_BLUE_CB                              29:20
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_GRANULARITY(a)                         (0x0000249C + (a)*0x00000800)
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_GRANULARITY_X                          15:0
#define NVCC7D_HEAD_SET_SELECTIVE_UPDATE_GRANULARITY_Y                          31:16
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C00(a)                                   (0x000024A0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C00_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C01(a)                                   (0x000024A4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C01_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C02(a)                                   (0x000024A8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C02_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C03(a)                                   (0x000024AC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C03_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C10(a)                                   (0x000024B0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C10_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C11(a)                                   (0x000024B4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C11_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C12(a)                                   (0x000024B8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C12_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C13(a)                                   (0x000024BC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C13_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C20(a)                                   (0x000024C0 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C20_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C21(a)                                   (0x000024C4 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C21_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C22(a)                                   (0x000024C8 + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C22_VALUE                                20:0
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C23(a)                                   (0x000024CC + (a)*0x00000800)
#define NVCC7D_HEAD_SET_LTM_HIST_COEFF_C23_VALUE                                20:0

#define NVCC7D_TILE_SET_TILE_SIZE(a)                                            (0x00006000 + (a)*0x00000200)
#define NVCC7D_TILE_SET_TILE_SIZE_START                                         14:0
#define NVCC7D_TILE_SET_TILE_SIZE_WIDTH                                         30:16
#define NVCC7D_TILE_SET_CMI_LUT_SEGMENT_SIZE(a)                                 (0x00006074 + (a)*0x00000200)
#define NVCC7D_TILE_SET_CMI_LUT_SEGMENT_SIZE_IDX                                5:0
#define NVCC7D_TILE_SET_CMI_LUT_SEGMENT_SIZE_VALUE                              8:6
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY(a)                                        (0x00006078 + (a)*0x00000200)
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY_IDX                                       10:0
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY_VALUE                                     24:11
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY_LAST                                      25:25
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY_LAST_FALSE                                (0x00000000)
#define NVCC7D_TILE_SET_CMI_LUT_ENTRY_LAST_TRUE                                 (0x00000001)
#define NVCC7D_TILE_SET_CMO_LUT_SEGMENT_SIZE(a)                                 (0x0000607C + (a)*0x00000200)
#define NVCC7D_TILE_SET_CMO_LUT_SEGMENT_SIZE_IDX                                5:0
#define NVCC7D_TILE_SET_CMO_LUT_SEGMENT_SIZE_VALUE                              8:6
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY(a)                                        (0x00006080 + (a)*0x00000200)
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY_IDX                                       10:0
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY_VALUE                                     26:11
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY_LAST                                      27:27
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY_LAST_FALSE                                (0x00000000)
#define NVCC7D_TILE_SET_CMO_LUT_ENTRY_LAST_TRUE                                 (0x00000001)

#ifdef __cplusplus
};     /* extern "C" */
#endif
#endif // _clcc7d_h
