/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.observers;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.DelayedDropAction;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;

public final class SessionFactoryObserverForSchemaExport
implements SessionFactoryObserver {
    private final MetadataImplementor metadata;
    private DelayedDropAction delayedDropAction;

    public SessionFactoryObserverForSchemaExport(MetadataImplementor metadata) {
        this.metadata = metadata;
    }

    public void sessionFactoryCreated(SessionFactory factory) {
        SchemaManagementToolCoordinator.process((Metadata)this.metadata, (ServiceRegistry)SessionFactoryObserverForSchemaExport.getRegistry(factory), (Map)factory.getProperties(), action -> {
            this.delayedDropAction = action;
        });
    }

    public void sessionFactoryClosing(SessionFactory factory) {
        if (this.delayedDropAction != null) {
            this.delayedDropAction.perform((ServiceRegistry)SessionFactoryObserverForSchemaExport.getRegistry(factory));
        }
    }

    private static ServiceRegistryImplementor getRegistry(SessionFactory factory) {
        return ((SessionFactoryImplementor)factory).getServiceRegistry();
    }
}

