/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.json;

import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.dialect.function.json.JsonPathHelper;
import org.hibernate.dialect.function.json.JsonQueryFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.expression.JsonQueryEmptyBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryErrorBehavior;
import org.hibernate.sql.ast.tree.expression.JsonQueryWrapMode;
import org.hibernate.type.spi.TypeConfiguration;

public class SingleStoreJsonQueryFunction
extends JsonQueryFunction {
    public SingleStoreJsonQueryFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration, true, false);
    }

    protected void render(SqlAppender sqlAppender, JsonQueryFunction.JsonQueryArguments arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String jsonPath;
        if (arguments.errorBehavior() != null && arguments.errorBehavior() != JsonQueryErrorBehavior.ERROR) {
            throw new QueryException("Can't emulate on error clause on SingleStore");
        }
        if (arguments.emptyBehavior() != null && arguments.emptyBehavior() != JsonQueryEmptyBehavior.NULL) {
            throw new QueryException("Can't emulate on empty clause on SingleStore");
        }
        try {
            jsonPath = (String)walker.getLiteralValue(arguments.jsonPath());
        }
        catch (Exception ex) {
            throw new QueryException("SingleStore json_query only support literal json paths, but got " + String.valueOf(arguments.jsonPath()));
        }
        List jsonPathElements = JsonPathHelper.parseJsonPathElements((String)jsonPath);
        JsonQueryWrapMode wrapMode = arguments.wrapMode();
        DecorationMode decorationMode = SingleStoreJsonQueryFunction.determineDecorationMode(wrapMode);
        if (decorationMode == DecorationMode.WRAP) {
            sqlAppender.appendSql("concat('[',");
        }
        sqlAppender.appendSql("nullif(json_extract_string(");
        arguments.jsonDocument().accept(walker);
        for (JsonPathHelper.JsonPathElement pathElement : jsonPathElements) {
            sqlAppender.appendSql(',');
            if (pathElement instanceof JsonPathHelper.JsonAttribute) {
                JsonPathHelper.JsonAttribute attribute = (JsonPathHelper.JsonAttribute)pathElement;
                sqlAppender.appendSingleQuoteEscapedString(attribute.attribute());
                continue;
            }
            if (pathElement instanceof JsonPathHelper.JsonParameterIndexAccess) {
                String parameterName = ((JsonPathHelper.JsonParameterIndexAccess)pathElement).parameterName();
                throw new QueryException("JSON path [" + jsonPath + "] uses parameter [" + parameterName + "] that is not passed");
            }
            sqlAppender.appendSql('\'');
            sqlAppender.appendSql(((JsonPathHelper.JsonIndexAccess)pathElement).index());
            sqlAppender.appendSql('\'');
        }
        sqlAppender.appendSql("),'null')");
        if (decorationMode == DecorationMode.WRAP) {
            sqlAppender.appendSql(",']')");
        }
    }

    private static DecorationMode determineDecorationMode(JsonQueryWrapMode wrapMode) {
        if (wrapMode == JsonQueryWrapMode.WITH_WRAPPER) {
            return DecorationMode.WRAP;
        }
        return DecorationMode.NONE;
    }

    static enum DecorationMode {
        NONE,
        WRAP;

    }
}

