/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.sf.juife.EnhancedDialog;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.classic.ChannelsPane;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.NewTabPane;

public class NewChannelsTabDlg
extends EnhancedDialog {
    private final NewTabPane newTabPane = new NewTabPane();
    private final JButton btnOk = new JButton(ClassicI18n.i18n.getButtonLabel("ok"));
    private final JButton btnCancel = new JButton(ClassicI18n.i18n.getButtonLabel("cancel"));

    public NewChannelsTabDlg(Frame frame) {
        super(frame, ClassicI18n.i18n.getLabel("NewChannelsTabDlg"), true);
        this.initNewChannelsTabDlg();
        this.handleEvents();
        this.setLocation(JuifeUtils.centerLocation(this, frame));
    }

    private void initNewChannelsTabDlg() {
        Dimension dimension = JuifeUtils.getUnionSize((Component)this.btnOk, this.btnCancel);
        this.btnOk.setPreferredSize(dimension);
        this.btnOk.setMaximumSize(dimension);
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.btnOk);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jPanel.add(this.btnCancel);
        jPanel.setAlignmentX(1.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.newTabPane.setAlignmentX(1.0f);
        jPanel2.add(this.newTabPane);
        jPanel2.add(Box.createRigidArea(new Dimension(0, 12)));
        jPanel2.add(jPanel);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.add(jPanel2);
        this.pack();
        dimension = this.getPreferredSize();
        dimension.width = dimension.width > 300 ? dimension.width : 300;
        this.setSize(dimension);
        this.setResizable(false);
    }

    private void handleEvents() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewChannelsTabDlg.this.onCancel();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewChannelsTabDlg.this.onOk();
            }
        });
    }

    @Override
    protected void onOk() {
        String string = this.newTabPane.getTitle().trim();
        ChannelsPane channelsPane = new ChannelsPane(string);
        if (string.length() == 0) {
            HF.showErrorMessage(ClassicI18n.i18n.getError("NewChannelsTabDlg.emptyTitle!"), (Component)this);
            return;
        }
        for (JSChannelsPane jSChannelsPane : CC.getMainFrame().getChannelsPaneList()) {
            if (!channelsPane.getTitle().equals(jSChannelsPane.getTitle())) continue;
            String string2 = ClassicI18n.i18n.getError("NewChannelsTabDlg.tabExist!", channelsPane.getTitle());
            HF.showErrorMessage(string2, (Component)this);
            return;
        }
        JSMainFrame jSMainFrame = CC.getMainFrame();
        if (this.newTabPane.rbBeginning.isSelected()) {
            jSMainFrame.insertChannelsPane(channelsPane, 0);
        } else if (this.newTabPane.rbAfter.isSelected()) {
            int n = jSMainFrame.getChannelsPaneList().indexOf(this.newTabPane.cbTabs.getSelectedItem());
            if (n == -1) {
                CC.getLogger().warning("ChannelsPane not found in the list!");
                n = jSMainFrame.getChannelsPaneCount() - 1;
            }
            jSMainFrame.insertChannelsPane(channelsPane, n + 1);
        } else {
            jSMainFrame.insertChannelsPane(channelsPane, jSMainFrame.getChannelsPaneCount());
        }
        this.setVisible(false);
    }

    @Override
    protected void onCancel() {
        this.setVisible(false);
    }
}

