/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.forcefield.Calculation;

class MMFFESCalc
extends Calculation {
    private static final double BUFF = 0.05;

    MMFFESCalc() {
    }

    @Override
    void setData(Lst<Object[]> calc, int ia, int ib, double d) {
        if (this.calcs.minAtoms[ia].partialCharge == 0.0 || this.calcs.minAtoms[ib].partialCharge == 0.0) {
            return;
        }
        calc.addLast(new Object[]{new int[]{ia, ib}, new double[]{this.calcs.minAtoms[ia].partialCharge, this.calcs.minAtoms[ib].partialCharge, this.calcs.minAtoms[ia].bs14.get(ib) ? 249.0537 : 332.0716}});
    }

    @Override
    double compute(Object[] dataIn) {
        this.getPointers(dataIn);
        double f = this.dData[0] * this.dData[1] * this.dData[2];
        this.calcs.setPairVariables(this);
        double d = this.rab + 0.05;
        this.energy = f / d;
        if (this.calcs.gradients) {
            this.dE = -this.energy / d;
            this.calcs.addForces(this, 2);
        }
        if (this.calcs.logging && Math.abs(this.energy) > 20.0) {
            this.calcs.appendLogData(this.calcs.getDebugLine(6, this));
        }
        return this.energy;
    }
}

