/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J6\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J*\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u0016\u001a\u00020\u0014*\u00020\u0011H\u0002J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u0011H\u0002J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0018H\u0002J6\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J*\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u001f\u001a\u00020\u0014*\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0014*\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002J\u001a\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010$*\u00020\n2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010%\u001a\u00020\u0014*\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\u0014*\u0006\u0012\u0002\b\u00030)H\u0002J\u001c\u0010*\u001a\u00020\u0014*\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u001e\u0010/\u001a\u0004\u0018\u000100*\u00020\u00022\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002\u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotated", "targetSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "outerProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "reportStaticNotInProperObject", "supportsJvmStaticInInterface", "", "checkForInterface", "hasExternalParts", "getMinimumVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "chooseMostSpecific", "a", "b", "checkOverrideCannotBeStatic", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "checkStaticOnConstOrJvmField", "containerIsInterface", "outerLevel", "", "containerIsNonCompanionObject", "getContainerAt", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "supports", "feature", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "isCompanion", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "hasAnnotationNamedAs", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "findAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmStaticChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1#2:241\n21#3:242\n52#3:243\n52#3:244\n52#3:245\n52#3:246\n21#3:247\n21#3:248\n21#3:249\n37#3:250\n54#3:251\n34#4:252\n65#5:253\n65#5:254\n295#6,2:255\n*S KotlinDebug\n*F\n+ 1 FirJvmStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmStaticChecker\n*L\n124#1:242\n130#1:243\n141#1:244\n144#1:245\n148#1:246\n155#1:247\n158#1:248\n162#1:249\n184#1:250\n200#1:251\n207#1:252\n213#1:253\n228#1:254\n235#1:255,2\n*E\n"})
public final class FirJvmStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmStaticChecker INSTANCE = new FirJvmStaticChecker();

    private FirJvmStaticChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        block4: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            FirJvmStaticChecker.check$checkIfAnnotated(context, declaration, reporter, declaration);
            if (!(declaration instanceof FirProperty)) break block4;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                FirJvmStaticChecker.check$checkIfAnnotated(context, declaration, reporter, it);
            }
        }
    }

    private final void checkAnnotated(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        boolean containerIsAnonymous;
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        FirBasedSymbol<?> firBasedSymbol = this.getContainerAt(context, 0);
        if (firBasedSymbol == null) {
            return;
        }
        FirBasedSymbol<?> container = firBasedSymbol;
        boolean supportsJvmStaticInInterface = this.supports(context, LanguageFeature.JvmStaticInInterface);
        boolean bl = containerIsAnonymous = container instanceof FirClassSymbol && Intrinsics.areEqual(((FirClassSymbol)container).getClassId().getShortClassName(), SpecialNames.ANONYMOUS);
        if (!(container instanceof FirClassSymbol) || ((FirClassSymbol)container).getClassKind() != ClassKind.OBJECT || !this.isCompanion((FirClassLikeSymbol)container) && containerIsAnonymous) {
            this.reportStaticNotInProperObject(context, reporter, supportsJvmStaticInInterface, targetSource);
        } else if (this.isCompanion((FirClassLikeSymbol)container) && this.containerIsInterface(context, 1)) {
            if (supportsJvmStaticInInterface) {
                this.checkForInterface(declaration, context, reporter, targetSource);
            } else {
                this.reportStaticNotInProperObject(context, reporter, supportsJvmStaticInInterface, targetSource);
            }
        }
        this.checkOverrideCannotBeStatic((FirMemberDeclaration)declaration, context, reporter, targetSource, outerProperty);
        this.checkStaticOnConstOrJvmField(declaration, context, reporter, targetSource);
    }

    private final void reportStaticNotInProperObject(CheckerContext context, DiagnosticReporter reporter, boolean supportsJvmStaticInInterface, KtSourceElement targetSource) {
        KtDiagnosticFactory0 properDiagnostic = supportsJvmStaticInInterface ? FirJvmErrors.INSTANCE.getJVM_STATIC_NOT_IN_OBJECT_OR_COMPANION() : FirJvmErrors.INSTANCE.getJVM_STATIC_NOT_IN_OBJECT_OR_CLASS_COMPANION();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, properDiagnostic, (DiagnosticContext)context, null, 8, null);
    }

    private final void checkForInterface(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        boolean isExternal;
        boolean bl;
        Visibility visibility;
        Visibility visibility2;
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration instanceof FirProperty) {
            visibility2 = this.getMinimumVisibility((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            visibility2 = visibility = $this$visibility$iv.getStatus().getVisibility();
        }
        if (declaration instanceof FirProperty) {
            bl = this.hasExternalParts((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$isExternal$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$isExternal = false;
            bl = isExternal = $this$isExternal$iv.getStatus().isExternal();
        }
        if (!Intrinsics.areEqual(visibility, Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_NON_PUBLIC_MEMBER(), (DiagnosticContext)context, null, 8, null);
        } else if (isExternal) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_EXTERNAL_IN_INTERFACE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean hasExternalParts(FirProperty $this$hasExternalParts) {
        block5: {
            block4: {
                hasExternal = false;
                $this$isExternal$iv = $this$hasExternalParts;
                $i$f$isExternal = false;
                hasExternal = $this$isExternal$iv.getStatus().isExternal();
                v0 = $this$hasExternalParts.getGetter();
                if (v0 == null) break block4;
                it = v0;
                $i$a$-let-FirJvmStaticChecker$hasExternalParts$1 = false;
                if (hasExternal) ** GOTO lbl-1000
                $this$isExternal$iv = it;
                $i$f$isExternal = false;
                if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                hasExternal = v1;
            }
            v2 = $this$hasExternalParts.getSetter();
            if (v2 == null) break block5;
            it = v2;
            $i$a$-let-FirJvmStaticChecker$hasExternalParts$2 = false;
            if (hasExternal) ** GOTO lbl-1000
            $this$isExternal$iv = it;
            $i$f$isExternal = false;
            if ($this$isExternal$iv.getStatus().isExternal()) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            hasExternal = v3;
        }
        return hasExternal;
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a, Visibility b) {
        Integer n = a.compareTo(b);
        if (n == null) {
            return a;
        }
        int difference2 = n;
        return difference2 > 0 ? b : a;
    }

    private final void checkOverrideCannotBeStatic(FirMemberDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource, FirProperty outerProperty) {
        boolean isOverride;
        boolean bl;
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        FirProperty firProperty = outerProperty;
        if (firProperty != null) {
            $this$isOverride$iv = firProperty;
            $i$f$isOverride = false;
            bl = $this$isOverride$iv.getStatus().isOverride();
        } else {
            $this$isOverride$iv = declaration;
            $i$f$isOverride = false;
            bl = isOverride = $this$isOverride$iv.getStatus().isOverride();
        }
        if (!isOverride || !this.containerIsNonCompanionObject(context, 0)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getOVERRIDE_CANNOT_BE_STATIC(), (DiagnosticContext)context, null, 8, null);
    }

    private final void checkStaticOnConstOrJvmField(FirDeclaration declaration, CheckerContext context, DiagnosticReporter reporter, KtSourceElement targetSource) {
        block5: {
            block4: {
                if (!(declaration instanceof FirProperty)) {
                    return;
                }
                FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isConst = false;
                if ($this$isConst$iv.getStatus().isConst()) break block4;
                FirBackingField firBackingField = ((FirProperty)declaration).getBackingField();
                boolean bl = firBackingField != null ? this.hasAnnotationNamedAs(firBackingField, JvmStandardClassIds.Annotations.INSTANCE.getJvmField(), context.getSession()) : false;
                if (!bl) break block5;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)targetSource, FirJvmErrors.INSTANCE.getJVM_STATIC_ON_CONST_OR_JVM_FIELD(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containerIsInterface(CheckerContext $this$containerIsInterface, int outerLevel) {
        FirBasedSymbol<?> container = this.getContainerAt($this$containerIsInterface, outerLevel);
        if (!(container instanceof FirClassSymbol)) return false;
        ClassKind $this$isInterface$iv = ((FirClassSymbol)container).getClassKind();
        boolean $i$f$isInterface = false;
        if ($this$isInterface$iv != ClassKind.INTERFACE) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containerIsNonCompanionObject(CheckerContext $this$containerIsNonCompanionObject, int outerLevel) {
        FirBasedSymbol<?> firBasedSymbol = this.getContainerAt($this$containerIsNonCompanionObject, outerLevel);
        if (firBasedSymbol == null) {
            return false;
        }
        FirBasedSymbol<?> containingClassSymbol = firBasedSymbol;
        if (!(containingClassSymbol instanceof FirRegularClassSymbol)) return false;
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)containingClassSymbol;
        if (firRegularClassSymbol == null) {
            return false;
        }
        FirRegularClassSymbol containingClass = firRegularClassSymbol;
        if (containingClass.getClassKind() != ClassKind.OBJECT) return false;
        FirClassLikeSymbol $this$isCompanion$iv = containingClass;
        boolean $i$f$isCompanion = false;
        if ($this$isCompanion$iv.getRawStatus().isCompanion()) return false;
        return true;
    }

    private final FirBasedSymbol<?> getContainerAt(CheckerContext $this$getContainerAt, int outerLevel) {
        FirDeclaration last;
        int correction = CollectionsKt.lastOrNull($this$getContainerAt.getContainingDeclarations()) instanceof FirProperty ? 1 : 0;
        FirDeclaration firDeclaration = last = CollectionsKt.getOrNull(CollectionsKt.asReversed($this$getContainerAt.getContainingDeclarations()), outerLevel + correction);
        return firDeclaration != null ? firDeclaration.getSymbol() : null;
    }

    private final boolean supports(CheckerContext $this$supports, LanguageFeature feature) {
        return FirLanguageSettingsComponentKt.getLanguageVersionSettings($this$supports.getSession()).supportsFeature(feature);
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean hasAnnotationNamedAs(FirDeclaration $this$hasAnnotationNamedAs, ClassId classId, FirSession session2) {
        return this.findAnnotation($this$hasAnnotationNamedAs, classId, session2) != null;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId, FirSession session2) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()), session2), classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        FirAnnotation firAnnotation = INSTANCE.findAnnotation(it, JvmStandardClassIds.Annotations.INSTANCE.getJvmStatic(), $context.getSession());
        if (firAnnotation == null) {
            return;
        }
        FirAnnotation annotation = firAnnotation;
        KtSourceElement ktSourceElement = annotation.getSource();
        if (ktSourceElement == null && (ktSourceElement = it.getSource()) == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated(it, $context, $reporter, targetSource, $declaration instanceof FirProperty ? (FirProperty)$declaration : null);
    }
}

