/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.chooseContainer;

import com.intellij.codeInsight.unwrap.RangeSplitter;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/chooseContainer/SelectionAwareScopeHighlighter;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "highlighters", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addHighlighter", "", "r", "Lcom/intellij/openapi/util/TextRange;", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "highlight", "wholeAffected", "Lcom/intellij/psi/PsiElement;", "dropHighlight", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nchooseContainerUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 chooseContainerUtil.kt\norg/jetbrains/kotlin/idea/refactoring/chooseContainer/SelectionAwareScopeHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n1#2:257\n1869#3,2:258\n*S KotlinDebug\n*F\n+ 1 chooseContainerUtil.kt\norg/jetbrains/kotlin/idea/refactoring/chooseContainer/SelectionAwareScopeHighlighter\n*L\n249#1:258,2\n*E\n"})
final class SelectionAwareScopeHighlighter {
    @NotNull
    private final Editor editor;
    @NotNull
    private final ArrayList<RangeHighlighter> highlighters;

    public SelectionAwareScopeHighlighter(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.highlighters = new ArrayList();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    private final void addHighlighter(TextRange r, TextAttributes attr) {
        this.highlighters.add(this.editor.getMarkupModel().addRangeHighlighter(r.getStartOffset(), r.getEndOffset(), 6001, attr, HighlighterTargetArea.EXACT_RANGE));
    }

    public final void highlight(@NotNull PsiElement wholeAffected) {
        Intrinsics.checkNotNullParameter((Object)wholeAffected, (String)"wholeAffected");
        this.dropHighlight();
        TextRange textRange = wholeAffected.getTextRange();
        if (textRange == null) {
            return;
        }
        TextRange affectedRange = textRange;
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        Intrinsics.checkNotNull((Object)textAttributes);
        TextAttributes attributes = textAttributes;
        SelectionModel $this$highlight_u24lambda_u240 = this.editor.getSelectionModel();
        boolean bl = false;
        TextRange selectedRange = new TextRange($this$highlight_u24lambda_u240.getSelectionStart(), $this$highlight_u24lambda_u240.getSelectionEnd());
        int textLength = this.editor.getDocument().getTextLength();
        for (TextRange r : RangeSplitter.split((TextRange)affectedRange, Collections.singletonList(selectedRange))) {
            if (r.getEndOffset() > textLength) continue;
            Intrinsics.checkNotNull((Object)r);
            this.addHighlighter(r, attributes);
        }
    }

    public final void dropHighlight() {
        Iterable $this$forEach$iv = this.highlighters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter it = (RangeHighlighter)element$iv;
            boolean bl = false;
            it.dispose();
        }
        this.highlighters.clear();
    }
}

