/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.base.codeInsight;

import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.RowIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassKind;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaDeclarationSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaEnumEntrySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaLocalVariableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedClassSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaNamedFunctionSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaPropertySymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolLocation;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolModality;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbolVisibility;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeAliasSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaTypeParameterSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaValueParameterSymbol;
import org.jetbrains.kotlin.idea.KotlinIcons;
import org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0003\u0010\n\u001a\u00020\u000bR\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fJ#\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0003\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/base/codeInsight/KotlinIconProvider;", "", "<init>", "()V", "getIconFor", "Ljavax/swing/Icon;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "KaSession", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "flags", "", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;I)Ljavax/swing/Icon;", "getBaseIcon", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;)Ljavax/swing/Icon;", "getVisibilityIcon", "getIconForJavaDeclaration", "declaration", "Lcom/intellij/psi/PsiElement;", "kotlin.base.code-insight"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nKotlinIconProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinIconProvider.kt\norg/jetbrains/kotlin/idea/base/codeInsight/KotlinIconProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1#2:104\n*E\n"})
public final class KotlinIconProvider {
    @NotNull
    public static final KotlinIconProvider INSTANCE = new KotlinIconProvider();

    private KotlinIconProvider() {
    }

    @Nullable
    public final Icon getIconFor(@NotNull KaSession $context_receiver_0, @NotNull KaSymbol symbol, @Iconable.IconFlags int flags) {
        Icon visibilityIcon;
        Intrinsics.checkNotNullParameter((Object)$context_receiver_0, (String)"$context_receiver_0");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        PsiElement psiElement = symbol.getPsi();
        if (psiElement != null) {
            PsiElement referencedPsi = psiElement;
            boolean bl = false;
            if (!(referencedPsi instanceof KtElement)) {
                return INSTANCE.getIconForJavaDeclaration(referencedPsi, flags);
            }
        }
        Icon baseIcon = this.getBaseIcon($context_receiver_0, symbol);
        if ((flags & 1) != 0 && (visibilityIcon = this.getVisibilityIcon(symbol)) != null) {
            RowIcon rowIcon = new RowIcon(2, null, 2, null);
            rowIcon.setIcon(baseIcon, 0);
            rowIcon.setIcon(visibilityIcon, 1);
            return (Icon)rowIcon;
        }
        return baseIcon;
    }

    public static /* synthetic */ Icon getIconFor$default(KotlinIconProvider kotlinIconProvider, KaSession kaSession, KaSymbol kaSymbol, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return kotlinIconProvider.getIconFor(kaSession, kaSymbol, n);
    }

    private final Icon getBaseIcon(KaSession $context_receiver_0, KaSymbol symbol) {
        Icon icon2;
        if (symbol instanceof KaNamedFunctionSymbol) {
            Icon icon3;
            boolean isAbstract = ((KaNamedFunctionSymbol)symbol).getModality() == KaSymbolModality.ABSTRACT;
            boolean suspend = ((KaNamedFunctionSymbol)symbol).isSuspend();
            if (((KaNamedFunctionSymbol)symbol).isExtension()) {
                icon3 = isAbstract ? KotlinIcons.ABSTRACT_EXTENSION_FUNCTION : KotlinIcons.EXTENSION_FUNCTION;
            } else if (symbol.getLocation() == KaSymbolLocation.CLASS) {
                if (suspend) {
                    icon3 = KotlinIcons.SUSPEND_METHOD;
                } else {
                    PlatformIcons platformIcon = isAbstract ? PlatformIcons.AbstractMethod : PlatformIcons.Method;
                    icon3 = IconManager.Companion.getInstance().getPlatformIcon(platformIcon);
                }
            } else {
                icon3 = suspend ? KotlinIcons.SUSPEND_FUNCTION : KotlinIcons.FUNCTION;
            }
            return icon3;
        }
        if (symbol instanceof KaClassSymbol) {
            KaSymbol kaSymbol = symbol;
            KaNamedClassSymbol kaNamedClassSymbol = kaSymbol instanceof KaNamedClassSymbol ? (KaNamedClassSymbol)kaSymbol : null;
            boolean isAbstract = (kaNamedClassSymbol != null ? kaNamedClassSymbol.getModality() : null) == KaSymbolModality.ABSTRACT;
            return switch (WhenMappings.$EnumSwitchMapping$0[((KaClassSymbol)symbol).getClassKind().ordinal()]) {
                case 1 -> {
                    if (isAbstract) {
                        yield KotlinIcons.ABSTRACT_CLASS;
                    }
                    yield KotlinIcons.CLASS;
                }
                case 2 -> KotlinIcons.ENUM;
                case 3 -> KotlinIcons.ANNOTATION;
                case 4, 5 -> KotlinIcons.OBJECT;
                case 6 -> KotlinIcons.INTERFACE;
                case 7 -> KotlinIcons.OBJECT;
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        KaSymbol kaSymbol = symbol;
        if (kaSymbol instanceof KaValueParameterSymbol) {
            icon2 = KotlinIcons.PARAMETER;
        } else if (kaSymbol instanceof KaLocalVariableSymbol) {
            icon2 = ((KaLocalVariableSymbol)symbol).isVal() ? KotlinIcons.VAL : KotlinIcons.VAR;
        } else if (kaSymbol instanceof KaPropertySymbol) {
            icon2 = ((KaPropertySymbol)symbol).isVal() ? KotlinIcons.FIELD_VAL : KotlinIcons.FIELD_VAR;
        } else if (kaSymbol instanceof KaTypeParameterSymbol) {
            icon2 = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Class);
        } else if (kaSymbol instanceof KaTypeAliasSymbol) {
            icon2 = KotlinIcons.TYPE_ALIAS;
        } else if (kaSymbol instanceof KaEnumEntrySymbol) {
            icon2 = KotlinIcons.ENUM;
        } else if (kaSymbol instanceof KaConstructorSymbol) {
            KaDeclarationSymbol kaDeclarationSymbol = $context_receiver_0.getContainingDeclaration(symbol);
            if (kaDeclarationSymbol != null) {
                KaDeclarationSymbol it = kaDeclarationSymbol;
                boolean bl = false;
                icon2 = KotlinIconProvider.getIconFor$default(INSTANCE, $context_receiver_0, it, 0, 4, null);
            } else {
                icon2 = null;
            }
        } else {
            icon2 = null;
        }
        return icon2;
    }

    private final Icon getVisibilityIcon(KaSymbol symbol) {
        PlatformIcons platformIcons;
        Object object = symbol instanceof KaValueParameterSymbol ? (KaValueParameterSymbol)symbol : null;
        if (object == null || (object = object.getGeneratedPrimaryConstructorProperty()) == null || (object = object.getVisibility()) == null) {
            KaDeclarationSymbol kaDeclarationSymbol = symbol instanceof KaDeclarationSymbol ? (KaDeclarationSymbol)symbol : null;
            if (kaDeclarationSymbol != null) {
                object = kaDeclarationSymbol.getVisibility();
            } else {
                return null;
            }
        }
        KaValueParameterSymbol visibility2 = object;
        switch (WhenMappings.$EnumSwitchMapping$1[((Enum)((Object)visibility2)).ordinal()]) {
            case 1: {
                platformIcons = PlatformIcons.Public;
                break;
            }
            case 2: {
                platformIcons = PlatformIcons.Protected;
                break;
            }
            case 3: {
                platformIcons = PlatformIcons.Private;
                break;
            }
            case 4: {
                platformIcons = PlatformIcons.Private;
                break;
            }
            default: {
                return null;
            }
        }
        PlatformIcons id = platformIcons;
        return IconManager.Companion.getInstance().getPlatformIcon(id);
    }

    private final Icon getIconForJavaDeclaration(PsiElement declaration, @Iconable.IconFlags int flags) {
        return declaration.getIcon(flags);
    }

    static /* synthetic */ Icon getIconForJavaDeclaration$default(KotlinIconProvider kotlinIconProvider, PsiElement psiElement, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return kotlinIconProvider.getIconForJavaDeclaration(psiElement, n);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[KaClassKind.values().length];
            try {
                nArray[KaClassKind.CLASS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ENUM_CLASS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ANNOTATION_CLASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.COMPANION_OBJECT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.INTERFACE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaClassKind.ANONYMOUS_OBJECT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KaSymbolVisibility.values().length];
            try {
                nArray[KaSymbolVisibility.PUBLIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PROTECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.PRIVATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KaSymbolVisibility.INTERNAL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

