/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import java.util.HashMap;
import java.util.Map;

public enum ClassKey {
    UNKNOWN("UNKNOWN_TYPE", -1),
    BLANK("", 1),
    CLASS("class", 2),
    STRUCT("struct", 3),
    UNION("union", 4);

    private static final Map<Integer, ClassKey> BY_VALUE;
    private final String label;
    private final int value;

    public String getString() {
        return this.label;
    }

    public String toString() {
        if (this.label.length() != 0) {
            return this.label + " ";
        }
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public static ClassKey fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    private ClassKey(String label, int value) {
        this.label = label;
        this.value = value;
    }

    static {
        BY_VALUE = new HashMap<Integer, ClassKey>();
        for (ClassKey val : ClassKey.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

