/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.dnd.GenericDataFlavor;
import ghidra.app.util.SelectionTransferData;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SelectionTransferable
implements Transferable,
ClipboardOwner {
    public static DataFlavor localProgramSelectionFlavor = SelectionTransferable.createLocalProgramSelectionFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localProgramSelectionFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private SelectionTransferData selectionData;

    private static DataFlavor createLocalProgramSelectionFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=" + SelectionTransferData.class.getName(), "Local Transfer Data for Program Selections");
        }
        catch (Exception e) {
            Msg.showError(SelectionTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public SelectionTransferable(SelectionTransferData selectionData) {
        this.selectionData = selectionData;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localProgramSelectionFlavor)) {
            return this.selectionData;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "SelectionTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

