/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.AddressFieldLocation;
import ghidra.program.util.CodeUnitLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;

public class AddressLocationDescriptor
extends LocationDescriptor {
    AddressLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        this.program = program;
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(location instanceof CodeUnitLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + String.valueOf(location));
        }
        CodeUnitLocation addressLocation = (CodeUnitLocation)location;
        this.label = this.getLabelForAddress(addressLocation);
        this.homeAddress = addressLocation.getAddress();
    }

    private String getLabelForAddress(CodeUnitLocation location) {
        Address address = this.getAddressForLocation(location);
        SymbolTable symbolTable = this.program.getSymbolTable();
        Symbol symbol = symbolTable.getPrimarySymbol(address);
        if (symbol != null) {
            return symbol.getName();
        }
        if (location instanceof AddressFieldLocation) {
            return ((AddressFieldLocation)location).getAddressRepresentation();
        }
        return location.getAddress().toString();
    }

    private Address getAddressForLocation(CodeUnitLocation location) {
        Address address = location.getRefAddress();
        if (address != null) {
            return address;
        }
        return location.getAddress();
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.getReferences(accumulator, this.programLocation, monitor);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        int offset;
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            int offset2 = text.indexOf(this.label);
            if (offset2 >= 0) {
                return new Highlight[]{new Highlight(offset2, this.label.length() + offset2 - 1, highlightColor)};
            }
        } else if (LabelFieldFactory.class.isAssignableFrom(fieldFactoryClass) && currentAddress.equals((Object)this.homeAddress) && (offset = text.indexOf(this.label)) != -1) {
            return new Highlight[]{new Highlight(offset, this.label.length() + offset - 1, highlightColor)};
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

