/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class SparseAddressRangeMap<V> {
    public static final long PAGE_BITS = 12L;
    public static final long PAGE_MASK = -4096L;
    public static final long OFF_MASK = 4095L;
    private final Map<AddressSpace, Space<V>> spaces = new HashMap<AddressSpace, Space<V>>();
    private boolean isEmpty = true;

    public Map.Entry<AddressRange, V> put(AddressRange range, V value) {
        Space space = this.spaces.computeIfAbsent(range.getAddressSpace(), s -> new Space());
        Map.Entry<AddressRange, V> entry = space.put(Map.entry(range, value));
        this.isEmpty = false;
        return entry;
    }

    public boolean hasEntry(Address address, Predicate<V> predicate) {
        Space<V> space = this.spaces.get(address.getAddressSpace());
        if (space == null) {
            return false;
        }
        return space.hasEntry(address, predicate);
    }

    public void clear() {
        this.spaces.clear();
        this.isEmpty = true;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    private static class Space<V> {
        private final Map<Long, Page<V>> pages = new HashMap<Long, Page<V>>();

        private Space() {
        }

        private static long getPageIndex(Address addr) {
            return addr.getOffset() >> 12;
        }

        Map.Entry<AddressRange, V> put(Map.Entry<AddressRange, V> entry) {
            AddressRange range = entry.getKey();
            long indexMin = Space.getPageIndex(range.getMinAddress());
            Page pageMin = this.pages.computeIfAbsent(indexMin, o -> new Page());
            pageMin.put(entry);
            long indexMax = Space.getPageIndex(range.getMaxAddress());
            if (indexMax == indexMin) {
                return entry;
            }
            Page pageMax = this.pages.computeIfAbsent(indexMax, o -> new Page());
            return pageMax.put(entry);
        }

        boolean hasEntry(Address address, Predicate<V> predicate) {
            Page<V> page = this.pages.get(Space.getPageIndex(address));
            if (page == null) {
                return false;
            }
            return page.hasEntry(address, predicate);
        }
    }

    private static class Page<V> {
        static final Comparator<Map.Entry<AddressRange, ?>> ENTRY_COMPARATOR = Page::compareEntries;
        private final List<Map.Entry<AddressRange, V>> entries = new ArrayList<Map.Entry<AddressRange, V>>();

        private Page() {
        }

        private static int compareEntries(Map.Entry<AddressRange, ?> e1, Map.Entry<AddressRange, ?> e2) {
            return e1.getKey().getMinAddress().compareTo((Object)e2.getKey().getMinAddress());
        }

        Map.Entry<AddressRange, V> put(Map.Entry<AddressRange, V> entry) {
            int index = Collections.binarySearch(this.entries, entry, ENTRY_COMPARATOR);
            if (index < 0) {
                index = -index - 1;
            }
            this.entries.add(index, entry);
            return entry;
        }

        boolean hasEntry(Address address, Predicate<V> predicate) {
            for (Map.Entry<AddressRange, V> ent : this.entries) {
                AddressRange range = ent.getKey();
                if (range.contains(address)) {
                    if (!predicate.test(ent.getValue())) continue;
                    return true;
                }
                if (address.compareTo((Object)range.getMinAddress()) >= 0) continue;
                return false;
            }
            return false;
        }
    }
}

