/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.Handle;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class HandleDataStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_HANDLE_DATA";
    private int sizeOfHeader;
    private int sizeOfDescriptor;
    private int numberOfHandles;
    private Handle[] handles;
    private DumpFileReader reader;
    private long index;

    HandleDataStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSizeOfHeader(this.reader.readNextInt());
        this.setSizeOfDescriptor(this.reader.readNextInt());
        this.setNumberOfHandles(this.reader.readNextInt());
        this.reader.readNextInt();
        this.handles = new Handle[this.numberOfHandles];
        for (int i = 0; i < this.numberOfHandles; ++i) {
            this.setHandle(new Handle(this.reader, this.reader.getPointerIndex(), this.sizeOfDescriptor), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "SizeOfHeader", null);
        struct.add(DWORD, 4, "SizeOfDescriptor", null);
        struct.add(DWORD, 4, "NumberOfHandles", null);
        struct.add(DWORD, 4, "Reserved", null);
        DataType t = this.handles[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfHandles, t.getLength());
        struct.add((DataType)a, a.getLength(), "Handles", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getNumberOfHandles() {
        return this.numberOfHandles;
    }

    public void setNumberOfHandles(int numberOfHandles) {
        this.numberOfHandles = numberOfHandles;
    }

    public Handle getHandle(int idx) {
        return this.handles[idx];
    }

    public void setHandle(Handle handle, int index) {
        this.handles[index] = handle;
    }

    public void setSizeOfHeader(int sizeOfHeader) {
        this.sizeOfHeader = sizeOfHeader;
    }

    public int getSizeOfHeader() {
        return this.sizeOfHeader;
    }

    public void setSizeOfDescriptor(int sizeOfDescriptor) {
        this.sizeOfDescriptor = sizeOfDescriptor;
    }

    public int getSizeOfDescriptor() {
        return this.sizeOfDescriptor;
    }
}

