/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.client.tracermi;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import ghidra.util.Msg;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class ProtobufSocket<T extends AbstractMessage> {
    private final ByteBuffer lenSend = ByteBuffer.allocate(4);
    private final ByteBuffer lenRecv = ByteBuffer.allocate(4);
    private final SocketChannel channel;
    private final Decoder<T> decoder;

    public ProtobufSocket(SocketChannel channel, Decoder<T> decoder) {
        this.channel = channel;
        this.decoder = decoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(T msg) throws IOException {
        ByteBuffer byteBuffer = this.lenSend;
        synchronized (byteBuffer) {
            this.lenSend.clear();
            this.lenSend.putInt(msg.getSerializedSize());
            this.lenSend.flip();
            this.channel.write(this.lenSend);
            for (ByteBuffer buf : msg.toByteString().asReadOnlyByteBufferList()) {
                this.channel.write(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T recv() throws IOException {
        ByteBuffer byteBuffer = this.lenRecv;
        synchronized (byteBuffer) {
            this.lenRecv.clear();
            while (this.lenRecv.hasRemaining()) {
                this.channel.read(this.lenRecv);
            }
            this.lenRecv.flip();
            int len = this.lenRecv.getInt();
            ByteBuffer buf = ByteBuffer.allocate(len);
            while (buf.hasRemaining()) {
                this.channel.read(buf);
            }
            buf.flip();
            return (T)((AbstractMessage)this.decoder.decode(buf));
        }
    }

    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Unable to close ProtobufSocket");
        }
    }

    public String getRemoteAddress() {
        try {
            return this.channel.getRemoteAddress().toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static interface Decoder<T> {
        public T decode(ByteBuffer var1) throws InvalidProtocolBufferException;
    }
}

