/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.ColorValue;
import generic.theme.FontValue;
import generic.theme.GTheme;
import generic.theme.IconValue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ThemeWriter {
    static final String THEME_NAME_KEY = "name";
    static final String THEME_LOOK_AND_FEEL_KEY = "lookAndFeel";
    static final String THEME_USE_DARK_DEFAULTS = "useDarkDefaults";
    protected GTheme theme;

    public ThemeWriter(GTheme theme) {
        this.theme = theme;
    }

    public void writeTheme(File file, boolean asZip) throws IOException {
        if (asZip) {
            this.writeThemeToZipFile(file);
        } else {
            this.writeThemeToFile(file);
        }
    }

    public void writeThemeToFile(File file) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.writeThemeValues(writer);
        }
    }

    public void writeThemeToZipFile(File file) throws IOException {
        String dir = this.theme.getName() + ".theme/";
        try (FileOutputStream fos = new FileOutputStream(file);){
            ZipOutputStream zos = new ZipOutputStream(fos);
            this.saveThemeFileToZip(dir, zos);
            Set<File> iconFiles = this.theme.getExternalIconFiles();
            for (File iconFile : iconFiles) {
                this.copyToZipFile(dir, iconFile, zos);
            }
            zos.finish();
        }
    }

    protected void writeThemeValues(BufferedWriter writer) throws IOException {
        List<ColorValue> colors = this.theme.getColors();
        Collections.sort(colors);
        List<FontValue> fonts = this.theme.getFonts();
        Collections.sort(fonts);
        List<IconValue> icons = this.theme.getIcons();
        Collections.sort(icons);
        writer.write("name = " + this.theme.getName());
        writer.newLine();
        writer.write("lookAndFeel = " + this.theme.getLookAndFeelType().getName());
        writer.newLine();
        writer.write("useDarkDefaults = " + this.theme.useDarkDefaults());
        writer.newLine();
        for (ColorValue colorValue : colors) {
            writer.write(colorValue.getSerializationString());
            writer.newLine();
        }
        for (FontValue fontValue : fonts) {
            writer.write(fontValue.getSerializationString());
            writer.newLine();
        }
        for (IconValue iconValue : icons) {
            writer.write(iconValue.getSerializationString());
            writer.newLine();
        }
    }

    private void copyToZipFile(String dir, File iconFile, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(dir + "images/" + iconFile.getName());
        zos.putNextEntry(entry);
        Files.copy(iconFile.toPath(), zos);
    }

    private void saveThemeFileToZip(String dir, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(dir + this.theme.getName() + ".theme");
        zos.putNextEntry(entry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zos));
        this.writeThemeValues(writer);
        writer.flush();
    }
}

