/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results.apply;

import ghidra.features.bsim.gui.search.results.BSimApplyResult;
import ghidra.features.bsim.gui.search.results.BSimMatchResult;
import ghidra.features.bsim.gui.search.results.BSimResultStatus;
import ghidra.features.bsim.gui.search.results.apply.AbstractBSimApplyTask;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.FunctionUtility;
import java.util.List;

public class NameAndNamespaceBSimApplyTask
extends AbstractBSimApplyTask {
    public NameAndNamespaceBSimApplyTask(Program program, List<BSimMatchResult> results, ServiceProvider serviceProvider) {
        super(program, "Function Name", results, serviceProvider);
    }

    @Override
    protected boolean hasSameApplyData(List<Function> functions) {
        String name = functions.get(0).getName(true);
        for (int i = 1; i < functions.size(); ++i) {
            if (functions.get(i).getName(true).equals(name)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected BSimApplyResult apply(Function target, Function source) {
        String sourceFullName;
        String defaultFunctionName = SymbolUtilities.getDefaultFunctionName((Address)source.getEntryPoint());
        if (defaultFunctionName.equals(source.getName())) {
            return new BSimApplyResult(target, source, BSimResultStatus.ERROR, "Can't apply default function names");
        }
        String targetFullName = target.getName(true);
        if (targetFullName.equals(sourceFullName = source.getName(true))) {
            return new BSimApplyResult(target, source, BSimResultStatus.IGNORED, "Functions already have the same name");
        }
        try {
            FunctionUtility.applyNameAndNamespace((Function)target, (Function)source);
        }
        catch (Exception e) {
            return new BSimApplyResult(target, source, BSimResultStatus.ERROR, "Rename failed (" + e.getMessage() + ")");
        }
        return new BSimApplyResult(target, source, BSimResultStatus.NAME_APPLIED, "");
    }
}

