/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.SatelliteVisualizationViewer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;

public class SatelliteRotatingGraphMousePlugin
extends RotatingGraphMousePlugin {
    public SatelliteRotatingGraphMousePlugin() {
    }

    public SatelliteRotatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.down == null) {
            return;
        }
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            if (vv instanceof SatelliteVisualizationViewer) {
                VisualizationViewer vvMaster = ((SatelliteVisualizationViewer)vv).getMaster();
                MutableTransformer modelTransformerMaster = vvMaster.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT);
                vv.setCursor(this.cursor);
                Point2D center = vv.getRenderContext().getMultiLayerTransformer().transform(vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(vvMaster.getCenter()));
                Point q = this.down;
                Point p = e.getPoint();
                Point2D.Double v1 = new Point2D.Double(center.getX() - ((Point2D)p).getX(), center.getY() - ((Point2D)p).getY());
                Point2D.Double v2 = new Point2D.Double(center.getX() - ((Point2D)q).getX(), center.getY() - ((Point2D)q).getY());
                double theta = this.angleBetween(v1, v2);
                modelTransformerMaster.rotate(-theta, vvMaster.getRenderContext().getMultiLayerTransformer().inverseTransform(Layer.VIEW, vvMaster.getCenter()));
                this.down.x = e.getX();
                this.down.y = e.getY();
            }
            e.consume();
        }
    }
}

