/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;
import javax.help.UnsupportedOperationException;

class CompositeDBAdapterV5V6
extends CompositeDBAdapter {
    static final int V5_VERSION = 5;
    static final int VERSION = 6;
    static final int V5V6_COMPOSITE_NAME_COL = 0;
    static final int V5V6_COMPOSITE_COMMENT_COL = 1;
    static final int V5V6_COMPOSITE_IS_UNION_COL = 2;
    static final int V5V6_COMPOSITE_CAT_COL = 3;
    static final int V5V6_COMPOSITE_LENGTH_COL = 4;
    static final int V5V6_COMPOSITE_ALIGNMENT_COL = 5;
    static final int V5V6_COMPOSITE_NUM_COMPONENTS_COL = 6;
    static final int V5V6_COMPOSITE_SOURCE_ARCHIVE_ID_COL = 7;
    static final int V5V6_COMPOSITE_UNIVERSAL_DT_ID_COL = 8;
    static final int V5V6_COMPOSITE_SOURCE_SYNC_TIME_COL = 9;
    static final int V5V6_COMPOSITE_LAST_CHANGE_TIME_COL = 10;
    static final int V5V6_COMPOSITE_PACK_COL = 11;
    static final int V5V6_COMPOSITE_MIN_ALIGN_COL = 12;
    static final Schema V5V6_COMPOSITE_SCHEMA = new Schema(6, "Data Type ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, BooleanField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE}, new String[]{"Name", "Comment", "Is Union", "Category ID", "Length", "Alignment", "Number Of Components", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time", "Pack", "MinAlign"});
    private Table compositeTable;

    CompositeDBAdapterV5V6(DBHandle handle, OpenMode openMode, String tablePrefix) throws VersionException, IOException {
        String tableName = tablePrefix + "Composite Data Types";
        if (openMode == OpenMode.CREATE) {
            this.compositeTable = handle.createTable(tableName, V5V6_COMPOSITE_SCHEMA, new int[]{3, 8});
        } else {
            this.compositeTable = handle.getTable(tableName);
            if (this.compositeTable == null) {
                throw new VersionException("Missing Table: " + tableName);
            }
            int version = this.compositeTable.getSchema().getVersion();
            if (version != 6) {
                if (version == 5 && openMode == OpenMode.IMMUTABLE) {
                    return;
                }
                throw new VersionException(version < 6);
            }
        }
    }

    @Override
    int getVersion() {
        return this.compositeTable.getSchema().getVersion();
    }

    @Override
    public int getRecordCount() {
        return this.compositeTable.getRecordCount();
    }

    @Override
    DBRecord createRecord(String name, String comments, boolean isUnion, long categoryID, int length, int computedAlignment, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime, int packValue, int minAlignment) throws IOException {
        if (this.compositeTable.getSchema().getVersion() == 5) {
            throw new UnsupportedOperationException();
        }
        if (packValue < 0) {
            packValue = -1;
        } else {
            length = 0;
        }
        long key = DataTypeManagerDB.createKey(1, this.compositeTable.getKey());
        DBRecord record = CompositeDBAdapter.COMPOSITE_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, comments);
        record.setBooleanValue(2, isUnion);
        record.setLongValue(3, categoryID);
        record.setIntValue(4, length);
        record.setIntValue(5, computedAlignment);
        record.setIntValue(6, length);
        record.setLongValue(7, sourceArchiveID);
        record.setLongValue(8, sourceDataTypeID);
        record.setLongValue(9, lastChangeTime);
        record.setLongValue(10, lastChangeTime);
        record.setIntValue(11, packValue);
        record.setIntValue(12, minAlignment);
        this.compositeTable.putRecord(record);
        return record;
    }

    @Override
    DBRecord getRecord(long dataTypeID) throws IOException {
        return this.compositeTable.getRecord(dataTypeID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.compositeTable.iterator();
    }

    @Override
    void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        if (this.compositeTable.getSchema().getVersion() == 5) {
            throw new UnsupportedOperationException();
        }
        if (setLastChangeTime) {
            record.setLongValue(10, new Date().getTime());
        }
        this.compositeTable.putRecord(record);
    }

    @Override
    boolean removeRecord(long compositeID) throws IOException {
        if (this.compositeTable.getSchema().getVersion() == 5) {
            throw new UnsupportedOperationException();
        }
        return this.compositeTable.deleteRecord(compositeID);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(this.compositeTable.getName());
    }

    @Override
    Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(archiveID), 7);
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        Field[] keys;
        for (Field key : keys = this.compositeTable.findRecords((Field)new LongField(datatypeID.getValue()), 8)) {
            DBRecord record = this.compositeTable.getRecord(key);
            if (record.getLongValue(7) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

