/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

public class BorderWidthAndBorderWidthMatchesEdgeControlGroup
implements ControlGroup {
    private static final String BORDER_WIDTH_MATCHES_EDGE_WIDTH = "border_width_matches_edge_width";
    private static final String BORDER_WIDTH = "border_width";
    private static final String THINNEST_TEXT = TextUtils.getText((String)"thinnest");
    private RevertingProperty mSetBorderWidthMatchesEdgeWidth;
    private BooleanProperty mBorderWidthMatchesEdgeWidth;
    private RevertingProperty mSetBorderWidth;
    private QuantityProperty<LengthUnit> mBorderWidth;
    private BorderWidthMatchesEdgeWidthListener borderWidthMatchesEdgeChangeListener;
    private BorderWidthListener borderWidthListener;
    private boolean canEdit;

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.addBorderWidthControl(formBuilder);
        this.addBorderWidthMatchesEdgeWidthControl(formBuilder);
    }

    private void addBorderWidthControl(DefaultFormBuilder formBuilder) {
        this.mSetBorderWidth = new RevertingProperty();
        this.mBorderWidth = new QuantityProperty(BORDER_WIDTH, 0.0, 100000.0, 0.1, (Enum)LengthUnit.px);
        this.mBorderWidth.configureMinimumName(THINNEST_TEXT);
        this.borderWidthListener = new BorderWidthListener(this.mSetBorderWidth, (IPropertyControl)this.mBorderWidth);
        this.mSetBorderWidth.addPropertyChangeListener(this.borderWidthListener);
        this.mBorderWidth.addPropertyChangeListener((PropertyChangeListener)this.borderWidthListener);
        this.mBorderWidth.appendToForm(formBuilder);
        this.mSetBorderWidth.appendToForm(formBuilder);
    }

    public void addBorderWidthMatchesEdgeWidthControl(DefaultFormBuilder formBuilder) {
        this.mSetBorderWidthMatchesEdgeWidth = new RevertingProperty();
        this.mBorderWidthMatchesEdgeWidth = new BooleanProperty(BORDER_WIDTH_MATCHES_EDGE_WIDTH);
        this.borderWidthMatchesEdgeChangeListener = new BorderWidthMatchesEdgeWidthListener(this.mSetBorderWidthMatchesEdgeWidth, (IPropertyControl)this.mBorderWidthMatchesEdgeWidth);
        this.mSetBorderWidthMatchesEdgeWidth.addPropertyChangeListener(this.borderWidthMatchesEdgeChangeListener);
        this.mBorderWidthMatchesEdgeWidth.addPropertyChangeListener((PropertyChangeListener)this.borderWidthMatchesEdgeChangeListener);
        this.mBorderWidthMatchesEdgeWidth.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.enableOrDisableBorderWidthControls();
            }
        });
        this.mBorderWidthMatchesEdgeWidth.appendToForm(formBuilder);
        this.mSetBorderWidthMatchesEdgeWidth.appendToForm(formBuilder);
    }

    public void enableOrDisableBorderWidthControls() {
        boolean borderWidthCanBeSet = !this.mBorderWidthMatchesEdgeWidth.getBooleanValue();
        this.mSetBorderWidth.setEnabled(borderWidthCanBeSet && this.canEdit);
        this.mBorderWidth.setEnabled(borderWidthCanBeSet && this.canEdit);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.canEdit = canEdit;
        this.borderWidthListener.setStyle(node);
        this.borderWidthMatchesEdgeChangeListener.setStyle(node);
    }

    private class BorderWidthListener
    extends ControlGroupChangeListener {
        public BorderWidthListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBorderWidth(node, enabled ? BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidth.getQuantifiedValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeBorderModel nodeBorderModel = NodeBorderModel.getModel((NodeModel)node);
            Quantity width = nodeBorderModel != null ? nodeBorderModel.getBorderWidth() : null;
            Quantity viewWidth = styleController.getBorderWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mSetBorderWidth.setValue(width != null);
            BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidth.setQuantifiedValue(viewWidth);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mSetBorderWidth);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidth);
            if (!MapStyleModel.isStyleNode((NodeModel)node) || BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidth.isEnabled()) {
                BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.enableOrDisableBorderWidthControls();
            }
        }
    }

    private class BorderWidthMatchesEdgeWidthListener
    extends ControlGroupChangeListener {
        public BorderWidthMatchesEdgeWidthListener(RevertingProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setBorderWidthMatchesEdgeWidth(node, enabled ? Boolean.valueOf(BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidthMatchesEdgeWidth.getBooleanValue()) : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeStyleController styleController = NodeStyleController.getController();
            NodeBorderModel nodeBorderModel = NodeBorderModel.getModel((NodeModel)node);
            Boolean match = nodeBorderModel != null ? nodeBorderModel.getBorderWidthMatchesEdgeWidth() : null;
            Boolean viewMatch = styleController.getBorderWidthMatchesEdgeWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mSetBorderWidthMatchesEdgeWidth.setValue(match != null);
            BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidthMatchesEdgeWidth.setValue(viewMatch.booleanValue());
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mSetBorderWidthMatchesEdgeWidth);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidthMatchesEdgeWidth);
            if (!MapStyleModel.isStyleNode((NodeModel)node) || BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.mBorderWidthMatchesEdgeWidth.isEnabled()) {
                BorderWidthAndBorderWidthMatchesEdgeControlGroup.this.enableOrDisableBorderWidthControls();
            }
        }
    }
}

