/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.json;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jkiss.dbeaver.ui.editors.json.JSONPartitionScanner;
import org.jkiss.dbeaver.ui.editors.json.JSONSourceViewerConfiguration;
import org.jkiss.dbeaver.ui.editors.text.BaseTextEditor;
import org.jkiss.dbeaver.ui.editors.text.FileRefDocumentProvider;

public class JSONTextEditor
extends BaseTextEditor {
    private static final char[] PAIRS = new char[]{'{', '}', '[', ']'};
    private DefaultCharacterPairMatcher pairsMatcher = new DefaultCharacterPairMatcher(PAIRS);
    private ProjectionSupport projectionSupport;

    public JSONTextEditor() {
        this.setDocumentProvider((IDocumentProvider)new FileRefDocumentProvider());
    }

    public void dispose() {
        if (this.pairsMatcher != null) {
            this.pairsMatcher.dispose();
            this.pairsMatcher = null;
        }
        super.dispose();
    }

    public void doRevertToSaved() {
        super.doRevertToSaved();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    public void doSaveAs() {
        super.doSaveAs();
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.setupDocument();
    }

    private void setupDocument() {
        IDocument document = this.getDocument();
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new JSONPartitionScanner(), new String[]{"__json_string"});
            partitioner.connect(document);
            ((IDocumentExtension3)document).setDocumentPartitioner("__json_partitioning", (IDocumentPartitioner)partitioner);
        }
    }

    public void createPartControl(Composite parent) {
        this.setSourceViewerConfiguration(new JSONSourceViewerConfiguration(this));
        super.createPartControl(parent);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, null, false, styles);
        return viewer;
    }
}

