﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 */
class GetOTAUpdateRequest : public IoTRequest {
 public:
  AWS_IOT_API GetOTAUpdateRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetOTAUpdate"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The OTA update ID.</p>
   */
  inline const Aws::String& GetOtaUpdateId() const { return m_otaUpdateId; }
  inline bool OtaUpdateIdHasBeenSet() const { return m_otaUpdateIdHasBeenSet; }
  template <typename OtaUpdateIdT = Aws::String>
  void SetOtaUpdateId(OtaUpdateIdT&& value) {
    m_otaUpdateIdHasBeenSet = true;
    m_otaUpdateId = std::forward<OtaUpdateIdT>(value);
  }
  template <typename OtaUpdateIdT = Aws::String>
  GetOTAUpdateRequest& WithOtaUpdateId(OtaUpdateIdT&& value) {
    SetOtaUpdateId(std::forward<OtaUpdateIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_otaUpdateId;
  bool m_otaUpdateIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
