﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/backup/Backup_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Backup {
namespace Model {

/**
 * <p>This contains metadata about a restore testing selection.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/RestoreTestingSelectionForList">AWS
 * API Reference</a></p>
 */
class RestoreTestingSelectionForList {
 public:
  AWS_BACKUP_API RestoreTestingSelectionForList() = default;
  AWS_BACKUP_API RestoreTestingSelectionForList(Aws::Utils::Json::JsonView jsonValue);
  AWS_BACKUP_API RestoreTestingSelectionForList& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_BACKUP_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date and time that a restore testing selection was created, in Unix
   * format and Coordinated Universal Time (UTC). The value of
   * <code>CreationTime</code> is accurate to milliseconds. For example, the value
   * 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  RestoreTestingSelectionForList& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the
   * target resource; for example:
   * <code>arn:aws:iam::123456789012:role/S3Access</code>.</p>
   */
  inline const Aws::String& GetIamRoleArn() const { return m_iamRoleArn; }
  inline bool IamRoleArnHasBeenSet() const { return m_iamRoleArnHasBeenSet; }
  template <typename IamRoleArnT = Aws::String>
  void SetIamRoleArn(IamRoleArnT&& value) {
    m_iamRoleArnHasBeenSet = true;
    m_iamRoleArn = std::forward<IamRoleArnT>(value);
  }
  template <typename IamRoleArnT = Aws::String>
  RestoreTestingSelectionForList& WithIamRoleArn(IamRoleArnT&& value) {
    SetIamRoleArn(std::forward<IamRoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of Amazon Web Services resource included in a restore testing
   * selection; for example, an Amazon EBS volume or an Amazon RDS database.</p>
   */
  inline const Aws::String& GetProtectedResourceType() const { return m_protectedResourceType; }
  inline bool ProtectedResourceTypeHasBeenSet() const { return m_protectedResourceTypeHasBeenSet; }
  template <typename ProtectedResourceTypeT = Aws::String>
  void SetProtectedResourceType(ProtectedResourceTypeT&& value) {
    m_protectedResourceTypeHasBeenSet = true;
    m_protectedResourceType = std::forward<ProtectedResourceTypeT>(value);
  }
  template <typename ProtectedResourceTypeT = Aws::String>
  RestoreTestingSelectionForList& WithProtectedResourceType(ProtectedResourceTypeT&& value) {
    SetProtectedResourceType(std::forward<ProtectedResourceTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unique string that is the name of the restore testing plan.</p> <p>The name
   * cannot be changed after creation. The name must consist of only alphanumeric
   * characters and underscores. Maximum length is 50.</p>
   */
  inline const Aws::String& GetRestoreTestingPlanName() const { return m_restoreTestingPlanName; }
  inline bool RestoreTestingPlanNameHasBeenSet() const { return m_restoreTestingPlanNameHasBeenSet; }
  template <typename RestoreTestingPlanNameT = Aws::String>
  void SetRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    m_restoreTestingPlanNameHasBeenSet = true;
    m_restoreTestingPlanName = std::forward<RestoreTestingPlanNameT>(value);
  }
  template <typename RestoreTestingPlanNameT = Aws::String>
  RestoreTestingSelectionForList& WithRestoreTestingPlanName(RestoreTestingPlanNameT&& value) {
    SetRestoreTestingPlanName(std::forward<RestoreTestingPlanNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Unique name of a restore testing selection.</p> <p>The name consists of only
   * alphanumeric characters and underscores. Maximum length is 50.</p>
   */
  inline const Aws::String& GetRestoreTestingSelectionName() const { return m_restoreTestingSelectionName; }
  inline bool RestoreTestingSelectionNameHasBeenSet() const { return m_restoreTestingSelectionNameHasBeenSet; }
  template <typename RestoreTestingSelectionNameT = Aws::String>
  void SetRestoreTestingSelectionName(RestoreTestingSelectionNameT&& value) {
    m_restoreTestingSelectionNameHasBeenSet = true;
    m_restoreTestingSelectionName = std::forward<RestoreTestingSelectionNameT>(value);
  }
  template <typename RestoreTestingSelectionNameT = Aws::String>
  RestoreTestingSelectionForList& WithRestoreTestingSelectionName(RestoreTestingSelectionNameT&& value) {
    SetRestoreTestingSelectionName(std::forward<RestoreTestingSelectionNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>This value represents the time, in hours, data is retained after a restore
   * test so that optional validation can be completed.</p> <p>Accepted value is an
   * integer between 0 and 168 (the hourly equivalent of seven days).</p>
   */
  inline int GetValidationWindowHours() const { return m_validationWindowHours; }
  inline bool ValidationWindowHoursHasBeenSet() const { return m_validationWindowHoursHasBeenSet; }
  inline void SetValidationWindowHours(int value) {
    m_validationWindowHoursHasBeenSet = true;
    m_validationWindowHours = value;
  }
  inline RestoreTestingSelectionForList& WithValidationWindowHours(int value) {
    SetValidationWindowHours(value);
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};

  Aws::String m_iamRoleArn;

  Aws::String m_protectedResourceType;

  Aws::String m_restoreTestingPlanName;

  Aws::String m_restoreTestingSelectionName;

  int m_validationWindowHours{0};
  bool m_creationTimeHasBeenSet = false;
  bool m_iamRoleArnHasBeenSet = false;
  bool m_protectedResourceTypeHasBeenSet = false;
  bool m_restoreTestingPlanNameHasBeenSet = false;
  bool m_restoreTestingSelectionNameHasBeenSet = false;
  bool m_validationWindowHoursHasBeenSet = false;
};

}  // namespace Model
}  // namespace Backup
}  // namespace Aws
