﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2Request.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/OptedOutFilter.h>

#include <utility>

namespace Aws {
namespace PinpointSMSVoiceV2 {
namespace Model {

/**
 */
class DescribeOptedOutNumbersRequest : public PinpointSMSVoiceV2Request {
 public:
  AWS_PINPOINTSMSVOICEV2_API DescribeOptedOutNumbersRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeOptedOutNumbers"; }

  AWS_PINPOINTSMSVOICEV2_API Aws::String SerializePayload() const override;

  AWS_PINPOINTSMSVOICEV2_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The OptOutListName or OptOutListArn of the OptOutList. You can use
   * <a>DescribeOptOutLists</a> to find the values for OptOutListName and
   * OptOutListArn.</p>  <p>If you are using a shared AWS End User
   * Messaging SMS and Voice resource then you must use the full Amazon Resource
   * Name(ARN).</p>
   */
  inline const Aws::String& GetOptOutListName() const { return m_optOutListName; }
  inline bool OptOutListNameHasBeenSet() const { return m_optOutListNameHasBeenSet; }
  template <typename OptOutListNameT = Aws::String>
  void SetOptOutListName(OptOutListNameT&& value) {
    m_optOutListNameHasBeenSet = true;
    m_optOutListName = std::forward<OptOutListNameT>(value);
  }
  template <typename OptOutListNameT = Aws::String>
  DescribeOptedOutNumbersRequest& WithOptOutListName(OptOutListNameT&& value) {
    SetOptOutListName(std::forward<OptOutListNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of phone numbers to search for in the OptOutList.</p> <p>If you
   * specify an opted out number that isn't valid, an exception is returned.</p>
   */
  inline const Aws::Vector<Aws::String>& GetOptedOutNumbers() const { return m_optedOutNumbers; }
  inline bool OptedOutNumbersHasBeenSet() const { return m_optedOutNumbersHasBeenSet; }
  template <typename OptedOutNumbersT = Aws::Vector<Aws::String>>
  void SetOptedOutNumbers(OptedOutNumbersT&& value) {
    m_optedOutNumbersHasBeenSet = true;
    m_optedOutNumbers = std::forward<OptedOutNumbersT>(value);
  }
  template <typename OptedOutNumbersT = Aws::Vector<Aws::String>>
  DescribeOptedOutNumbersRequest& WithOptedOutNumbers(OptedOutNumbersT&& value) {
    SetOptedOutNumbers(std::forward<OptedOutNumbersT>(value));
    return *this;
  }
  template <typename OptedOutNumbersT = Aws::String>
  DescribeOptedOutNumbersRequest& AddOptedOutNumbers(OptedOutNumbersT&& value) {
    m_optedOutNumbersHasBeenSet = true;
    m_optedOutNumbers.emplace_back(std::forward<OptedOutNumbersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of OptedOutFilter objects to filter the results on.</p>
   */
  inline const Aws::Vector<OptedOutFilter>& GetFilters() const { return m_filters; }
  inline bool FiltersHasBeenSet() const { return m_filtersHasBeenSet; }
  template <typename FiltersT = Aws::Vector<OptedOutFilter>>
  void SetFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters = std::forward<FiltersT>(value);
  }
  template <typename FiltersT = Aws::Vector<OptedOutFilter>>
  DescribeOptedOutNumbersRequest& WithFilters(FiltersT&& value) {
    SetFilters(std::forward<FiltersT>(value));
    return *this;
  }
  template <typename FiltersT = OptedOutFilter>
  DescribeOptedOutNumbersRequest& AddFilters(FiltersT&& value) {
    m_filtersHasBeenSet = true;
    m_filters.emplace_back(std::forward<FiltersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to be used for the next set of paginated results. You don't need to
   * supply a value for this field in the initial request.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeOptedOutNumbersRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of results to return per each request.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline DescribeOptedOutNumbersRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_optOutListName;
  bool m_optOutListNameHasBeenSet = false;

  Aws::Vector<Aws::String> m_optedOutNumbers;
  bool m_optedOutNumbersHasBeenSet = false;

  Aws::Vector<OptedOutFilter> m_filters;
  bool m_filtersHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
