\name{ProjectedLandweberDeconvolutionImageFilter}
\alias{ProjectedLandweberDeconvolutionImageFilter}
\title{ProjectedLandweberDeconvolutionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Deconvolve an image using the projected Landweber deconvolution
algorithm.
ProjectedLandweberDeconvolutionImageFilter}
\details{
This filter performs the same calculation per iteration as the LandweberDeconvolutionImageFilter . However, at each iteration, negative pixels in the intermediate
result are projected (set) to zero. This is useful if the solution is
assumed to always be non-negative, which is the case when dealing with
images formed by counting photons, for example.
This code was adapted from the Insight Journal contribution:
"Deconvolution: infrastructure and reference algorithms" by Gaetan
Lehmann https://www.insight-journal.org/browse/publication/753
Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France
Cory Quammen, The University of North Carolina at Chapel Hill
See:
IterativeDeconvolutionImageFilter
RichardsonLucyDeconvolutionImageFilter
LandweberDeconvolutionImageFilter
ProjectedLandweberDeconvolution for the procedural interface
itk::ProjectedLandweberDeconvolutionImageFilter for the Doxygen on the original ITK class.
ProjectedLandweberDeconvolutionImageFilter}
%C++ includes: sitkProjectedLandweberDeconvolutionImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1, const Image &image2):}{
Execute the filter on the input images
}
\item{double GetAlpha() const:}{
Get the relaxation factor.
}
\item{BoundaryConditionType GetBoundaryCondition() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetNormalize() const:}{}
\item{int GetNumberOfIterations() const:}{
Get the number of iterations.
}
\item{OutputRegionModeType GetOutputRegionMode() const:}{}
\item{Self NormalizeOff():}{}
\item{Self NormalizeOn():}{
Set the value of Normalize to true or false respectfully.
}
\item{ ProjectedLandweberDeconvolutionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetAlpha(double Alpha):}{
Set the relaxation factor.
}
\item{Self SetBoundaryCondition(BoundaryConditionType BoundaryCondition):}{}
\item{Self SetNormalize(bool Normalize):}{
Normalize the output image by the sum of the kernel components
}
\item{Self SetNumberOfIterations(int NumberOfIterations):}{
Set the number of iterations.
}
\item{Self SetOutputRegionMode(OutputRegionModeType OutputRegionMode):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ProjectedLandweberDeconvolutionImageFilter():}{
Destructor
}
}
}
