/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ism;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.ism.ActionAlias;
import org.opensearch.client.opensearch.ism.ActionAllocation;
import org.opensearch.client.opensearch.ism.ActionClose;
import org.opensearch.client.opensearch.ism.ActionDelete;
import org.opensearch.client.opensearch.ism.ActionForceMerge;
import org.opensearch.client.opensearch.ism.ActionIndexPriority;
import org.opensearch.client.opensearch.ism.ActionOpen;
import org.opensearch.client.opensearch.ism.ActionReadOnly;
import org.opensearch.client.opensearch.ism.ActionReadWrite;
import org.opensearch.client.opensearch.ism.ActionReplicaCount;
import org.opensearch.client.opensearch.ism.ActionRetry;
import org.opensearch.client.opensearch.ism.ActionRollover;
import org.opensearch.client.opensearch.ism.ActionSnapshot;
import org.opensearch.client.opensearch.ism.ActionTimeout;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class Action
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, Action> {
    @Nullable
    private final ActionAlias alias;
    @Nullable
    private final ActionAllocation allocation;
    @Nullable
    private final ActionClose close;
    @Nonnull
    private final Map<String, JsonData> custom;
    @Nullable
    private final ActionDelete delete;
    @Nullable
    private final ActionForceMerge forceMerge;
    @Nullable
    private final ActionIndexPriority indexPriority;
    @Nonnull
    private final Map<String, JsonData> notification;
    @Nullable
    private final ActionOpen open;
    @Nullable
    private final ActionReadOnly readOnly;
    @Nullable
    private final ActionReadWrite readWrite;
    @Nullable
    private final ActionReplicaCount replicaCount;
    @Nullable
    private final ActionRetry retry;
    @Nullable
    private final ActionRollover rollover;
    @Nonnull
    private final Map<String, JsonData> rollup;
    @Nonnull
    private final Map<String, JsonData> shrink;
    @Nullable
    private final ActionSnapshot snapshot;
    @Nullable
    private final ActionTimeout timeout;
    @Nonnull
    private final Map<String, JsonData> transform;
    public static final JsonpDeserializer<Action> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Action::setupActionDeserializer);

    private Action(Builder builder) {
        this.alias = builder.alias;
        this.allocation = builder.allocation;
        this.close = builder.close;
        this.custom = ApiTypeHelper.unmodifiable(builder.custom);
        this.delete = builder.delete;
        this.forceMerge = builder.forceMerge;
        this.indexPriority = builder.indexPriority;
        this.notification = ApiTypeHelper.unmodifiable(builder.notification);
        this.open = builder.open;
        this.readOnly = builder.readOnly;
        this.readWrite = builder.readWrite;
        this.replicaCount = builder.replicaCount;
        this.retry = builder.retry;
        this.rollover = builder.rollover;
        this.rollup = ApiTypeHelper.unmodifiable(builder.rollup);
        this.shrink = ApiTypeHelper.unmodifiable(builder.shrink);
        this.snapshot = builder.snapshot;
        this.timeout = builder.timeout;
        this.transform = ApiTypeHelper.unmodifiable(builder.transform);
    }

    public static Action of(Function<Builder, ObjectBuilder<Action>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ActionAlias alias() {
        return this.alias;
    }

    @Nullable
    public final ActionAllocation allocation() {
        return this.allocation;
    }

    @Nullable
    public final ActionClose close() {
        return this.close;
    }

    @Nonnull
    public final Map<String, JsonData> custom() {
        return this.custom;
    }

    @Nullable
    public final ActionDelete delete() {
        return this.delete;
    }

    @Nullable
    public final ActionForceMerge forceMerge() {
        return this.forceMerge;
    }

    @Nullable
    public final ActionIndexPriority indexPriority() {
        return this.indexPriority;
    }

    @Nonnull
    public final Map<String, JsonData> notification() {
        return this.notification;
    }

    @Nullable
    public final ActionOpen open() {
        return this.open;
    }

    @Nullable
    public final ActionReadOnly readOnly() {
        return this.readOnly;
    }

    @Nullable
    public final ActionReadWrite readWrite() {
        return this.readWrite;
    }

    @Nullable
    public final ActionReplicaCount replicaCount() {
        return this.replicaCount;
    }

    @Nullable
    public final ActionRetry retry() {
        return this.retry;
    }

    @Nullable
    public final ActionRollover rollover() {
        return this.rollover;
    }

    @Nonnull
    public final Map<String, JsonData> rollup() {
        return this.rollup;
    }

    @Nonnull
    public final Map<String, JsonData> shrink() {
        return this.shrink;
    }

    @Nullable
    public final ActionSnapshot snapshot() {
        return this.snapshot;
    }

    @Nullable
    public final ActionTimeout timeout() {
        return this.timeout;
    }

    @Nonnull
    public final Map<String, JsonData> transform() {
        return this.transform;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.alias != null) {
            generator.writeKey("alias");
            this.alias.serialize(generator, mapper);
        }
        if (this.allocation != null) {
            generator.writeKey("allocation");
            this.allocation.serialize(generator, mapper);
        }
        if (this.close != null) {
            generator.writeKey("close");
            this.close.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.custom)) {
            generator.writeKey("custom");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.custom.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.delete != null) {
            generator.writeKey("delete");
            this.delete.serialize(generator, mapper);
        }
        if (this.forceMerge != null) {
            generator.writeKey("force_merge");
            this.forceMerge.serialize(generator, mapper);
        }
        if (this.indexPriority != null) {
            generator.writeKey("index_priority");
            this.indexPriority.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.notification)) {
            generator.writeKey("notification");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.notification.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.open != null) {
            generator.writeKey("open");
            this.open.serialize(generator, mapper);
        }
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            this.readOnly.serialize(generator, mapper);
        }
        if (this.readWrite != null) {
            generator.writeKey("read_write");
            this.readWrite.serialize(generator, mapper);
        }
        if (this.replicaCount != null) {
            generator.writeKey("replica_count");
            this.replicaCount.serialize(generator, mapper);
        }
        if (this.retry != null) {
            generator.writeKey("retry");
            this.retry.serialize(generator, mapper);
        }
        if (this.rollover != null) {
            generator.writeKey("rollover");
            this.rollover.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.rollup)) {
            generator.writeKey("rollup");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.rollup.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shrink)) {
            generator.writeKey("shrink");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.shrink.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.snapshot != null) {
            generator.writeKey("snapshot");
            this.snapshot.serialize(generator, mapper);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.transform)) {
            generator.writeKey("transform");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.transform.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupActionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::alias, ActionAlias._DESERIALIZER, "alias");
        op.add(Builder::allocation, ActionAllocation._DESERIALIZER, "allocation");
        op.add(Builder::close, ActionClose._DESERIALIZER, "close");
        op.add(Builder::custom, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "custom");
        op.add(Builder::delete, ActionDelete._DESERIALIZER, "delete");
        op.add(Builder::forceMerge, ActionForceMerge._DESERIALIZER, "force_merge");
        op.add(Builder::indexPriority, ActionIndexPriority._DESERIALIZER, "index_priority");
        op.add(Builder::notification, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "notification");
        op.add(Builder::open, ActionOpen._DESERIALIZER, "open");
        op.add(Builder::readOnly, ActionReadOnly._DESERIALIZER, "read_only");
        op.add(Builder::readWrite, ActionReadWrite._DESERIALIZER, "read_write");
        op.add(Builder::replicaCount, ActionReplicaCount._DESERIALIZER, "replica_count");
        op.add(Builder::retry, ActionRetry._DESERIALIZER, "retry");
        op.add(Builder::rollover, ActionRollover._DESERIALIZER, "rollover");
        op.add(Builder::rollup, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "rollup");
        op.add(Builder::shrink, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "shrink");
        op.add(Builder::snapshot, ActionSnapshot._DESERIALIZER, "snapshot");
        op.add(Builder::timeout, ActionTimeout._DESERIALIZER, "timeout");
        op.add(Builder::transform, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transform");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.alias);
        result = 31 * result + Objects.hashCode(this.allocation);
        result = 31 * result + Objects.hashCode(this.close);
        result = 31 * result + Objects.hashCode(this.custom);
        result = 31 * result + Objects.hashCode(this.delete);
        result = 31 * result + Objects.hashCode(this.forceMerge);
        result = 31 * result + Objects.hashCode(this.indexPriority);
        result = 31 * result + Objects.hashCode(this.notification);
        result = 31 * result + Objects.hashCode(this.open);
        result = 31 * result + Objects.hashCode(this.readOnly);
        result = 31 * result + Objects.hashCode(this.readWrite);
        result = 31 * result + Objects.hashCode(this.replicaCount);
        result = 31 * result + Objects.hashCode(this.retry);
        result = 31 * result + Objects.hashCode(this.rollover);
        result = 31 * result + Objects.hashCode(this.rollup);
        result = 31 * result + Objects.hashCode(this.shrink);
        result = 31 * result + Objects.hashCode(this.snapshot);
        result = 31 * result + Objects.hashCode(this.timeout);
        result = 31 * result + Objects.hashCode(this.transform);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Action other = (Action)o;
        return Objects.equals(this.alias, other.alias) && Objects.equals(this.allocation, other.allocation) && Objects.equals(this.close, other.close) && Objects.equals(this.custom, other.custom) && Objects.equals(this.delete, other.delete) && Objects.equals(this.forceMerge, other.forceMerge) && Objects.equals(this.indexPriority, other.indexPriority) && Objects.equals(this.notification, other.notification) && Objects.equals(this.open, other.open) && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.readWrite, other.readWrite) && Objects.equals(this.replicaCount, other.replicaCount) && Objects.equals(this.retry, other.retry) && Objects.equals(this.rollover, other.rollover) && Objects.equals(this.rollup, other.rollup) && Objects.equals(this.shrink, other.shrink) && Objects.equals(this.snapshot, other.snapshot) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.transform, other.transform);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, Action> {
        @Nullable
        private ActionAlias alias;
        @Nullable
        private ActionAllocation allocation;
        @Nullable
        private ActionClose close;
        @Nullable
        private Map<String, JsonData> custom;
        @Nullable
        private ActionDelete delete;
        @Nullable
        private ActionForceMerge forceMerge;
        @Nullable
        private ActionIndexPriority indexPriority;
        @Nullable
        private Map<String, JsonData> notification;
        @Nullable
        private ActionOpen open;
        @Nullable
        private ActionReadOnly readOnly;
        @Nullable
        private ActionReadWrite readWrite;
        @Nullable
        private ActionReplicaCount replicaCount;
        @Nullable
        private ActionRetry retry;
        @Nullable
        private ActionRollover rollover;
        @Nullable
        private Map<String, JsonData> rollup;
        @Nullable
        private Map<String, JsonData> shrink;
        @Nullable
        private ActionSnapshot snapshot;
        @Nullable
        private ActionTimeout timeout;
        @Nullable
        private Map<String, JsonData> transform;

        public Builder() {
        }

        private Builder(Action o) {
            this.alias = o.alias;
            this.allocation = o.allocation;
            this.close = o.close;
            this.custom = Builder._mapCopy(o.custom);
            this.delete = o.delete;
            this.forceMerge = o.forceMerge;
            this.indexPriority = o.indexPriority;
            this.notification = Builder._mapCopy(o.notification);
            this.open = o.open;
            this.readOnly = o.readOnly;
            this.readWrite = o.readWrite;
            this.replicaCount = o.replicaCount;
            this.retry = o.retry;
            this.rollover = o.rollover;
            this.rollup = Builder._mapCopy(o.rollup);
            this.shrink = Builder._mapCopy(o.shrink);
            this.snapshot = o.snapshot;
            this.timeout = o.timeout;
            this.transform = Builder._mapCopy(o.transform);
        }

        private Builder(Builder o) {
            this.alias = o.alias;
            this.allocation = o.allocation;
            this.close = o.close;
            this.custom = Builder._mapCopy(o.custom);
            this.delete = o.delete;
            this.forceMerge = o.forceMerge;
            this.indexPriority = o.indexPriority;
            this.notification = Builder._mapCopy(o.notification);
            this.open = o.open;
            this.readOnly = o.readOnly;
            this.readWrite = o.readWrite;
            this.replicaCount = o.replicaCount;
            this.retry = o.retry;
            this.rollover = o.rollover;
            this.rollup = Builder._mapCopy(o.rollup);
            this.shrink = Builder._mapCopy(o.shrink);
            this.snapshot = o.snapshot;
            this.timeout = o.timeout;
            this.transform = Builder._mapCopy(o.transform);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder alias(@Nullable ActionAlias value) {
            this.alias = value;
            return this;
        }

        @Nonnull
        public final Builder alias(Function<ActionAlias.Builder, ObjectBuilder<ActionAlias>> fn) {
            return this.alias(fn.apply(new ActionAlias.Builder()).build());
        }

        @Nonnull
        public final Builder allocation(@Nullable ActionAllocation value) {
            this.allocation = value;
            return this;
        }

        @Nonnull
        public final Builder allocation(Function<ActionAllocation.Builder, ObjectBuilder<ActionAllocation>> fn) {
            return this.allocation(fn.apply(new ActionAllocation.Builder()).build());
        }

        @Nonnull
        public final Builder close(@Nullable ActionClose value) {
            this.close = value;
            return this;
        }

        @Nonnull
        public final Builder close(Function<ActionClose.Builder, ObjectBuilder<ActionClose>> fn) {
            return this.close(fn.apply(new ActionClose.Builder()).build());
        }

        @Nonnull
        public final Builder custom(Map<String, JsonData> map) {
            this.custom = Builder._mapPutAll(this.custom, map);
            return this;
        }

        @Nonnull
        public final Builder custom(String key, JsonData value) {
            this.custom = Builder._mapPut(this.custom, key, value);
            return this;
        }

        @Nonnull
        public final Builder delete(@Nullable ActionDelete value) {
            this.delete = value;
            return this;
        }

        @Nonnull
        public final Builder delete(Function<ActionDelete.Builder, ObjectBuilder<ActionDelete>> fn) {
            return this.delete(fn.apply(new ActionDelete.Builder()).build());
        }

        @Nonnull
        public final Builder forceMerge(@Nullable ActionForceMerge value) {
            this.forceMerge = value;
            return this;
        }

        @Nonnull
        public final Builder forceMerge(Function<ActionForceMerge.Builder, ObjectBuilder<ActionForceMerge>> fn) {
            return this.forceMerge(fn.apply(new ActionForceMerge.Builder()).build());
        }

        @Nonnull
        public final Builder indexPriority(@Nullable ActionIndexPriority value) {
            this.indexPriority = value;
            return this;
        }

        @Nonnull
        public final Builder indexPriority(Function<ActionIndexPriority.Builder, ObjectBuilder<ActionIndexPriority>> fn) {
            return this.indexPriority(fn.apply(new ActionIndexPriority.Builder()).build());
        }

        @Nonnull
        public final Builder notification(Map<String, JsonData> map) {
            this.notification = Builder._mapPutAll(this.notification, map);
            return this;
        }

        @Nonnull
        public final Builder notification(String key, JsonData value) {
            this.notification = Builder._mapPut(this.notification, key, value);
            return this;
        }

        @Nonnull
        public final Builder open(@Nullable ActionOpen value) {
            this.open = value;
            return this;
        }

        @Nonnull
        public final Builder open(Function<ActionOpen.Builder, ObjectBuilder<ActionOpen>> fn) {
            return this.open(fn.apply(new ActionOpen.Builder()).build());
        }

        @Nonnull
        public final Builder readOnly(@Nullable ActionReadOnly value) {
            this.readOnly = value;
            return this;
        }

        @Nonnull
        public final Builder readOnly(Function<ActionReadOnly.Builder, ObjectBuilder<ActionReadOnly>> fn) {
            return this.readOnly(fn.apply(new ActionReadOnly.Builder()).build());
        }

        @Nonnull
        public final Builder readWrite(@Nullable ActionReadWrite value) {
            this.readWrite = value;
            return this;
        }

        @Nonnull
        public final Builder readWrite(Function<ActionReadWrite.Builder, ObjectBuilder<ActionReadWrite>> fn) {
            return this.readWrite(fn.apply(new ActionReadWrite.Builder()).build());
        }

        @Nonnull
        public final Builder replicaCount(@Nullable ActionReplicaCount value) {
            this.replicaCount = value;
            return this;
        }

        @Nonnull
        public final Builder replicaCount(Function<ActionReplicaCount.Builder, ObjectBuilder<ActionReplicaCount>> fn) {
            return this.replicaCount(fn.apply(new ActionReplicaCount.Builder()).build());
        }

        @Nonnull
        public final Builder retry(@Nullable ActionRetry value) {
            this.retry = value;
            return this;
        }

        @Nonnull
        public final Builder retry(Function<ActionRetry.Builder, ObjectBuilder<ActionRetry>> fn) {
            return this.retry(fn.apply(new ActionRetry.Builder()).build());
        }

        @Nonnull
        public final Builder rollover(@Nullable ActionRollover value) {
            this.rollover = value;
            return this;
        }

        @Nonnull
        public final Builder rollover(Function<ActionRollover.Builder, ObjectBuilder<ActionRollover>> fn) {
            return this.rollover(fn.apply(new ActionRollover.Builder()).build());
        }

        @Nonnull
        public final Builder rollup(Map<String, JsonData> map) {
            this.rollup = Builder._mapPutAll(this.rollup, map);
            return this;
        }

        @Nonnull
        public final Builder rollup(String key, JsonData value) {
            this.rollup = Builder._mapPut(this.rollup, key, value);
            return this;
        }

        @Nonnull
        public final Builder shrink(Map<String, JsonData> map) {
            this.shrink = Builder._mapPutAll(this.shrink, map);
            return this;
        }

        @Nonnull
        public final Builder shrink(String key, JsonData value) {
            this.shrink = Builder._mapPut(this.shrink, key, value);
            return this;
        }

        @Nonnull
        public final Builder snapshot(@Nullable ActionSnapshot value) {
            this.snapshot = value;
            return this;
        }

        @Nonnull
        public final Builder snapshot(Function<ActionSnapshot.Builder, ObjectBuilder<ActionSnapshot>> fn) {
            return this.snapshot(fn.apply(new ActionSnapshot.Builder()).build());
        }

        @Nonnull
        public final Builder timeout(@Nullable ActionTimeout value) {
            this.timeout = value;
            return this;
        }

        @Nonnull
        public final Builder timeout(Function<ActionTimeout.Builder, ObjectBuilder<ActionTimeout>> fn) {
            return this.timeout(fn.apply(new ActionTimeout.Builder()).build());
        }

        @Nonnull
        public final Builder transform(Map<String, JsonData> map) {
            this.transform = Builder._mapPutAll(this.transform, map);
            return this;
        }

        @Nonnull
        public final Builder transform(String key, JsonData value) {
            this.transform = Builder._mapPut(this.transform, key, value);
            return this;
        }

        @Override
        @Nonnull
        public Action build() {
            this._checkSingleUse();
            return new Action(this);
        }
    }
}

