/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CreditSpecification;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.ElasticGpuSpecificationResponseListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceRequirements;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateBlockDeviceMappingListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCapacityReservationSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateCpuOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponse;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateElasticInferenceAcceleratorResponseListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateEnclaveOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateHibernationOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateIamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMaintenanceOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMarketOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceMetadataOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfiguration;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateNetworkPerformanceOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePlacement;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatePrivateDnsNameOptions;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecification;
import software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.LaunchTemplatesMonitoring;
import software.amazon.awssdk.services.ec2.model.OperatorResponse;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseLaunchTemplateData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseLaunchTemplateData> {
    private static final SdkField<String> KERNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KernelId").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::kernelId)).setter(ResponseLaunchTemplateData.setter(Builder::kernelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelId").unmarshallLocationName("kernelId").build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::ebsOptimized)).setter(ResponseLaunchTemplateData.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").unmarshallLocationName("ebsOptimized").build()}).build();
    private static final SdkField<LaunchTemplateIamInstanceProfileSpecification> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::iamInstanceProfile)).setter(ResponseLaunchTemplateData.setter(Builder::iamInstanceProfile)).constructor(LaunchTemplateIamInstanceProfileSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamInstanceProfile").unmarshallLocationName("iamInstanceProfile").build()}).build();
    private static final SdkField<List<LaunchTemplateBlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BlockDeviceMappings").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::blockDeviceMappings)).setter(ResponseLaunchTemplateData.setter(Builder::blockDeviceMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappingSet").unmarshallLocationName("blockDeviceMappingSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateBlockDeviceMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateInstanceNetworkInterfaceSpecification>> NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaces").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::networkInterfaces)).setter(ResponseLaunchTemplateData.setter(Builder::networkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceSet").unmarshallLocationName("networkInterfaceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateInstanceNetworkInterfaceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::imageId)).setter(ResponseLaunchTemplateData.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::instanceTypeAsString)).setter(ResponseLaunchTemplateData.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("instanceType").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyName").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::keyName)).setter(ResponseLaunchTemplateData.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyName").unmarshallLocationName("keyName").build()}).build();
    private static final SdkField<LaunchTemplatesMonitoring> MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Monitoring").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::monitoring)).setter(ResponseLaunchTemplateData.setter(Builder::monitoring)).constructor(LaunchTemplatesMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monitoring").unmarshallLocationName("monitoring").build()}).build();
    private static final SdkField<LaunchTemplatePlacement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Placement").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::placement)).setter(ResponseLaunchTemplateData.setter(Builder::placement)).constructor(LaunchTemplatePlacement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("placement").build()}).build();
    private static final SdkField<String> RAM_DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RamDiskId").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::ramDiskId)).setter(ResponseLaunchTemplateData.setter(Builder::ramDiskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RamDiskId").unmarshallLocationName("ramDiskId").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_TERMINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiTermination").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::disableApiTermination)).setter(ResponseLaunchTemplateData.setter(Builder::disableApiTermination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiTermination").unmarshallLocationName("disableApiTermination").build()}).build();
    private static final SdkField<String> INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceInitiatedShutdownBehavior").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::instanceInitiatedShutdownBehaviorAsString)).setter(ResponseLaunchTemplateData.setter(Builder::instanceInitiatedShutdownBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInitiatedShutdownBehavior").unmarshallLocationName("instanceInitiatedShutdownBehavior").build()}).build();
    private static final SdkField<String> USER_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserData").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::userData)).setter(ResponseLaunchTemplateData.setter(Builder::userData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserData").unmarshallLocationName("userData").build()}).build();
    private static final SdkField<List<LaunchTemplateTagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::tagSpecifications)).setter(ResponseLaunchTemplateData.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecificationSet").unmarshallLocationName("tagSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateTagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ElasticGpuSpecificationResponse>> ELASTIC_GPU_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticGpuSpecifications").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::elasticGpuSpecifications)).setter(ResponseLaunchTemplateData.setter(Builder::elasticGpuSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticGpuSpecificationSet").unmarshallLocationName("elasticGpuSpecificationSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ElasticGpuSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<LaunchTemplateElasticInferenceAcceleratorResponse>> ELASTIC_INFERENCE_ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ElasticInferenceAccelerators").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::elasticInferenceAccelerators)).setter(ResponseLaunchTemplateData.setter(Builder::elasticInferenceAccelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticInferenceAcceleratorSet").unmarshallLocationName("elasticInferenceAcceleratorSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateElasticInferenceAcceleratorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::securityGroupIds)).setter(ResponseLaunchTemplateData.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").unmarshallLocationName("securityGroupIdSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::securityGroups)).setter(ResponseLaunchTemplateData.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupSet").unmarshallLocationName("securityGroupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateInstanceMarketOptions> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceMarketOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::instanceMarketOptions)).setter(ResponseLaunchTemplateData.setter(Builder::instanceMarketOptions)).constructor(LaunchTemplateInstanceMarketOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMarketOptions").unmarshallLocationName("instanceMarketOptions").build()}).build();
    private static final SdkField<CreditSpecification> CREDIT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreditSpecification").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::creditSpecification)).setter(ResponseLaunchTemplateData.setter(Builder::creditSpecification)).constructor(CreditSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreditSpecification").unmarshallLocationName("creditSpecification").build()}).build();
    private static final SdkField<LaunchTemplateCpuOptions> CPU_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CpuOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::cpuOptions)).setter(ResponseLaunchTemplateData.setter(Builder::cpuOptions)).constructor(LaunchTemplateCpuOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuOptions").unmarshallLocationName("cpuOptions").build()}).build();
    private static final SdkField<LaunchTemplateCapacityReservationSpecificationResponse> CAPACITY_RESERVATION_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CapacityReservationSpecification").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::capacityReservationSpecification)).setter(ResponseLaunchTemplateData.setter(Builder::capacityReservationSpecification)).constructor(LaunchTemplateCapacityReservationSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationSpecification").unmarshallLocationName("capacityReservationSpecification").build()}).build();
    private static final SdkField<List<LaunchTemplateLicenseConfiguration>> LICENSE_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LicenseSpecifications").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::licenseSpecifications)).setter(ResponseLaunchTemplateData.setter(Builder::licenseSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseSet").unmarshallLocationName("licenseSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateLicenseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<LaunchTemplateHibernationOptions> HIBERNATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HibernationOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::hibernationOptions)).setter(ResponseLaunchTemplateData.setter(Builder::hibernationOptions)).constructor(LaunchTemplateHibernationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HibernationOptions").unmarshallLocationName("hibernationOptions").build()}).build();
    private static final SdkField<LaunchTemplateInstanceMetadataOptions> METADATA_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::metadataOptions)).setter(ResponseLaunchTemplateData.setter(Builder::metadataOptions)).constructor(LaunchTemplateInstanceMetadataOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataOptions").unmarshallLocationName("metadataOptions").build()}).build();
    private static final SdkField<LaunchTemplateEnclaveOptions> ENCLAVE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EnclaveOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::enclaveOptions)).setter(ResponseLaunchTemplateData.setter(Builder::enclaveOptions)).constructor(LaunchTemplateEnclaveOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnclaveOptions").unmarshallLocationName("enclaveOptions").build()}).build();
    private static final SdkField<InstanceRequirements> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::instanceRequirements)).setter(ResponseLaunchTemplateData.setter(Builder::instanceRequirements)).constructor(InstanceRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("instanceRequirements").build()}).build();
    private static final SdkField<LaunchTemplatePrivateDnsNameOptions> PRIVATE_DNS_NAME_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PrivateDnsNameOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::privateDnsNameOptions)).setter(ResponseLaunchTemplateData.setter(Builder::privateDnsNameOptions)).constructor(LaunchTemplatePrivateDnsNameOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsNameOptions").unmarshallLocationName("privateDnsNameOptions").build()}).build();
    private static final SdkField<LaunchTemplateInstanceMaintenanceOptions> MAINTENANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MaintenanceOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::maintenanceOptions)).setter(ResponseLaunchTemplateData.setter(Builder::maintenanceOptions)).constructor(LaunchTemplateInstanceMaintenanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceOptions").unmarshallLocationName("maintenanceOptions").build()}).build();
    private static final SdkField<Boolean> DISABLE_API_STOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableApiStop").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::disableApiStop)).setter(ResponseLaunchTemplateData.setter(Builder::disableApiStop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableApiStop").unmarshallLocationName("disableApiStop").build()}).build();
    private static final SdkField<OperatorResponse> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::operator)).setter(ResponseLaunchTemplateData.setter(Builder::operator)).constructor(OperatorResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("operator").build()}).build();
    private static final SdkField<LaunchTemplateNetworkPerformanceOptions> NETWORK_PERFORMANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkPerformanceOptions").getter(ResponseLaunchTemplateData.getter(ResponseLaunchTemplateData::networkPerformanceOptions)).setter(ResponseLaunchTemplateData.setter(Builder::networkPerformanceOptions)).constructor(LaunchTemplateNetworkPerformanceOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformanceOptions").unmarshallLocationName("networkPerformanceOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KERNEL_ID_FIELD, EBS_OPTIMIZED_FIELD, IAM_INSTANCE_PROFILE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, NETWORK_INTERFACES_FIELD, IMAGE_ID_FIELD, INSTANCE_TYPE_FIELD, KEY_NAME_FIELD, MONITORING_FIELD, PLACEMENT_FIELD, RAM_DISK_ID_FIELD, DISABLE_API_TERMINATION_FIELD, INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD, USER_DATA_FIELD, TAG_SPECIFICATIONS_FIELD, ELASTIC_GPU_SPECIFICATIONS_FIELD, ELASTIC_INFERENCE_ACCELERATORS_FIELD, SECURITY_GROUP_IDS_FIELD, SECURITY_GROUPS_FIELD, INSTANCE_MARKET_OPTIONS_FIELD, CREDIT_SPECIFICATION_FIELD, CPU_OPTIONS_FIELD, CAPACITY_RESERVATION_SPECIFICATION_FIELD, LICENSE_SPECIFICATIONS_FIELD, HIBERNATION_OPTIONS_FIELD, METADATA_OPTIONS_FIELD, ENCLAVE_OPTIONS_FIELD, INSTANCE_REQUIREMENTS_FIELD, PRIVATE_DNS_NAME_OPTIONS_FIELD, MAINTENANCE_OPTIONS_FIELD, DISABLE_API_STOP_FIELD, OPERATOR_FIELD, NETWORK_PERFORMANCE_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResponseLaunchTemplateData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String kernelId;
    private final Boolean ebsOptimized;
    private final LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;
    private final List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings;
    private final List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces;
    private final String imageId;
    private final String instanceType;
    private final String keyName;
    private final LaunchTemplatesMonitoring monitoring;
    private final LaunchTemplatePlacement placement;
    private final String ramDiskId;
    private final Boolean disableApiTermination;
    private final String instanceInitiatedShutdownBehavior;
    private final String userData;
    private final List<LaunchTemplateTagSpecification> tagSpecifications;
    private final List<ElasticGpuSpecificationResponse> elasticGpuSpecifications;
    private final List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators;
    private final List<String> securityGroupIds;
    private final List<String> securityGroups;
    private final LaunchTemplateInstanceMarketOptions instanceMarketOptions;
    private final CreditSpecification creditSpecification;
    private final LaunchTemplateCpuOptions cpuOptions;
    private final LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification;
    private final List<LaunchTemplateLicenseConfiguration> licenseSpecifications;
    private final LaunchTemplateHibernationOptions hibernationOptions;
    private final LaunchTemplateInstanceMetadataOptions metadataOptions;
    private final LaunchTemplateEnclaveOptions enclaveOptions;
    private final InstanceRequirements instanceRequirements;
    private final LaunchTemplatePrivateDnsNameOptions privateDnsNameOptions;
    private final LaunchTemplateInstanceMaintenanceOptions maintenanceOptions;
    private final Boolean disableApiStop;
    private final OperatorResponse operator;
    private final LaunchTemplateNetworkPerformanceOptions networkPerformanceOptions;

    private ResponseLaunchTemplateData(BuilderImpl builder) {
        this.kernelId = builder.kernelId;
        this.ebsOptimized = builder.ebsOptimized;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.networkInterfaces = builder.networkInterfaces;
        this.imageId = builder.imageId;
        this.instanceType = builder.instanceType;
        this.keyName = builder.keyName;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.ramDiskId = builder.ramDiskId;
        this.disableApiTermination = builder.disableApiTermination;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.userData = builder.userData;
        this.tagSpecifications = builder.tagSpecifications;
        this.elasticGpuSpecifications = builder.elasticGpuSpecifications;
        this.elasticInferenceAccelerators = builder.elasticInferenceAccelerators;
        this.securityGroupIds = builder.securityGroupIds;
        this.securityGroups = builder.securityGroups;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.creditSpecification = builder.creditSpecification;
        this.cpuOptions = builder.cpuOptions;
        this.capacityReservationSpecification = builder.capacityReservationSpecification;
        this.licenseSpecifications = builder.licenseSpecifications;
        this.hibernationOptions = builder.hibernationOptions;
        this.metadataOptions = builder.metadataOptions;
        this.enclaveOptions = builder.enclaveOptions;
        this.instanceRequirements = builder.instanceRequirements;
        this.privateDnsNameOptions = builder.privateDnsNameOptions;
        this.maintenanceOptions = builder.maintenanceOptions;
        this.disableApiStop = builder.disableApiStop;
        this.operator = builder.operator;
        this.networkPerformanceOptions = builder.networkPerformanceOptions;
    }

    public final String kernelId() {
        return this.kernelId;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public final LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final boolean hasBlockDeviceMappings() {
        return this.blockDeviceMappings != null && !(this.blockDeviceMappings instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings() {
        return this.blockDeviceMappings;
    }

    public final boolean hasNetworkInterfaces() {
        return this.networkInterfaces != null && !(this.networkInterfaces instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces() {
        return this.networkInterfaces;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final String keyName() {
        return this.keyName;
    }

    public final LaunchTemplatesMonitoring monitoring() {
        return this.monitoring;
    }

    public final LaunchTemplatePlacement placement() {
        return this.placement;
    }

    public final String ramDiskId() {
        return this.ramDiskId;
    }

    public final Boolean disableApiTermination() {
        return this.disableApiTermination;
    }

    public final ShutdownBehavior instanceInitiatedShutdownBehavior() {
        return ShutdownBehavior.fromValue(this.instanceInitiatedShutdownBehavior);
    }

    public final String instanceInitiatedShutdownBehaviorAsString() {
        return this.instanceInitiatedShutdownBehavior;
    }

    public final String userData() {
        return this.userData;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateTagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final boolean hasElasticGpuSpecifications() {
        return this.elasticGpuSpecifications != null && !(this.elasticGpuSpecifications instanceof SdkAutoConstructList);
    }

    public final List<ElasticGpuSpecificationResponse> elasticGpuSpecifications() {
        return this.elasticGpuSpecifications;
    }

    public final boolean hasElasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators != null && !(this.elasticInferenceAccelerators instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators() {
        return this.elasticInferenceAccelerators;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final LaunchTemplateInstanceMarketOptions instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public final CreditSpecification creditSpecification() {
        return this.creditSpecification;
    }

    public final LaunchTemplateCpuOptions cpuOptions() {
        return this.cpuOptions;
    }

    public final LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification() {
        return this.capacityReservationSpecification;
    }

    public final boolean hasLicenseSpecifications() {
        return this.licenseSpecifications != null && !(this.licenseSpecifications instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateLicenseConfiguration> licenseSpecifications() {
        return this.licenseSpecifications;
    }

    public final LaunchTemplateHibernationOptions hibernationOptions() {
        return this.hibernationOptions;
    }

    public final LaunchTemplateInstanceMetadataOptions metadataOptions() {
        return this.metadataOptions;
    }

    public final LaunchTemplateEnclaveOptions enclaveOptions() {
        return this.enclaveOptions;
    }

    public final InstanceRequirements instanceRequirements() {
        return this.instanceRequirements;
    }

    public final LaunchTemplatePrivateDnsNameOptions privateDnsNameOptions() {
        return this.privateDnsNameOptions;
    }

    public final LaunchTemplateInstanceMaintenanceOptions maintenanceOptions() {
        return this.maintenanceOptions;
    }

    public final Boolean disableApiStop() {
        return this.disableApiStop;
    }

    public final OperatorResponse operator() {
        return this.operator;
    }

    public final LaunchTemplateNetworkPerformanceOptions networkPerformanceOptions() {
        return this.networkPerformanceOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaces() ? this.networkInterfaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        hashCode = 31 * hashCode + Objects.hashCode(this.ramDiskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiTermination());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInitiatedShutdownBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticGpuSpecifications() ? this.elasticGpuSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.creditSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLicenseSpecifications() ? this.licenseSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hibernationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.enclaveOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsNameOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableApiStop());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkPerformanceOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseLaunchTemplateData)) {
            return false;
        }
        ResponseLaunchTemplateData other = (ResponseLaunchTemplateData)obj;
        return Objects.equals(this.kernelId(), other.kernelId()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && this.hasBlockDeviceMappings() == other.hasBlockDeviceMappings() && Objects.equals(this.blockDeviceMappings(), other.blockDeviceMappings()) && this.hasNetworkInterfaces() == other.hasNetworkInterfaces() && Objects.equals(this.networkInterfaces(), other.networkInterfaces()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.keyName(), other.keyName()) && Objects.equals(this.monitoring(), other.monitoring()) && Objects.equals(this.placement(), other.placement()) && Objects.equals(this.ramDiskId(), other.ramDiskId()) && Objects.equals(this.disableApiTermination(), other.disableApiTermination()) && Objects.equals(this.instanceInitiatedShutdownBehaviorAsString(), other.instanceInitiatedShutdownBehaviorAsString()) && Objects.equals(this.userData(), other.userData()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && this.hasElasticGpuSpecifications() == other.hasElasticGpuSpecifications() && Objects.equals(this.elasticGpuSpecifications(), other.elasticGpuSpecifications()) && this.hasElasticInferenceAccelerators() == other.hasElasticInferenceAccelerators() && Objects.equals(this.elasticInferenceAccelerators(), other.elasticInferenceAccelerators()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions()) && Objects.equals(this.creditSpecification(), other.creditSpecification()) && Objects.equals(this.cpuOptions(), other.cpuOptions()) && Objects.equals(this.capacityReservationSpecification(), other.capacityReservationSpecification()) && this.hasLicenseSpecifications() == other.hasLicenseSpecifications() && Objects.equals(this.licenseSpecifications(), other.licenseSpecifications()) && Objects.equals(this.hibernationOptions(), other.hibernationOptions()) && Objects.equals(this.metadataOptions(), other.metadataOptions()) && Objects.equals(this.enclaveOptions(), other.enclaveOptions()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements()) && Objects.equals(this.privateDnsNameOptions(), other.privateDnsNameOptions()) && Objects.equals(this.maintenanceOptions(), other.maintenanceOptions()) && Objects.equals(this.disableApiStop(), other.disableApiStop()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.networkPerformanceOptions(), other.networkPerformanceOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseLaunchTemplateData").add("KernelId", (Object)this.kernelId()).add("EbsOptimized", (Object)this.ebsOptimized()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("BlockDeviceMappings", this.hasBlockDeviceMappings() ? this.blockDeviceMappings() : null).add("NetworkInterfaces", this.hasNetworkInterfaces() ? this.networkInterfaces() : null).add("ImageId", (Object)this.imageId()).add("InstanceType", (Object)this.instanceTypeAsString()).add("KeyName", (Object)this.keyName()).add("Monitoring", (Object)this.monitoring()).add("Placement", (Object)this.placement()).add("RamDiskId", (Object)this.ramDiskId()).add("DisableApiTermination", (Object)this.disableApiTermination()).add("InstanceInitiatedShutdownBehavior", (Object)this.instanceInitiatedShutdownBehaviorAsString()).add("UserData", (Object)(this.userData() == null ? null : "*** Sensitive Data Redacted ***")).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("ElasticGpuSpecifications", this.hasElasticGpuSpecifications() ? this.elasticGpuSpecifications() : null).add("ElasticInferenceAccelerators", this.hasElasticInferenceAccelerators() ? this.elasticInferenceAccelerators() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).add("CreditSpecification", (Object)this.creditSpecification()).add("CpuOptions", (Object)this.cpuOptions()).add("CapacityReservationSpecification", (Object)this.capacityReservationSpecification()).add("LicenseSpecifications", this.hasLicenseSpecifications() ? this.licenseSpecifications() : null).add("HibernationOptions", (Object)this.hibernationOptions()).add("MetadataOptions", (Object)this.metadataOptions()).add("EnclaveOptions", (Object)this.enclaveOptions()).add("InstanceRequirements", (Object)this.instanceRequirements()).add("PrivateDnsNameOptions", (Object)this.privateDnsNameOptions()).add("MaintenanceOptions", (Object)this.maintenanceOptions()).add("DisableApiStop", (Object)this.disableApiStop()).add("Operator", (Object)this.operator()).add("NetworkPerformanceOptions", (Object)this.networkPerformanceOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KernelId": {
                return Optional.ofNullable(clazz.cast(this.kernelId()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "BlockDeviceMappings": {
                return Optional.ofNullable(clazz.cast(this.blockDeviceMappings()));
            }
            case "NetworkInterfaces": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaces()));
            }
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "KeyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
            case "Monitoring": {
                return Optional.ofNullable(clazz.cast(this.monitoring()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
            case "RamDiskId": {
                return Optional.ofNullable(clazz.cast(this.ramDiskId()));
            }
            case "DisableApiTermination": {
                return Optional.ofNullable(clazz.cast(this.disableApiTermination()));
            }
            case "InstanceInitiatedShutdownBehavior": {
                return Optional.ofNullable(clazz.cast(this.instanceInitiatedShutdownBehaviorAsString()));
            }
            case "UserData": {
                return Optional.ofNullable(clazz.cast(this.userData()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "ElasticGpuSpecifications": {
                return Optional.ofNullable(clazz.cast(this.elasticGpuSpecifications()));
            }
            case "ElasticInferenceAccelerators": {
                return Optional.ofNullable(clazz.cast(this.elasticInferenceAccelerators()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "InstanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
            case "CreditSpecification": {
                return Optional.ofNullable(clazz.cast(this.creditSpecification()));
            }
            case "CpuOptions": {
                return Optional.ofNullable(clazz.cast(this.cpuOptions()));
            }
            case "CapacityReservationSpecification": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationSpecification()));
            }
            case "LicenseSpecifications": {
                return Optional.ofNullable(clazz.cast(this.licenseSpecifications()));
            }
            case "HibernationOptions": {
                return Optional.ofNullable(clazz.cast(this.hibernationOptions()));
            }
            case "MetadataOptions": {
                return Optional.ofNullable(clazz.cast(this.metadataOptions()));
            }
            case "EnclaveOptions": {
                return Optional.ofNullable(clazz.cast(this.enclaveOptions()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
            case "PrivateDnsNameOptions": {
                return Optional.ofNullable(clazz.cast(this.privateDnsNameOptions()));
            }
            case "MaintenanceOptions": {
                return Optional.ofNullable(clazz.cast(this.maintenanceOptions()));
            }
            case "DisableApiStop": {
                return Optional.ofNullable(clazz.cast(this.disableApiStop()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "NetworkPerformanceOptions": {
                return Optional.ofNullable(clazz.cast(this.networkPerformanceOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KernelId", KERNEL_ID_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("IamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("BlockDeviceMappingSet", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("NetworkInterfaceSet", NETWORK_INTERFACES_FIELD);
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("KeyName", KEY_NAME_FIELD);
        map.put("Monitoring", MONITORING_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        map.put("RamDiskId", RAM_DISK_ID_FIELD);
        map.put("DisableApiTermination", DISABLE_API_TERMINATION_FIELD);
        map.put("InstanceInitiatedShutdownBehavior", INSTANCE_INITIATED_SHUTDOWN_BEHAVIOR_FIELD);
        map.put("UserData", USER_DATA_FIELD);
        map.put("TagSpecificationSet", TAG_SPECIFICATIONS_FIELD);
        map.put("ElasticGpuSpecificationSet", ELASTIC_GPU_SPECIFICATIONS_FIELD);
        map.put("ElasticInferenceAcceleratorSet", ELASTIC_INFERENCE_ACCELERATORS_FIELD);
        map.put("SecurityGroupIdSet", SECURITY_GROUP_IDS_FIELD);
        map.put("SecurityGroupSet", SECURITY_GROUPS_FIELD);
        map.put("InstanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
        map.put("CreditSpecification", CREDIT_SPECIFICATION_FIELD);
        map.put("CpuOptions", CPU_OPTIONS_FIELD);
        map.put("CapacityReservationSpecification", CAPACITY_RESERVATION_SPECIFICATION_FIELD);
        map.put("LicenseSet", LICENSE_SPECIFICATIONS_FIELD);
        map.put("HibernationOptions", HIBERNATION_OPTIONS_FIELD);
        map.put("MetadataOptions", METADATA_OPTIONS_FIELD);
        map.put("EnclaveOptions", ENCLAVE_OPTIONS_FIELD);
        map.put("InstanceRequirements", INSTANCE_REQUIREMENTS_FIELD);
        map.put("PrivateDnsNameOptions", PRIVATE_DNS_NAME_OPTIONS_FIELD);
        map.put("MaintenanceOptions", MAINTENANCE_OPTIONS_FIELD);
        map.put("DisableApiStop", DISABLE_API_STOP_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("NetworkPerformanceOptions", NETWORK_PERFORMANCE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseLaunchTemplateData, T> g) {
        return obj -> g.apply((ResponseLaunchTemplateData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String kernelId;
        private Boolean ebsOptimized;
        private LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile;
        private List<LaunchTemplateBlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces = DefaultSdkAutoConstructList.getInstance();
        private String imageId;
        private String instanceType;
        private String keyName;
        private LaunchTemplatesMonitoring monitoring;
        private LaunchTemplatePlacement placement;
        private String ramDiskId;
        private Boolean disableApiTermination;
        private String instanceInitiatedShutdownBehavior;
        private String userData;
        private List<LaunchTemplateTagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<ElasticGpuSpecificationResponse> elasticGpuSpecifications = DefaultSdkAutoConstructList.getInstance();
        private List<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateInstanceMarketOptions instanceMarketOptions;
        private CreditSpecification creditSpecification;
        private LaunchTemplateCpuOptions cpuOptions;
        private LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification;
        private List<LaunchTemplateLicenseConfiguration> licenseSpecifications = DefaultSdkAutoConstructList.getInstance();
        private LaunchTemplateHibernationOptions hibernationOptions;
        private LaunchTemplateInstanceMetadataOptions metadataOptions;
        private LaunchTemplateEnclaveOptions enclaveOptions;
        private InstanceRequirements instanceRequirements;
        private LaunchTemplatePrivateDnsNameOptions privateDnsNameOptions;
        private LaunchTemplateInstanceMaintenanceOptions maintenanceOptions;
        private Boolean disableApiStop;
        private OperatorResponse operator;
        private LaunchTemplateNetworkPerformanceOptions networkPerformanceOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseLaunchTemplateData model) {
            this.kernelId(model.kernelId);
            this.ebsOptimized(model.ebsOptimized);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.blockDeviceMappings(model.blockDeviceMappings);
            this.networkInterfaces(model.networkInterfaces);
            this.imageId(model.imageId);
            this.instanceType(model.instanceType);
            this.keyName(model.keyName);
            this.monitoring(model.monitoring);
            this.placement(model.placement);
            this.ramDiskId(model.ramDiskId);
            this.disableApiTermination(model.disableApiTermination);
            this.instanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            this.userData(model.userData);
            this.tagSpecifications(model.tagSpecifications);
            this.elasticGpuSpecifications(model.elasticGpuSpecifications);
            this.elasticInferenceAccelerators(model.elasticInferenceAccelerators);
            this.securityGroupIds(model.securityGroupIds);
            this.securityGroups(model.securityGroups);
            this.instanceMarketOptions(model.instanceMarketOptions);
            this.creditSpecification(model.creditSpecification);
            this.cpuOptions(model.cpuOptions);
            this.capacityReservationSpecification(model.capacityReservationSpecification);
            this.licenseSpecifications(model.licenseSpecifications);
            this.hibernationOptions(model.hibernationOptions);
            this.metadataOptions(model.metadataOptions);
            this.enclaveOptions(model.enclaveOptions);
            this.instanceRequirements(model.instanceRequirements);
            this.privateDnsNameOptions(model.privateDnsNameOptions);
            this.maintenanceOptions(model.maintenanceOptions);
            this.disableApiStop(model.disableApiStop);
            this.operator(model.operator);
            this.networkPerformanceOptions(model.networkPerformanceOptions);
        }

        public final String getKernelId() {
            return this.kernelId;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final LaunchTemplateIamInstanceProfileSpecification.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final List<LaunchTemplateBlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<LaunchTemplateBlockDeviceMapping.Builder> result = LaunchTemplateBlockDeviceMappingListCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = LaunchTemplateBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping ... blockDeviceMappings) {
            this.blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder> ... blockDeviceMappings) {
            this.blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> (LaunchTemplateBlockDeviceMapping)((LaunchTemplateBlockDeviceMapping.Builder)LaunchTemplateBlockDeviceMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> getNetworkInterfaces() {
            List<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> result = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copyToBuilder(this.networkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification.BuilderImpl> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copyFromBuilder(networkInterfaces);
        }

        @Override
        public final Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> networkInterfaces) {
            this.networkInterfaces = LaunchTemplateInstanceNetworkInterfaceSpecificationListCopier.copy(networkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification ... networkInterfaces) {
            this.networkInterfaces(Arrays.asList(networkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> ... networkInterfaces) {
            this.networkInterfaces(Stream.of(networkInterfaces).map(c -> (LaunchTemplateInstanceNetworkInterfaceSpecification)((LaunchTemplateInstanceNetworkInterfaceSpecification.Builder)LaunchTemplateInstanceNetworkInterfaceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public final LaunchTemplatesMonitoring.Builder getMonitoring() {
            return this.monitoring != null ? this.monitoring.toBuilder() : null;
        }

        public final void setMonitoring(LaunchTemplatesMonitoring.BuilderImpl monitoring) {
            this.monitoring = monitoring != null ? monitoring.build() : null;
        }

        @Override
        public final Builder monitoring(LaunchTemplatesMonitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final LaunchTemplatePlacement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        public final void setPlacement(LaunchTemplatePlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(LaunchTemplatePlacement placement) {
            this.placement = placement;
            return this;
        }

        public final String getRamDiskId() {
            return this.ramDiskId;
        }

        public final void setRamDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
        }

        @Override
        public final Builder ramDiskId(String ramDiskId) {
            this.ramDiskId = ramDiskId;
            return this;
        }

        public final Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior == null ? null : instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final String getUserData() {
            return this.userData;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final List<LaunchTemplateTagSpecification.Builder> getTagSpecifications() {
            List<LaunchTemplateTagSpecification.Builder> result = LaunchTemplateTagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<LaunchTemplateTagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> tagSpecifications) {
            this.tagSpecifications = LaunchTemplateTagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(LaunchTemplateTagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (LaunchTemplateTagSpecification)((LaunchTemplateTagSpecification.Builder)LaunchTemplateTagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ElasticGpuSpecificationResponse.Builder> getElasticGpuSpecifications() {
            List<ElasticGpuSpecificationResponse.Builder> result = ElasticGpuSpecificationResponseListCopier.copyToBuilder(this.elasticGpuSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse.BuilderImpl> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copyFromBuilder(elasticGpuSpecifications);
        }

        @Override
        public final Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> elasticGpuSpecifications) {
            this.elasticGpuSpecifications = ElasticGpuSpecificationResponseListCopier.copy(elasticGpuSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Arrays.asList(elasticGpuSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecificationResponse.Builder> ... elasticGpuSpecifications) {
            this.elasticGpuSpecifications(Stream.of(elasticGpuSpecifications).map(c -> (ElasticGpuSpecificationResponse)((ElasticGpuSpecificationResponse.Builder)ElasticGpuSpecificationResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LaunchTemplateElasticInferenceAcceleratorResponse.Builder> getElasticInferenceAccelerators() {
            List<LaunchTemplateElasticInferenceAcceleratorResponse.Builder> result = LaunchTemplateElasticInferenceAcceleratorResponseListCopier.copyToBuilder(this.elasticInferenceAccelerators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAcceleratorResponse.BuilderImpl> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorResponseListCopier.copyFromBuilder(elasticInferenceAccelerators);
        }

        @Override
        public final Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAcceleratorResponse> elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators = LaunchTemplateElasticInferenceAcceleratorResponseListCopier.copy(elasticInferenceAccelerators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAcceleratorResponse ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Arrays.asList(elasticInferenceAccelerators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAcceleratorResponse.Builder> ... elasticInferenceAccelerators) {
            this.elasticInferenceAccelerators(Stream.of(elasticInferenceAccelerators).map(c -> (LaunchTemplateElasticInferenceAcceleratorResponse)((LaunchTemplateElasticInferenceAcceleratorResponse.Builder)LaunchTemplateElasticInferenceAcceleratorResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = ValueStringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ValueStringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final LaunchTemplateInstanceMarketOptions.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(LaunchTemplateInstanceMarketOptions.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final CreditSpecification.Builder getCreditSpecification() {
            return this.creditSpecification != null ? this.creditSpecification.toBuilder() : null;
        }

        public final void setCreditSpecification(CreditSpecification.BuilderImpl creditSpecification) {
            this.creditSpecification = creditSpecification != null ? creditSpecification.build() : null;
        }

        @Override
        public final Builder creditSpecification(CreditSpecification creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        public final LaunchTemplateCpuOptions.Builder getCpuOptions() {
            return this.cpuOptions != null ? this.cpuOptions.toBuilder() : null;
        }

        public final void setCpuOptions(LaunchTemplateCpuOptions.BuilderImpl cpuOptions) {
            this.cpuOptions = cpuOptions != null ? cpuOptions.build() : null;
        }

        @Override
        public final Builder cpuOptions(LaunchTemplateCpuOptions cpuOptions) {
            this.cpuOptions = cpuOptions;
            return this;
        }

        public final LaunchTemplateCapacityReservationSpecificationResponse.Builder getCapacityReservationSpecification() {
            return this.capacityReservationSpecification != null ? this.capacityReservationSpecification.toBuilder() : null;
        }

        public final void setCapacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse.BuilderImpl capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification != null ? capacityReservationSpecification.build() : null;
        }

        @Override
        public final Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse capacityReservationSpecification) {
            this.capacityReservationSpecification = capacityReservationSpecification;
            return this;
        }

        public final List<LaunchTemplateLicenseConfiguration.Builder> getLicenseSpecifications() {
            List<LaunchTemplateLicenseConfiguration.Builder> result = LaunchTemplateLicenseListCopier.copyToBuilder(this.licenseSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLicenseSpecifications(Collection<LaunchTemplateLicenseConfiguration.BuilderImpl> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseListCopier.copyFromBuilder(licenseSpecifications);
        }

        @Override
        public final Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfiguration> licenseSpecifications) {
            this.licenseSpecifications = LaunchTemplateLicenseListCopier.copy(licenseSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(LaunchTemplateLicenseConfiguration ... licenseSpecifications) {
            this.licenseSpecifications(Arrays.asList(licenseSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfiguration.Builder> ... licenseSpecifications) {
            this.licenseSpecifications(Stream.of(licenseSpecifications).map(c -> (LaunchTemplateLicenseConfiguration)((LaunchTemplateLicenseConfiguration.Builder)LaunchTemplateLicenseConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LaunchTemplateHibernationOptions.Builder getHibernationOptions() {
            return this.hibernationOptions != null ? this.hibernationOptions.toBuilder() : null;
        }

        public final void setHibernationOptions(LaunchTemplateHibernationOptions.BuilderImpl hibernationOptions) {
            this.hibernationOptions = hibernationOptions != null ? hibernationOptions.build() : null;
        }

        @Override
        public final Builder hibernationOptions(LaunchTemplateHibernationOptions hibernationOptions) {
            this.hibernationOptions = hibernationOptions;
            return this;
        }

        public final LaunchTemplateInstanceMetadataOptions.Builder getMetadataOptions() {
            return this.metadataOptions != null ? this.metadataOptions.toBuilder() : null;
        }

        public final void setMetadataOptions(LaunchTemplateInstanceMetadataOptions.BuilderImpl metadataOptions) {
            this.metadataOptions = metadataOptions != null ? metadataOptions.build() : null;
        }

        @Override
        public final Builder metadataOptions(LaunchTemplateInstanceMetadataOptions metadataOptions) {
            this.metadataOptions = metadataOptions;
            return this;
        }

        public final LaunchTemplateEnclaveOptions.Builder getEnclaveOptions() {
            return this.enclaveOptions != null ? this.enclaveOptions.toBuilder() : null;
        }

        public final void setEnclaveOptions(LaunchTemplateEnclaveOptions.BuilderImpl enclaveOptions) {
            this.enclaveOptions = enclaveOptions != null ? enclaveOptions.build() : null;
        }

        @Override
        public final Builder enclaveOptions(LaunchTemplateEnclaveOptions enclaveOptions) {
            this.enclaveOptions = enclaveOptions;
            return this;
        }

        public final InstanceRequirements.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirements.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        public final Builder instanceRequirements(InstanceRequirements instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public final LaunchTemplatePrivateDnsNameOptions.Builder getPrivateDnsNameOptions() {
            return this.privateDnsNameOptions != null ? this.privateDnsNameOptions.toBuilder() : null;
        }

        public final void setPrivateDnsNameOptions(LaunchTemplatePrivateDnsNameOptions.BuilderImpl privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions != null ? privateDnsNameOptions.build() : null;
        }

        @Override
        public final Builder privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptions privateDnsNameOptions) {
            this.privateDnsNameOptions = privateDnsNameOptions;
            return this;
        }

        public final LaunchTemplateInstanceMaintenanceOptions.Builder getMaintenanceOptions() {
            return this.maintenanceOptions != null ? this.maintenanceOptions.toBuilder() : null;
        }

        public final void setMaintenanceOptions(LaunchTemplateInstanceMaintenanceOptions.BuilderImpl maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions != null ? maintenanceOptions.build() : null;
        }

        @Override
        public final Builder maintenanceOptions(LaunchTemplateInstanceMaintenanceOptions maintenanceOptions) {
            this.maintenanceOptions = maintenanceOptions;
            return this;
        }

        public final Boolean getDisableApiStop() {
            return this.disableApiStop;
        }

        public final void setDisableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
        }

        @Override
        public final Builder disableApiStop(Boolean disableApiStop) {
            this.disableApiStop = disableApiStop;
            return this;
        }

        public final OperatorResponse.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorResponse.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorResponse operator) {
            this.operator = operator;
            return this;
        }

        public final LaunchTemplateNetworkPerformanceOptions.Builder getNetworkPerformanceOptions() {
            return this.networkPerformanceOptions != null ? this.networkPerformanceOptions.toBuilder() : null;
        }

        public final void setNetworkPerformanceOptions(LaunchTemplateNetworkPerformanceOptions.BuilderImpl networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions != null ? networkPerformanceOptions.build() : null;
        }

        @Override
        public final Builder networkPerformanceOptions(LaunchTemplateNetworkPerformanceOptions networkPerformanceOptions) {
            this.networkPerformanceOptions = networkPerformanceOptions;
            return this;
        }

        public ResponseLaunchTemplateData build() {
            return new ResponseLaunchTemplateData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseLaunchTemplateData> {
        public Builder kernelId(String var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder iamInstanceProfile(LaunchTemplateIamInstanceProfileSpecification var1);

        default public Builder iamInstanceProfile(Consumer<LaunchTemplateIamInstanceProfileSpecification.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((LaunchTemplateIamInstanceProfileSpecification)((LaunchTemplateIamInstanceProfileSpecification.Builder)LaunchTemplateIamInstanceProfileSpecification.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder blockDeviceMappings(Collection<LaunchTemplateBlockDeviceMapping> var1);

        public Builder blockDeviceMappings(LaunchTemplateBlockDeviceMapping ... var1);

        public Builder blockDeviceMappings(Consumer<LaunchTemplateBlockDeviceMapping.Builder> ... var1);

        public Builder networkInterfaces(Collection<LaunchTemplateInstanceNetworkInterfaceSpecification> var1);

        public Builder networkInterfaces(LaunchTemplateInstanceNetworkInterfaceSpecification ... var1);

        public Builder networkInterfaces(Consumer<LaunchTemplateInstanceNetworkInterfaceSpecification.Builder> ... var1);

        public Builder imageId(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder keyName(String var1);

        public Builder monitoring(LaunchTemplatesMonitoring var1);

        default public Builder monitoring(Consumer<LaunchTemplatesMonitoring.Builder> monitoring) {
            return this.monitoring((LaunchTemplatesMonitoring)((LaunchTemplatesMonitoring.Builder)LaunchTemplatesMonitoring.builder().applyMutation(monitoring)).build());
        }

        public Builder placement(LaunchTemplatePlacement var1);

        default public Builder placement(Consumer<LaunchTemplatePlacement.Builder> placement) {
            return this.placement((LaunchTemplatePlacement)((LaunchTemplatePlacement.Builder)LaunchTemplatePlacement.builder().applyMutation(placement)).build());
        }

        public Builder ramDiskId(String var1);

        public Builder disableApiTermination(Boolean var1);

        public Builder instanceInitiatedShutdownBehavior(String var1);

        public Builder instanceInitiatedShutdownBehavior(ShutdownBehavior var1);

        public Builder userData(String var1);

        public Builder tagSpecifications(Collection<LaunchTemplateTagSpecification> var1);

        public Builder tagSpecifications(LaunchTemplateTagSpecification ... var1);

        public Builder tagSpecifications(Consumer<LaunchTemplateTagSpecification.Builder> ... var1);

        public Builder elasticGpuSpecifications(Collection<ElasticGpuSpecificationResponse> var1);

        public Builder elasticGpuSpecifications(ElasticGpuSpecificationResponse ... var1);

        public Builder elasticGpuSpecifications(Consumer<ElasticGpuSpecificationResponse.Builder> ... var1);

        public Builder elasticInferenceAccelerators(Collection<LaunchTemplateElasticInferenceAcceleratorResponse> var1);

        public Builder elasticInferenceAccelerators(LaunchTemplateElasticInferenceAcceleratorResponse ... var1);

        public Builder elasticInferenceAccelerators(Consumer<LaunchTemplateElasticInferenceAcceleratorResponse.Builder> ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder instanceMarketOptions(LaunchTemplateInstanceMarketOptions var1);

        default public Builder instanceMarketOptions(Consumer<LaunchTemplateInstanceMarketOptions.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((LaunchTemplateInstanceMarketOptions)((LaunchTemplateInstanceMarketOptions.Builder)LaunchTemplateInstanceMarketOptions.builder().applyMutation(instanceMarketOptions)).build());
        }

        public Builder creditSpecification(CreditSpecification var1);

        default public Builder creditSpecification(Consumer<CreditSpecification.Builder> creditSpecification) {
            return this.creditSpecification((CreditSpecification)((CreditSpecification.Builder)CreditSpecification.builder().applyMutation(creditSpecification)).build());
        }

        public Builder cpuOptions(LaunchTemplateCpuOptions var1);

        default public Builder cpuOptions(Consumer<LaunchTemplateCpuOptions.Builder> cpuOptions) {
            return this.cpuOptions((LaunchTemplateCpuOptions)((LaunchTemplateCpuOptions.Builder)LaunchTemplateCpuOptions.builder().applyMutation(cpuOptions)).build());
        }

        public Builder capacityReservationSpecification(LaunchTemplateCapacityReservationSpecificationResponse var1);

        default public Builder capacityReservationSpecification(Consumer<LaunchTemplateCapacityReservationSpecificationResponse.Builder> capacityReservationSpecification) {
            return this.capacityReservationSpecification((LaunchTemplateCapacityReservationSpecificationResponse)((LaunchTemplateCapacityReservationSpecificationResponse.Builder)LaunchTemplateCapacityReservationSpecificationResponse.builder().applyMutation(capacityReservationSpecification)).build());
        }

        public Builder licenseSpecifications(Collection<LaunchTemplateLicenseConfiguration> var1);

        public Builder licenseSpecifications(LaunchTemplateLicenseConfiguration ... var1);

        public Builder licenseSpecifications(Consumer<LaunchTemplateLicenseConfiguration.Builder> ... var1);

        public Builder hibernationOptions(LaunchTemplateHibernationOptions var1);

        default public Builder hibernationOptions(Consumer<LaunchTemplateHibernationOptions.Builder> hibernationOptions) {
            return this.hibernationOptions((LaunchTemplateHibernationOptions)((LaunchTemplateHibernationOptions.Builder)LaunchTemplateHibernationOptions.builder().applyMutation(hibernationOptions)).build());
        }

        public Builder metadataOptions(LaunchTemplateInstanceMetadataOptions var1);

        default public Builder metadataOptions(Consumer<LaunchTemplateInstanceMetadataOptions.Builder> metadataOptions) {
            return this.metadataOptions((LaunchTemplateInstanceMetadataOptions)((LaunchTemplateInstanceMetadataOptions.Builder)LaunchTemplateInstanceMetadataOptions.builder().applyMutation(metadataOptions)).build());
        }

        public Builder enclaveOptions(LaunchTemplateEnclaveOptions var1);

        default public Builder enclaveOptions(Consumer<LaunchTemplateEnclaveOptions.Builder> enclaveOptions) {
            return this.enclaveOptions((LaunchTemplateEnclaveOptions)((LaunchTemplateEnclaveOptions.Builder)LaunchTemplateEnclaveOptions.builder().applyMutation(enclaveOptions)).build());
        }

        public Builder instanceRequirements(InstanceRequirements var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirements.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirements)((InstanceRequirements.Builder)InstanceRequirements.builder().applyMutation(instanceRequirements)).build());
        }

        public Builder privateDnsNameOptions(LaunchTemplatePrivateDnsNameOptions var1);

        default public Builder privateDnsNameOptions(Consumer<LaunchTemplatePrivateDnsNameOptions.Builder> privateDnsNameOptions) {
            return this.privateDnsNameOptions((LaunchTemplatePrivateDnsNameOptions)((LaunchTemplatePrivateDnsNameOptions.Builder)LaunchTemplatePrivateDnsNameOptions.builder().applyMutation(privateDnsNameOptions)).build());
        }

        public Builder maintenanceOptions(LaunchTemplateInstanceMaintenanceOptions var1);

        default public Builder maintenanceOptions(Consumer<LaunchTemplateInstanceMaintenanceOptions.Builder> maintenanceOptions) {
            return this.maintenanceOptions((LaunchTemplateInstanceMaintenanceOptions)((LaunchTemplateInstanceMaintenanceOptions.Builder)LaunchTemplateInstanceMaintenanceOptions.builder().applyMutation(maintenanceOptions)).build());
        }

        public Builder disableApiStop(Boolean var1);

        public Builder operator(OperatorResponse var1);

        default public Builder operator(Consumer<OperatorResponse.Builder> operator) {
            return this.operator((OperatorResponse)((OperatorResponse.Builder)OperatorResponse.builder().applyMutation(operator)).build());
        }

        public Builder networkPerformanceOptions(LaunchTemplateNetworkPerformanceOptions var1);

        default public Builder networkPerformanceOptions(Consumer<LaunchTemplateNetworkPerformanceOptions.Builder> networkPerformanceOptions) {
            return this.networkPerformanceOptions((LaunchTemplateNetworkPerformanceOptions)((LaunchTemplateNetworkPerformanceOptions.Builder)LaunchTemplateNetworkPerformanceOptions.builder().applyMutation(networkPerformanceOptions)).build());
        }
    }
}

