/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.metamodel.EntityType;
import java.util.Map;
import java.util.Set;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaCriteriaBase;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.tree.AbstractSqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;

public abstract class AbstractSqmRestrictedDmlStatement<T>
extends AbstractSqmDmlStatement<T>
implements JpaCriteriaBase {
    private SqmWhereClause whereClause;

    public AbstractSqmRestrictedDmlStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(querySource, nodeBuilder);
    }

    public AbstractSqmRestrictedDmlStatement(SqmRoot<T> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(target, querySource, nodeBuilder);
    }

    protected AbstractSqmRestrictedDmlStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<T> target) {
        super(builder, querySource, parameters, cteStatements, target);
    }

    protected SqmWhereClause copyWhereClause(SqmCopyContext context) {
        if (this.getWhereClause() == null) {
            return null;
        }
        SqmWhereClause whereClause = new SqmWhereClause(this.nodeBuilder());
        SqmPredicate predicate = this.getWhereClause().getPredicate();
        whereClause.setPredicate(predicate == null ? null : predicate.copy(context));
        return whereClause;
    }

    public SqmRoot<T> from(Class<T> entityClass) {
        return this.from(this.nodeBuilder().getDomainModel().entity(entityClass));
    }

    public SqmRoot<T> from(EntityType<T> entity) {
        EntityDomainType entityDomainType = (EntityDomainType)entity;
        JpaRoot root = this.getTarget();
        if (((SqmRoot)root).getModel() != entity) {
            throw new IllegalArgumentException(String.format("Expecting DML target entity type [%s] but got [%s]", ((SqmRoot)root).getModel().getHibernateEntityName(), entityDomainType.getName()));
        }
        return root;
    }

    public SqmRoot<T> getRoot() {
        return this.getTarget();
    }

    public SqmWhereClause getWhereClause() {
        return this.whereClause;
    }

    public void applyPredicate(SqmPredicate predicate) {
        if (predicate != null) {
            this.initAndGetWhereClause().applyPredicate(predicate);
        }
    }

    public void setWhereClause(SqmWhereClause whereClause) {
        this.whereClause = whereClause;
    }

    @Override
    public JpaPredicate getRestriction() {
        return this.whereClause == null ? null : this.whereClause.getPredicate();
    }

    protected void setWhere(Expression<Boolean> restriction) {
        this.initAndGetWhereClause().setPredicate((SqmPredicate)restriction);
    }

    protected SqmWhereClause initAndGetWhereClause() {
        if (this.whereClause == null) {
            this.whereClause = new SqmWhereClause(this.nodeBuilder());
        }
        return this.whereClause;
    }

    protected void setWhere(Predicate ... restrictions) {
        SqmWhereClause whereClause = this.initAndGetWhereClause();
        whereClause.setPredicate(null);
        for (Predicate restriction : restrictions) {
            whereClause.applyPredicate((SqmPredicate)restriction);
        }
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        if (this.whereClause != null && this.whereClause.getPredicate() != null) {
            hql.append(" where ");
            this.whereClause.getPredicate().appendHqlString(hql, context);
        }
    }
}

