/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.List;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.ScriptBasedOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.UserPropertyMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.representations.provider.ScriptProviderMetadata;

public class DeployedScriptOIDCProtocolMapper
extends ScriptBasedOIDCProtocolMapper {
    private List<ProviderConfigProperty> configProperties;
    protected ScriptProviderMetadata metadata;

    public DeployedScriptOIDCProtocolMapper(ScriptProviderMetadata metadata) {
        this.metadata = metadata;
    }

    public DeployedScriptOIDCProtocolMapper() {
    }

    @Override
    public String getId() {
        return this.metadata.getId();
    }

    @Override
    public String getDisplayType() {
        return this.metadata.getName();
    }

    @Override
    public String getHelpText() {
        return this.metadata.getDescription();
    }

    @Override
    protected String getScriptCode(ProtocolMapperModel mapperModel) {
        return this.metadata.getCode();
    }

    @Override
    public void init(Config.Scope config) {
        this.configProperties = ProviderConfigurationBuilder.create().property().name("multivalued").label("multivalued.label").helpText("multivalued.tooltip").type("boolean").defaultValue((Object)false).add().build();
        OIDCAttributeMapperHelper.addAttributeConfig(this.configProperties, UserPropertyMapper.class);
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return this.configProperties;
    }

    @Override
    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.SCRIPTS);
    }

    public void setMetadata(ScriptProviderMetadata metadata) {
        this.metadata = metadata;
    }

    public ScriptProviderMetadata getMetadata() {
        return this.metadata;
    }
}

