/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayContainsUnnestFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBArrayContainsOperatorFunction
extends ArrayContainsUnnestFunction {
    public GaussDBArrayContainsOperatorFunction(boolean nullable, TypeConfiguration typeConfiguration) {
        super(nullable, typeConfiguration);
    }

    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        JdbcMapping needleType;
        Expression haystackExpression = (Expression)sqlAstArguments.get(0);
        Expression needleExpression = (Expression)sqlAstArguments.get(1);
        JdbcMappingContainer needleTypeContainer = needleExpression.getExpressionType();
        JdbcMapping jdbcMapping = needleType = needleTypeContainer == null ? null : needleTypeContainer.getSingleJdbcMapping();
        if (needleType == null || needleType instanceof BasicPluralType) {
            LOG.deprecatedArrayContainsWithArray();
            if (this.nullable) {
                super.render(sqlAppender, sqlAstArguments, returnType, walker);
            } else {
                haystackExpression.accept(walker);
                sqlAppender.append((CharSequence)"@>");
                needleExpression.accept(walker);
            }
        } else if (this.nullable) {
            sqlAppender.append((CharSequence)"(array_positions(");
            haystackExpression.accept(walker);
            sqlAppender.append(',');
            needleExpression.accept(walker);
            sqlAppender.append((CharSequence)"))[1] is not null");
        } else {
            haystackExpression.accept(walker);
            sqlAppender.append((CharSequence)"@>");
            if (GaussDBArrayContainsOperatorFunction.needsArrayCasting(needleExpression)) {
                sqlAppender.append((CharSequence)"cast(array[");
                needleExpression.accept(walker);
                sqlAppender.append((CharSequence)"] as ");
                sqlAppender.append((CharSequence)DdlTypeHelper.getCastTypeName((JdbcMappingContainer)haystackExpression.getExpressionType(), (TypeConfiguration)walker.getSessionFactory().getTypeConfiguration()));
                sqlAppender.append(')');
            } else {
                sqlAppender.append((CharSequence)"array[");
                needleExpression.accept(walker);
                sqlAppender.append(']');
            }
        }
    }

    private static boolean needsArrayCasting(Expression elementExpression) {
        return elementExpression.getExpressionType().getSingleJdbcMapping().getJdbcType().isString();
    }
}

