/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.agroal.spi.JdbcDataSourceBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.ScopeInfo;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.gizmo.ClassTransformer;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.hibernate.orm.PersistenceUnit;
import io.quarkus.hibernate.orm.deployment.ClassNames;
import io.quarkus.hibernate.orm.deployment.HibernateOrmEnabled;
import io.quarkus.hibernate.orm.deployment.ImpliedBlockingPersistenceUnitTypeBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelBuildItem;
import io.quarkus.hibernate.orm.deployment.JpaModelIndexBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.util.HibernateProcessorUtil;
import io.quarkus.hibernate.orm.runtime.HibernateOrmRecorder;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.RequestScopedStatelessSessionHolder;
import io.quarkus.hibernate.orm.runtime.TransactionSessions;
import io.quarkus.hibernate.orm.runtime.cdi.QuarkusArcBeanContainer;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.inject.Singleton;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Cache;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.query.criteria.HibernateCriteriaBuilder;
import org.hibernate.relational.SchemaManager;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;

@BuildSteps(onlyIf={HibernateOrmEnabled.class})
public class HibernateOrmCdiProcessor {
    private static final List<DotName> SESSION_FACTORY_EXPOSED_TYPES = Arrays.asList(ClassNames.ENTITY_MANAGER_FACTORY, ClassNames.SESSION_FACTORY);
    private static final List<DotName> SESSION_EXPOSED_TYPES = Arrays.asList(ClassNames.ENTITY_MANAGER, ClassNames.SESSION);
    private static final List<DotName> STATELESS_SESSION_EXPOSED_TYPES = List.of(ClassNames.STATELESS_SESSION);
    private static final List<DotName> CRITERIA_BUILDER_EXPOSED_TYPES = List.of(ClassNames.CRITERIA_BUILDER, ClassNames.HIBERNATE_CRITERIA_BUILDER);
    private static final List<DotName> METAMODEL_EXPOSED_TYPES = List.of(ClassNames.METAMODEL);
    private static final List<DotName> SCHEMA_MANAGER_EXPOSED_TYPES = List.of(ClassNames.SCHEMA_MANAGER, ClassNames.HIBERNATE_SCHEMA_MANAGER);
    private static final List<DotName> CACHE_EXPOSED_TYPES = List.of(ClassNames.CACHE, ClassNames.HIBERNATE_CACHE);
    private static final List<DotName> PERSISTENCE_UNIT_UTIL_EXPOSED_TYPES = List.of(ClassNames.PERSISTENCE_UNIT_UTIL);
    private static final Set<DotName> PERSISTENCE_UNIT_EXTENSION_VALID_TYPES = Set.of(ClassNames.TENANT_RESOLVER, ClassNames.TENANT_CONNECTION_RESOLVER, ClassNames.INTERCEPTOR, ClassNames.STATEMENT_INSPECTOR, ClassNames.FORMAT_MAPPER);

    @BuildStep
    AnnotationsTransformerBuildItem convertJpaResourceAnnotationsToQualifier(final List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, final ImpliedBlockingPersistenceUnitTypeBuildItem impliedBlockingPersistenceUnitType) {
        AnnotationsTransformer transformer = new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.FIELD;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                DotName jpaAnnotation;
                FieldInfo field = transformationContext.getTarget().asField();
                DotName fieldTypeName = field.type().name();
                if (!SESSION_EXPOSED_TYPES.contains(fieldTypeName) && !SESSION_FACTORY_EXPOSED_TYPES.contains(fieldTypeName)) {
                    return;
                }
                if (field.hasAnnotation(ClassNames.JPA_PERSISTENCE_UNIT)) {
                    jpaAnnotation = ClassNames.JPA_PERSISTENCE_UNIT;
                } else if (field.hasAnnotation(ClassNames.JPA_PERSISTENCE_CONTEXT)) {
                    jpaAnnotation = ClassNames.JPA_PERSISTENCE_CONTEXT;
                } else {
                    return;
                }
                AnnotationValue persistenceUnitNameAnnotationValue = field.annotation(jpaAnnotation).value("unitName");
                Transformation transformation = transformationContext.transform().add(DotNames.INJECT, new AnnotationValue[0]);
                if (persistenceUnitNameAnnotationValue == null || persistenceUnitNameAnnotationValue.asString().isEmpty()) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else if (persistenceUnitDescriptors.size() == 1 && !impliedBlockingPersistenceUnitType.shouldGenerateImpliedBlockingPersistenceUnit() && ((PersistenceUnitDescriptorBuildItem)((Object)persistenceUnitDescriptors.get(0))).getPersistenceUnitName().equals(persistenceUnitNameAnnotationValue.asString())) {
                    transformation.add(DotNames.DEFAULT, new AnnotationValue[0]);
                } else {
                    transformation.add(ClassNames.QUARKUS_PERSISTENCE_UNIT, new AnnotationValue[]{AnnotationValue.createStringValue((String)"value", (String)persistenceUnitNameAnnotationValue.asString())});
                }
                transformation.done();
            }
        };
        return new AnnotationsTransformerBuildItem((AnnotationTransformation)transformer);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void generateJpaConfigBean(HibernateOrmRecorder recorder, Capabilities capabilities, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(JPAConfig.class).addType(JPAConfig.class)).scope(Singleton.class)).unremovable()).setRuntimeInit().supplier(recorder.jpaConfigSupplier());
        syntheticBeanBuildItemBuildProducer.produce((BuildItem)configurator.done());
    }

    @Record(value=ExecutionTime.RUNTIME_INIT)
    @Consume(value=JdbcDataSourceBuildItem.class)
    @BuildStep
    void generateHibernateBeans(HibernateOrmRecorder recorder, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptors, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItemBuildProducer) {
        if (persistenceUnitDescriptors.isEmpty()) {
            return;
        }
        Function<String, AnnotationInstance> createPersistenceUnitQualifier = puName -> AnnotationInstance.builder(PersistenceUnit.class).add("value", puName).build();
        AnnotationInstance defaultQualifierInstance = AnnotationInstance.builder(Default.class).build();
        if (persistenceUnitDescriptors.size() == 1 && persistenceUnitDescriptors.get(0).isFromPersistenceXml()) {
            String persistenceUnitName = persistenceUnitDescriptors.get(0).getPersistenceUnitName();
            this.produceSessionFactoryBean(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, true, true);
            this.produceSessionBeans(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, true, true);
            this.produceFactoryDependentBeans(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, true, true, defaultQualifierInstance);
            return;
        }
        for (PersistenceUnitDescriptorBuildItem persistenceUnitDescriptor : persistenceUnitDescriptors) {
            if (persistenceUnitDescriptor.isReactive()) continue;
            String persistenceUnitName = persistenceUnitDescriptor.getPersistenceUnitName();
            boolean isDefaultPU = io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil.isDefaultPersistenceUnit((String)persistenceUnitName);
            boolean isNamedPU = !isDefaultPU;
            AnnotationInstance sessionFactoryQualifier = isDefaultPU ? defaultQualifierInstance : createPersistenceUnitQualifier.apply(persistenceUnitName);
            this.produceSessionFactoryBean(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, isDefaultPU, isNamedPU);
            this.produceSessionBeans(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, isDefaultPU, isNamedPU);
            this.produceFactoryDependentBeans(syntheticBeanBuildItemBuildProducer, recorder, persistenceUnitName, isDefaultPU, isNamedPU, sessionFactoryQualifier);
        }
    }

    @BuildStep
    void registerBeans(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, Capabilities capabilities, JpaModelBuildItem jpaModel) {
        if (!HibernateProcessorUtil.hasEntities(jpaModel)) {
            return;
        }
        ArrayList<Class<RequestScopedStatelessSessionHolder>> unremovableClasses = new ArrayList<Class<RequestScopedStatelessSessionHolder>>();
        unremovableClasses.add(QuarkusArcBeanContainer.class);
        if (capabilities.isPresent("io.quarkus.transactions")) {
            unremovableClasses.add(TransactionManager.class);
            unremovableClasses.add(TransactionSessions.class);
            unremovableClasses.add(RequestScopedSessionHolder.class);
            unremovableClasses.add(RequestScopedStatelessSessionHolder.class);
        }
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().setUnremovable().addBeanClasses(unremovableClasses.toArray(new Class[unremovableClasses.size()])).build());
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes((Class[])new Class[]{AttributeConverter.class}));
        unremovableBeans.produce((BuildItem)UnremovableBeanBuildItem.beanTypes(jpaModel.getPotentialCdiBeanClassNames()));
    }

    @BuildStep
    void transformBeans(JpaModelBuildItem jpaModel, JpaModelIndexBuildItem indexBuildItem, BeanDiscoveryFinishedBuildItem beans, BuildProducer<BytecodeTransformerBuildItem> producer) {
        if (!HibernateProcessorUtil.hasEntities(jpaModel)) {
            return;
        }
        CompositeIndex index = indexBuildItem.getIndex();
        for (DotName dotName : jpaModel.getPotentialCdiBeanClassNames()) {
            if (jpaModel.getManagedClassNames().contains(dotName.toString())) continue;
            ClassInfo classInfo = index.getClassByName(dotName);
            List<BeanInfo> matchingBeans = beans.getBeans().stream().filter(bi -> bi.getBeanClass().equals((Object)dotName)).toList();
            if (matchingBeans.size() != 1) continue;
            ScopeInfo beanScope = matchingBeans.get(0).getScope();
            for (DotName jpaListenerDotName : ClassNames.JPA_LISTENER_ANNOTATIONS) {
                for (AnnotationInstance annotationInstance : classInfo.annotations(jpaListenerDotName)) {
                    MethodInfo method;
                    AnnotationTarget target = annotationInstance.target();
                    if (target.kind() != AnnotationTarget.Kind.METHOD || !Modifier.isPrivate((method = target.asMethod()).flags())) continue;
                    if (beanScope.getDotName().equals((Object)BuiltinScope.SINGLETON.getName())) {
                        producer.produce((BuildItem)new BytecodeTransformerBuildItem(method.declaringClass().name().toString(), (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                            @Override
                            public ClassVisitor apply(String cls, ClassVisitor clsVisitor) {
                                ClassTransformer classTransformer = new ClassTransformer(cls);
                                classTransformer.modifyMethod(MethodDescriptor.of((MethodInfo)method)).removeModifiers(2);
                                return classTransformer.applyTo(clsVisitor);
                            }
                        }));
                        continue;
                    }
                    throw new IllegalArgumentException("Methods that are annotated with JPA Listener annotations should not be private. Offending method is '" + String.valueOf(method.declaringClass().name()) + "#" + method.name() + "'");
                }
            }
        }
    }

    @BuildStep
    void registerAnnotations(BuildProducer<AdditionalBeanBuildItem> additionalBeans, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotations) {
        additionalBeans.produce((BuildItem)AdditionalBeanBuildItem.builder().addBeanClasses(new String[]{ClassNames.QUARKUS_PERSISTENCE_UNIT.toString(), ClassNames.PERSISTENCE_UNIT_EXTENSION.toString(), ClassNames.JSON_FORMAT.toString(), ClassNames.XML_FORMAT.toString()}).build());
        beanDefiningAnnotations.produce((BuildItem)new BeanDefiningAnnotationBuildItem(ClassNames.PERSISTENCE_UNIT_EXTENSION, DotNames.APPLICATION_SCOPED, false));
    }

    @BuildStep
    void validatePersistenceUnitExtensions(ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> errors) {
        List throwables = validationPhase.getContext().beans().withQualifier(new DotName[]{ClassNames.PERSISTENCE_UNIT_EXTENSION}).filter(beanInfo -> beanInfo.getTypes().stream().map(Type::name).noneMatch(PERSISTENCE_UNIT_EXTENSION_VALID_TYPES::contains)).stream().map(beanInfo -> new IllegalStateException(String.format(Locale.ROOT, "A @%s bean must implement one or more of the following types: %s. Invalid bean: %s", DotNames.simpleName((DotName)ClassNames.PERSISTENCE_UNIT_EXTENSION), PERSISTENCE_UNIT_EXTENSION_VALID_TYPES, beanInfo))).collect(Collectors.toList());
        if (!throwables.isEmpty()) {
            errors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(throwables));
        }
    }

    private static <T> SyntheticBeanBuildItem.ExtendedBeanConfigurator createSyntheticBean(String persistenceUnitName, boolean isDefaultPersistenceUnit, boolean isNamedPersistenceUnit, Class<T> type, List<DotName> allExposedTypes, boolean defaultBean) {
        SyntheticBeanBuildItem.ExtendedBeanConfigurator configurator = ((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(type).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit();
        for (DotName exposedType : allExposedTypes) {
            configurator.addType(exposedType);
        }
        if (defaultBean) {
            configurator.defaultBean();
        }
        if (isDefaultPersistenceUnit) {
            configurator.addQualifier(Default.class);
        }
        if (isNamedPersistenceUnit) {
            configurator.addQualifier().annotation(DotNames.NAMED).addValue("value", (Object)persistenceUnitName).done();
            configurator.addQualifier().annotation(PersistenceUnit.class).addValue("value", (Object)persistenceUnitName).done();
        }
        return configurator;
    }

    private void produceSessionBeans(BuildProducer<SyntheticBeanBuildItem> producer, HibernateOrmRecorder recorder, String persistenceUnitName, boolean isDefaultPU, boolean isNamedPU) {
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, Session.class, SESSION_EXPOSED_TYPES, false).createWith(recorder.sessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, StatelessSession.class, STATELESS_SESSION_EXPOSED_TYPES, false).createWith(recorder.statelessSessionSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(TransactionSessions.class)), new AnnotationInstance[0])).done());
    }

    private void produceSessionFactoryBean(BuildProducer<SyntheticBeanBuildItem> producer, HibernateOrmRecorder recorder, String persistenceUnitName, boolean isDefaultPU, boolean isNamedPU) {
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, SessionFactory.class, SESSION_FACTORY_EXPOSED_TYPES, true).createWith(recorder.sessionFactorySupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(JPAConfig.class)), new AnnotationInstance[0])).done());
    }

    private void produceFactoryDependentBeans(BuildProducer<SyntheticBeanBuildItem> producer, HibernateOrmRecorder recorder, String persistenceUnitName, boolean isDefaultPU, boolean isNamedPU, AnnotationInstance sessionFactoryQualifier) {
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, HibernateCriteriaBuilder.class, CRITERIA_BUILDER_EXPOSED_TYPES, false).createWith(recorder.criteriaBuilderSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(SessionFactory.class)), new AnnotationInstance[]{sessionFactoryQualifier})).done());
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, Metamodel.class, METAMODEL_EXPOSED_TYPES, false).createWith(recorder.metamodelSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(SessionFactory.class)), new AnnotationInstance[]{sessionFactoryQualifier})).done());
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, SchemaManager.class, SCHEMA_MANAGER_EXPOSED_TYPES, false).createWith(recorder.schemaManagerSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(SessionFactory.class)), new AnnotationInstance[]{sessionFactoryQualifier})).done());
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, Cache.class, CACHE_EXPOSED_TYPES, false).createWith(recorder.cacheSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(SessionFactory.class)), new AnnotationInstance[]{sessionFactoryQualifier})).done());
        producer.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)HibernateOrmCdiProcessor.createSyntheticBean(persistenceUnitName, isDefaultPU, isNamedPU, PersistenceUnitUtil.class, PERSISTENCE_UNIT_UTIL_EXPOSED_TYPES, false).createWith(recorder.persistenceUnitUtilSupplier(persistenceUnitName)).addInjectionPoint((Type)ClassType.create((DotName)DotName.createSimple(SessionFactory.class)), new AnnotationInstance[]{sessionFactoryQualifier})).done());
    }
}

